# 画面設計書 26-Zen画面

## 概要

本ドキュメントは、Zigコンパイラの `zig zen` コマンドによるZen画面の設計仕様を定義する。この画面は、Zig言語の設計哲学「Zen of Zig」を表示するイースターエッグ的な機能を提供する。

### 本画面の処理概要

Zen画面は、Zig言語の設計哲学を箇条書きで表示するシンプルなコマンドである。Pythonの「The Zen of Python」にインスパイアされたこの機能は、Zigの設計原則を開発者に伝える教育的な目的を持つ。

**業務上の目的・背景**：Zig言語は特定の設計哲学に基づいて開発されており、その原則を理解することは効果的なZigプログラミングに役立つ。この画面は、言語の設計思想を簡潔に伝えるドキュメントとして機能し、新しいZig開発者がコミュニティの価値観を理解する助けとなる。

**画面へのアクセス方法**：ターミナルから `zig zen` コマンドを実行することでアクセスする。追加のオプションや引数は不要で、即座にZenが表示される。

**主要な操作・処理内容**：
1. `dev.check(.zen_command)` で機能の有効性を確認
2. コンパイル時定数 `info_zen` を取得
3. Zen文字列を標準出力に出力

**画面遷移**：本コマンドは独立した情報表示機能であり、他の画面への遷移は発生しない。

**権限による表示制御**：特に権限による制御は行われない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 28 | zen | 主機能 | Zigの禅（設計哲学）の表示処理 |

## 画面種別

情報表示（CLI出力）

## URL/ルーティング

コマンド: `zig zen`

## 入出力項目

### 入力項目

| No | 項目名 | 型 | 必須 | 説明 |
|----|--------|-----|------|------|
| - | なし | - | - | このコマンドは入力引数を受け取らない |

## 表示項目

| No | 項目名 | 説明 |
|----|--------|------|
| 1 | Zen of Zig | Zig言語の設計哲学を箇条書きで表示 |

### 出力内容

```
 * Communicate intent precisely.
 * Edge cases matter.
 * Favor reading code over writing code.
 * Only one obvious way to do things.
 * Runtime crashes are better than bugs.
 * Compile errors are better than runtime crashes.
 * Incremental improvements.
 * Avoid local maximums.
 * Reduce the amount one must remember.
 * Focus on code rather than style.
 * Resource allocation may fail; resource deallocation must succeed.
 * Memory is a resource.
 * Together we serve the users.
```

### Zen各項目の意味

| 項目 | 意味 |
|------|------|
| Communicate intent precisely | 意図を正確に伝える |
| Edge cases matter | エッジケースを重視する |
| Favor reading code over writing code | コードを書くよりも読むことを優先する |
| Only one obvious way to do things | 物事を行う明白な方法は一つだけ |
| Runtime crashes are better than bugs | バグよりも実行時クラッシュの方がマシ |
| Compile errors are better than runtime crashes | 実行時クラッシュよりもコンパイルエラーの方がマシ |
| Incremental improvements | 漸進的な改善 |
| Avoid local maximums | 局所最適を避ける |
| Reduce the amount one must remember | 覚えるべき量を減らす |
| Focus on code rather than style | スタイルよりもコードに集中する |
| Resource allocation may fail; resource deallocation must succeed | リソース確保は失敗しうるが、解放は必ず成功しなければならない |
| Memory is a resource | メモリはリソースである |
| Together we serve the users | 共にユーザーに奉仕する |

## イベント仕様

### 1-コマンド実行

ユーザーが `zig zen` を実行すると、以下の処理が順次実行される:

1. `dev.check(.zen_command)` で機能の有効性を確認
2. `info_zen` 定数（コンパイル時文字列リテラル）を取得
3. 標準出力に全文を出力

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

本コマンドはエラーメッセージを出力しない。

## 例外処理

本コマンドは例外的な状況が発生しない設計となっている。コンパイル時定数を出力するだけのため、実行時エラーは発生しない。

## 備考

- Zen of ZigはPythonの「The Zen of Python」（PEP 20）にインスパイアされている
- すべての原則はZig言語の設計決定に反映されている
- 出力は `\\` エスケープを使用したマルチライン文字列リテラルで定義されている
- 処理は非常に軽量で、ファイルI/Oやネットワークアクセスを行わない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Zen文字列がどのように定義されているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `info_zen` 定数の定義（5752-5769行目） |

**読解のコツ**: `info_zen` はマルチライン文字列リテラル（`\\` プレフィックス）で定義されている。

#### Step 2: エントリーポイントを理解する

main.zigでのコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig zen` コマンドの分岐処理（373-375行目） |

**主要処理フロー**:
1. **373行目**: `mem.eql(u8, cmd, "zen")` でコマンド名を判定
2. **374行目**: `dev.check(.zen_command)` で機能有効性確認
3. **375行目**: `Io.File.stdout().writeStreamingAll(io, info_zen)` で出力

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    ├─ mem.eql(u8, cmd, "zen") [src/main.zig:373]
    │
    ├─ dev.check(.zen_command) [src/main.zig:374]
    │
    └─ Io.File.stdout().writeStreamingAll() [src/main.zig:375]
           │
           └─ info_zen [src/main.zig:5752-5769]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

                    コンパイル時定数
                    info_zen (5752-5769行目)
                           │
                           ▼
                    writeStreamingAll() ──────────▶ 標準出力
                                                   (Zen of Zig全文)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、Zen文字列定義 |

### info_zen定数の定義箇所

```zig
// src/main.zig:5752-5769
const info_zen =
    \\
    \\ * Communicate intent precisely.
    \\ * Edge cases matter.
    \\ * Favor reading code over writing code.
    \\ * Only one obvious way to do things.
    \\ * Runtime crashes are better than bugs.
    \\ * Compile errors are better than runtime crashes.
    \\ * Incremental improvements.
    \\ * Avoid local maximums.
    \\ * Reduce the amount one must remember.
    \\ * Focus on code rather than style.
    \\ * Resource allocation may fail; resource deallocation must succeed.
    \\ * Memory is a resource.
    \\ * Together we serve the users.
    \\
    \\
;
```
