# 画面設計書 28-プロジェクト初期化画面

## 概要

本ドキュメントは、Zigコンパイラの `zig init` コマンドによるプロジェクト初期化画面の設計仕様を定義する。この画面は、現在のディレクトリに新しいZigプロジェクトを初期化し、必要なファイル（build.zig、build.zig.zon、ソースファイル）を生成する機能を提供する。

### 本画面の処理概要

プロジェクト初期化画面は、新しいZigプロジェクトを開始する際のボイラープレートコードを自動生成するコマンドラインインターフェースである。ビルドシステム設定ファイルとサンプルソースコードを生成し、即座にビルド・実行可能な状態を作成する。

**業務上の目的・背景**：新しいプロジェクトを開始する際、ビルド設定やディレクトリ構造のセットアップは手間がかかる。この画面は、Zigプロジェクトの標準的な構造を自動生成することで、開発者がすぐにコード作成に集中できる環境を提供する。また、Zigのビルドシステム（build.zig）のサンプルとしても機能し、新しい開発者がビルドシステムの使い方を学ぶ助けとなる。

**画面へのアクセス方法**：ターミナルから `zig init` コマンドを実行する。オプションで `-m`/`--minimal` を指定すると、最小限のファイルのみ生成される。

**主要な操作・処理内容**：
1. コマンドライン引数をパース（minimal/exampleテンプレート選択）
2. 現在のディレクトリ名からプロジェクト名を導出
3. パッケージフィンガープリントを生成
4. テンプレートに基づいてファイルを生成
5. 各ファイルの生成結果をログ出力

**画面遷移**：本コマンドは独立したプロジェクト初期化機能であり、他の画面への直接遷移は発生しない。初期化後は `zig build` コマンドでプロジェクトをビルドできる。

**権限による表示制御**：特に権限による制御は行われない。現在のディレクトリへのファイル書き込み権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | init | 主機能 | 現在のディレクトリにZigパッケージを初期化する処理 |
| 57 | std.Build | 補助機能 | ビルドシステムAPIを使用したbuild.zig生成 |

## 画面種別

プロジェクト管理（CLI）

## URL/ルーティング

コマンド: `zig init [options]`

## 入出力項目

### 入力項目（コマンドライン引数）

| No | 項目名 | オプション | 型 | 必須 | 説明 |
|----|--------|-----------|-----|------|------|
| 1 | 最小テンプレート | -m, --minimal | - | × | 最小限のテンプレートを使用 |
| 2 | ヘルプ | -h, --help | - | × | ヘルプメッセージを表示 |

### 生成されるファイル（exampleテンプレート）

| ファイル | 説明 |
|---------|------|
| build.zig | ビルドシステム設定 |
| build.zig.zon | パッケージマニフェスト |
| src/main.zig | メインソースファイル |
| src/root.zig | ルートモジュール |

### 生成されるファイル（minimalテンプレート）

| ファイル | 説明 |
|---------|------|
| build.zig | 最小限のビルドシステム設定 |
| build.zig.zon | パッケージマニフェスト |

## 表示項目

| No | 項目名 | 条件 | 説明 |
|----|--------|------|------|
| 1 | 生成ログ | ファイル生成成功時 | "created {ファイル名}" |
| 2 | 保持ログ | ファイルが既存の場合 | "preserving already existing file: {ファイル名}" |
| 3 | エラーログ | 書き込み失敗時 | "unable to write {ファイル名}: {エラー}" |
| 4 | 完了メッセージ | 全ファイル生成成功時 | "see `zig build --help` for a menu of options" |
| 5 | 成功メッセージ | minimal時 | "successfully populated '{build.zig.zon}' and '{build.zig}'" |

## イベント仕様

### 1-exampleテンプレート初期化

ユーザーが `zig init` を実行すると:

1. 現在のディレクトリのパスを取得
2. ディレクトリ名からプロジェクト名を導出（sanitizeExampleName）
3. ランダムなフィンガープリントを生成
4. テンプレートファイルを検索（findTemplates）
5. 各テンプレートファイルを処理:
   - build.zig
   - build.zig.zon
   - src/main.zig
   - src/root.zig
6. 各ファイルの生成結果をログ出力
7. 全ファイル成功時はヘルプメッセージを表示

### 2-minimalテンプレート初期化

ユーザーが `zig init -m` を実行すると:

1. 現在のディレクトリのパスを取得
2. ディレクトリ名からプロジェクト名を導出
3. ランダムなフィンガープリントを生成
4. build.zig.zonをインラインで生成（バージョン、名前、フィンガープリント）
5. build.zigをインラインで生成（スタブ実装）
6. 成功メッセージを表示

### 3-プロジェクト名のサニタイズ

ディレクトリ名から有効なZig識別子を生成:

- 数字で始まる場合は先頭に `_` を追加
- ハイフン、ドット、スペースは `_` に変換
- 英数字とアンダースコア以外の文字は削除
- 予約語（error、test等）の場合は "foo" を返す
- 最大長を超える場合は切り詰め

## データベース更新仕様

本機能はデータベースを使用しない。ファイルシステムに以下のファイルを作成する:

| 操作 | 対象ファイル | 条件 |
|------|-------------|------|
| 作成 | build.zig | ファイルが存在しない場合 |
| 作成 | build.zig.zon | ファイルが存在しない場合 |
| 作成 | src/main.zig | exampleテンプレート時、ファイルが存在しない場合 |
| 作成 | src/root.zig | exampleテンプレート時、ファイルが存在しない場合 |

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| 情報 | "created {s}" | ファイル生成成功 |
| 情報 | "preserving already existing file: {s}" | ファイルが既に存在 |
| 情報 | "see `zig build --help` for a menu of options" | 全ファイル生成成功（example） |
| 情報 | "successfully populated '{s}' and '{s}'" | 成功（minimal） |
| エラー | "unable to write {s}: {s}" | ファイル書き込み失敗 |
| エラー | "unrecognized parameter: '{s}'" | 不明なオプション |
| エラー | "unexpected extra parameter: '{s}'" | 余分な引数 |
| エラー | "failed to create '{s}': {s}" | ファイル作成失敗（minimal） |
| エラー | "refusing to overwrite '{s}'" | build.zig.zon既存時（minimal） |

## 例外処理

| エラー種別 | 説明 | 対処 |
|-----------|------|------|
| ファイル作成失敗 | ディスク容量不足や権限エラー | エラーログを出力（続行可能） |
| ディレクトリ作成失敗 | srcディレクトリの作成に失敗 | エラーを伝播 |
| 既存ファイル上書き拒否 | minimalでbuild.zig.zonが既存 | fatalで終了 |

## 備考

- exampleテンプレートは完全なビルド設定とサンプルコードを含む
- minimalテンプレートはbuild.zigにスタブのみを含む
- build.zig.zonには現在のZigバージョンがminimum_zig_versionとして設定される
- フィンガープリントはパッケージの一意性を保証するために使用される
- 既存ファイルは上書きされない（保持される）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージマニフェストとフィンガープリントの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Package.Manifest | 標準ライブラリ | build.zig.zonの構造定義 |
| 1-2 | Package.Fingerprint | 標準ライブラリ | パッケージ識別子の生成方法 |

**読解のコツ**: `Package.Manifest.basename` は "build.zig.zon"、`Package.build_zig_basename` は "build.zig" を指す。

#### Step 2: エントリーポイントを理解する

main.zigでのコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig init` コマンドの分岐処理（342-343行目） |

**主要処理フロー**:
1. **342行目**: `mem.eql(u8, cmd, "init")` でコマンド名を判定
2. **343行目**: `cmdInit` 関数を呼び出し

#### Step 3: initコマンドの実装を理解する

cmdInit関数の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | `cmdInit` 関数（4755-4854行目） |
| 3-2 | main.zig | `src/main.zig` | `sanitizeExampleName` 関数（4856-4872行目） |

**主要処理フロー**:
- **4758-4775行目**: テンプレート選択と引数パース
- **4778-4780行目**: ディレクトリ名取得とプロジェクト名導出
- **4782-4783行目**: フィンガープリント生成
- **4785-4814行目**: exampleテンプレート処理
- **4816-4852行目**: minimalテンプレート処理

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    └─ cmdInit() [src/main.zig:4755]
           │
           ├─ 引数パース [4759-4775行目]
           │
           ├─ introspect.getResolvedCwd() [4778行目]
           │
           ├─ fs.path.basename() [4779行目]
           │
           ├─ sanitizeExampleName() [4780行目]
           │
           ├─ Package.Fingerprint.generate() [4783行目]
           │
           ├─ (exampleテンプレート)
           │      │
           │      ├─ findTemplates() [4787行目]
           │      │
           │      └─ templates.write() (各ファイル) [4800行目]
           │
           └─ (minimalテンプレート)
                  │
                  ├─ writeSimpleTemplateFile() [4817行目] (build.zig.zon)
                  │
                  └─ writeSimpleTemplateFile() [4834行目] (build.zig)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

コマンドライン引数
 -m, --minimal ──────┐
                     │
                     ▼
              cmdInit()
                     │
現在のディレクトリ ───┤
                     │
                     ▼
           sanitizeExampleName() ───▶ プロジェクト名
                     │
                     ▼
           Fingerprint.generate() ──▶ フィンガープリント
                     │
                     ▼
           テンプレート処理 ───────────▶ ファイルシステム
                                        ├─ build.zig
                                        ├─ build.zig.zon
                                        ├─ src/main.zig (example)
                                        └─ src/root.zig (example)
                     │
                     ▼
           ログ出力 ─────────────────▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、cmdInit関数 |
| introspect.zig | `src/introspect.zig` | ソース | カレントディレクトリ解決 |
| Package.Manifest | 標準ライブラリ | ソース | マニフェスト定義 |
| Package.Fingerprint | 標準ライブラリ | ソース | フィンガープリント生成 |

### 生成されるbuild.zig.zonの例（minimal）

```zon
.{
    .name = .project_name,
    .version = "0.0.1",
    .minimum_zig_version = "0.14.0",
    .paths = .{""},
    .fingerprint = 0x1234567890abcdef,
}
```

### 生成されるbuild.zigの例（minimal）

```zig
const std = @import("std");

pub fn build(b: *std.Build) void {
    _ = b; // stub
}
```
