# 画面設計書 29-変更リスト画面

## 概要

本ドキュメントは、Zigコンパイラの `zig changelist` コマンドによる変更リスト画面の設計仕様を定義する。この画面は、2つのZigソースファイル間のZIR（Zig Intermediate Representation）変更をマッピング・表示するデバッグ機能を提供する。

### 本画面の処理概要

変更リスト画面は、インクリメンタルコンパイルの開発・デバッグに使用されるツールである。古いソースファイルと新しいソースファイルをそれぞれZIRにコンパイルし、命令間のマッピングを計算して出力する。

**業務上の目的・背景**：Zigコンパイラはインクリメンタルコンパイル機能を開発中であり、この機能はソースコード変更時に再コンパイルが必要な部分を最小化するためにZIRの差分を追跡する。この画面は、ZIR間のマッピングアルゴリズムの動作確認やデバッグに使用される。コンパイラ開発者向けの内部ツールである。

**画面へのアクセス方法**：ターミナルから `zig changelist <old_source> <new_source>` コマンドを実行する。このコマンドはデバッグビルドでのみ利用可能。

**主要な操作・処理内容**：
1. 古いソースファイルを読み込み
2. 新しいソースファイルを読み込み
3. 各ソースをASTにパース
4. ASTからZIRを生成
5. ZIR間のマッピングを計算
6. マッピング結果を標準出力に表示

**画面遷移**：本コマンドは独立したデバッグ機能であり、他の画面への遷移は発生しない。

**権限による表示制御**：このコマンドはデバッグビルド（`build_options.enable_debug_extensions = true`）でのみ利用可能。リリースビルドでは表示されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 69 | changelist | 主機能 | 旧ZIRから新ZIRへのマッピング計算処理 |
| 47 | ZIR | 補助機能 | Zig中間表現の処理 |

## 画面種別

デバッグツール（CLI出力）

## URL/ルーティング

コマンド: `zig changelist <old_source> <new_source>`

**注意**: デバッグモード限定コマンド

## 入出力項目

### 入力項目（コマンドライン引数）

| No | 項目名 | 型 | 必須 | 説明 |
|----|--------|-----|------|------|
| 1 | old_source | ファイルパス | ○ | 古い（変更前の）Zigソースファイル |
| 2 | new_source | ファイルパス | ○ | 新しい（変更後の）Zigソースファイル |

## 表示項目

| No | 項目名 | 説明 |
|----|--------|------|
| 1 | マッピング情報 | 古いZIR命令から新しいZIR命令へのマッピング |

## イベント仕様

### 1-コマンド実行

ユーザーが `zig changelist <old> <new>` を実行すると:

1. `dev.check(.changelist_command)` で機能有効性を確認
2. 引数から古いソースパスと新しいソースパスを取得
3. 古いソースファイルを読み込み
4. 新しいソースファイルを読み込み
5. 古いソースをASTにパース（`Ast.parse`）
6. 古いASTからZIRを生成（`AstGen.generate`）
7. ZIR生成エラーがあればエラーバンドルを出力して終了
8. 新しいソースをASTにパース
9. 新しいASTからZIRを生成
10. ZIR生成エラーがあればエラーバンドルを出力して終了
11. `Zcu.mapOldZirToNew` で命令マッピングを計算
12. マッピング結果を標準出力に表示

### 2-ZIR生成エラー処理

ZIR生成時に構文・意味エラーがある場合:

1. `zir.loweringFailed()` でエラーを検出
2. `ErrorBundle.Wip` を初期化
3. ZIRエラーメッセージを追加
4. エラーバンドルを標準エラー出力にレンダリング
5. exit(1) でプロセス終了

## データベース更新仕様

本機能はデータベースを使用しない。

## メッセージ仕様

| 種別 | メッセージ | 発生条件 |
|------|----------|----------|
| エラー | "unable to open old source file '{s}': {s}" | 古いソースファイルが開けない |
| エラー | "unable to read old source file '{s}': {s}" | 古いソースファイルが読めない |
| エラー | "unable to open new source file '{s}': {s}" | 新しいソースファイルが開けない |
| エラー | "unable to read new source file '{s}': {s}" | 新しいソースファイルが読めない |
| エラー | ZIRエラー | ソースコードに構文/意味エラーがある場合 |

## 例外処理

| エラー種別 | 説明 | 対処 |
|-----------|------|------|
| ファイルオープン失敗 | ソースファイルにアクセスできない | fatal でエラー出力して終了 |
| ファイル読み込み失敗 | ソースファイルの読み込みに失敗 | fatal でエラー出力して終了 |
| ZIR生成失敗 | ソースコードにエラーがある | エラーバンドルを表示して exit(1) |
| メモリ不足 | 大きなソースでメモリ枯渇 | エラーを伝播 |

## 備考

- このコマンドはデバッグビルドでのみ利用可能
- インクリメンタルコンパイルの開発・検証に使用される
- ZIR（Zig Intermediate Representation）はZigの中間表現
- マッピングは `std.AutoHashMapUnmanaged(Zir.Inst.Index, Zir.Inst.Index)` で表現される
- カラー出力は `.auto` 設定で端末に応じて自動調整される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ZIRとマッピングの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std.zig.Zir | 標準ライブラリ | ZIR命令セットの構造 |
| 1-2 | Zcu | `src/Zcu.zig` | `mapOldZirToNew` 関数の理解 |

**読解のコツ**: ZIRはASTを低レベル化した中間表現で、各命令は `Zir.Inst.Index` で参照される。

#### Step 2: エントリーポイントを理解する

main.zigでのコマンドディスパッチを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `zig changelist` コマンドの分岐処理（383-384行目） |

**主要処理フロー**:
1. **383行目**: デバッグ拡張有効かつコマンド名が "changelist" かを判定
2. **384行目**: `cmdChangelist` 関数を呼び出し

#### Step 3: changelistコマンドの実装を理解する

cmdChangelist関数の詳細を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | `cmdChangelist` 関数（6572-6624行目） |

**主要処理フロー**:
- **6573行目**: `dev.check(.changelist_command)` で機能確認
- **6578-6579行目**: ソースパスを引数から取得
- **6581-6588行目**: 古いソースファイルの読み込み
- **6589-6596行目**: 新しいソースファイルの読み込み
- **6598-6599行目**: 古いソースのAST/ZIR生成
- **6601-6608行目**: 古いZIRのエラーチェック
- **6610-6611行目**: 新しいソースのAST/ZIR生成
- **6613-6620行目**: 新しいZIRのエラーチェック
- **6622-6623行目**: ZIRマッピングの計算

### プログラム呼び出し階層図

```
main() [src/main.zig:171]
    │
    ├─ build_options.enable_debug_extensions チェック [383行目]
    │
    └─ cmdChangelist() [src/main.zig:6572]
           │
           ├─ dev.check(.changelist_command) [6573行目]
           │
           ├─ 古いソース読み込み
           │      ├─ Io.Dir.cwd().openFile() [6582行目]
           │      └─ std.zig.readSourceFileToEndAlloc() [6586行目]
           │
           ├─ 新しいソース読み込み
           │      ├─ Io.Dir.cwd().openFile() [6590行目]
           │      └─ std.zig.readSourceFileToEndAlloc() [6594行目]
           │
           ├─ 古いZIR生成
           │      ├─ Ast.parse() [6598行目]
           │      └─ AstGen.generate() [6599行目]
           │
           ├─ 新しいZIR生成
           │      ├─ Ast.parse() [6610行目]
           │      └─ AstGen.generate() [6611行目]
           │
           └─ Zcu.mapOldZirToNew() [6623行目]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

old_source (ファイル)
      │
      ▼
   読み込み ───▶ Ast.parse() ───▶ AstGen.generate() ───┐
                                                        │
                                                        ▼
                                              mapOldZirToNew()
                                                        │
new_source (ファイル)                                   │
      │                                                 │
      ▼                                                 │
   読み込み ───▶ Ast.parse() ───▶ AstGen.generate() ───┘
                                                        │
                                                        ▼
                                              マッピング結果 ───▶ 標準出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、cmdChangelist関数 |
| Zcu.zig | `src/Zcu.zig` | ソース | mapOldZirToNew関数 |
| Ast | 標準ライブラリ | ソース | ASTパーサー |
| AstGen | 標準ライブラリ | ソース | AST→ZIR変換 |
| std.zig.Zir | 標準ライブラリ | ソース | ZIR構造定義 |
| ErrorBundle | 標準ライブラリ | ソース | エラー報告 |
