# 画面設計書 3-実行ファイルビルド画面

## 概要

本ドキュメントは、Zigコンパイラの「実行ファイルビルド画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

実行ファイルビルド画面は、Zigソースコードまたはオブジェクトファイルから実行可能ファイルを生成するCLI画面である。コンパイル、意味解析、コード生成、リンクまでの一連の処理を実行する。

**業務上の目的・背景**：ソフトウェア開発において、ソースコードから実行可能なバイナリを生成することは最も基本的かつ重要な作業である。`zig build-exe`コマンドは、Zigソースファイル、Cソースファイル、オブジェクトファイルなど様々な入力から、ターゲットプラットフォーム向けの実行ファイルを生成する。クロスコンパイルにも対応し、開発マシンとは異なるプラットフォーム向けのバイナリ生成も可能である。

**画面へのアクセス方法**：
- `zig build-exe [ソースファイル]` - 実行ファイルをビルド
- `zig build-exe [オプション] [ファイル...]` - オプション付きでビルド

**主要な操作・処理内容**：
1. コマンドライン引数の解析（ターゲット、最適化レベル等）
2. ソースファイルのパース（AST生成）
3. 意味解析（Sema）による型チェック
4. ZIR（Zig中間表現）の生成
5. コードジェネレーション（LLVMまたはネイティブバックエンド）
6. リンク処理（ELF/MachO/COFF/WASM）
7. 実行ファイルの出力

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：ビルド完了後にプロセス終了、または`zig run`から呼び出される

**権限による表示制御**：権限による表示制御は存在しない。ファイルシステムへのアクセス権限がビルド可否を決定する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | build-exe | 主機能 | Zigソースコードから実行可能ファイルを生成する処理 |
| 43 | Sema（意味解析） | 補助機能 | ビルド時の型チェックと意味解析処理 |
| 29 | LLVMバックエンド | 遷移先機能 | LLVMを使用したネイティブコード生成処理 |
| 37 | ELFリンカ | 遷移先機能 | ELF形式の実行可能ファイルのリンク処理（Linux） |
| 38 | MachOリンカ | 遷移先機能 | Mach-O形式の実行可能ファイルのリンク処理（macOS） |
| 39 | COFFリンカ | 遷移先機能 | COFF/PE形式の実行可能ファイルのリンク処理（Windows） |
| 30 | x86_64バックエンド | 遷移先機能 | x86_64アーキテクチャ向けコード生成処理 |
| 31 | aarch64バックエンド | 遷移先機能 | ARM64アーキテクチャ向けコード生成処理 |
| 33 | wasmバックエンド | 遷移先機能 | WebAssembly向けコード生成処理 |
| 40 | WASMリンカ | 遷移先機能 | WebAssemblyモジュールのリンク処理 |
| 74 | インクリメンタルコンパイル | 補助機能 | -fincremental オプション使用時の高速再コンパイル処理 |
| 59 | compiler_rt | 補助機能 | コンパイラランタイム（ソフトウェア浮動小数点等）の組み込み |
| 42 | LLDリンカ統合 | 補助機能 | LLDリンカとの統合処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

CLIアプリケーションのため、URLは存在しない。コマンドルーティングは以下の通り。

```
zig build-exe [options] [files]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | ○ | ソースファイルまたはオブジェクトファイル |
| -target | string | - | ターゲットトリプル（例：x86_64-linux-gnu） |
| -O | Debug/ReleaseFast/ReleaseSafe/ReleaseSmall | - | 最適化モード |
| --name | string | - | 出力ファイル名 |
| -femit-bin | path | - | 出力先パス |
| -fno-emit-bin | - | - | バイナリ出力を無効化 |
| -fllvm | - | - | LLVMバックエンドを強制使用 |
| -fno-llvm | - | - | LLVMバックエンドを使用しない |
| -fincremental | - | - | インクリメンタルコンパイルを有効化 |
| --libc | path | - | libcパスファイル |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行ファイル | binary | 生成された実行可能バイナリ |
| コンパイルエラー | text | エラーメッセージ（エラー時） |
| 警告 | text | 警告メッセージ |

## 表示項目

ビルド画面は以下の情報を表示する。

| セクション | 説明 |
|-----------|------|
| 進捗表示 | コンパイルの進捗状況 |
| コンパイルエラー | ソースコードのエラー情報（行番号、カラム番号付き） |
| リンクエラー | リンク時のエラー情報 |

## イベント仕様

### 1-ビルド実行

ユーザーが`zig build-exe [ファイル]`を実行した場合。

**処理フロー**：
1. `buildOutputType`関数でコマンド引数を解析
2. ターゲット情報の解決
3. `Compilation`オブジェクトの作成
4. ソースファイルのパース
5. 意味解析（Sema）
6. コード生成
7. リンク処理
8. 出力ファイルの生成

### 2-ヘルプ表示

`-h`または`--help`オプションが指定された場合。

**処理フロー**：
1. `usage_build_generic`を標準出力に表示
2. プロセス終了

## データベース更新仕様

本画面はデータベースを使用しない。ファイルシステムを更新する。

### 操作別影響一覧

| 操作（イベント） | 対象 | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ビルド実行 | ローカルキャッシュ | CREATE/UPDATE | コンパイル済みオブジェクトの保存 |
| ビルド実行 | 出力ディレクトリ | CREATE | 実行ファイルの生成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 情報 | usage_build_generic | --help時 |
| - | エラー | コンパイルエラー詳細 | ソースコードにエラー |
| - | エラー | リンクエラー詳細 | リンク処理でエラー |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | 指定されたソースファイルが存在しない | エラーメッセージを表示して終了 |
| 構文エラー | ソースコードに構文エラー | エラー位置と詳細を表示 |
| 型エラー | 型チェックで不整合 | エラー詳細を表示 |
| リンクエラー | シンボル未解決等 | エラー詳細を表示 |

## 備考

- 対応する入力ファイル形式：.zig、.o、.obj、.a、.so、.dll、.dylib、.s、.S、.c、.cxx等
- LLVMバックエンドはオプションで有効/無効を切り替え可能
- クロスコンパイルには`-target`オプションを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ビルドコマンドで使用される主要なデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `ArgMode`構造体（742-750行目）：コマンドモード定義 |
| 1-2 | main.zig | `src/main.zig` | `EmitBin`/`Emit`構造体（703-740行目）：出力設定 |
| 1-3 | Compilation.zig | `src/Compilation.zig` | `Compilation`構造体（1-150行目）：コンパイル処理の状態 |

**読解のコツ**: `ArgMode`のunion型で`build: std.builtin.OutputMode`の`.Exe`がbuild-exeに対応する。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（261-263行目）：build-exeコマンドへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `buildOutputType`関数（809行目〜）：ビルド処理のメイン |

**主要処理フロー**:
1. **261行目**: `mem.eql(u8, cmd, "build-exe")`でコマンド判定
2. **262行目**: `dev.check(.build_exe_command)`でデバッグチェック
3. **263行目**: `buildOutputType`を`.{ .build = .Exe }`モードで呼び出し
4. **809行目〜**: `buildOutputType`関数で引数解析と処理開始

#### Step 3: 引数解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | `usage_build_generic`定数（395-695行目）：ヘルプテキスト |
| 3-2 | main.zig | `src/main.zig` | 引数解析ループ（buildOutputType内） |

**主要処理フロー**:
- **395-695行目**: 詳細なオプション一覧を定義
- `-target`、`-O`、`-femit-bin`等のオプションを解析

#### Step 4: コンパイル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Compilation.zig | `src/Compilation.zig` | コンパイル処理の中核 |
| 4-2 | Sema.zig | `src/Sema.zig` | 意味解析処理 |
| 4-3 | link.zig | `src/link.zig` | リンク処理 |

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ buildOutputType (809行目) [mode = .{ .build = .Exe }]
                  │
                  ├─ 引数解析
                  │      ├─ -target オプション解析
                  │      ├─ -O 最適化モード解析
                  │      └─ -femit-bin 出力先解析
                  │
                  ├─ Compilation.create
                  │      └─ コンパイラ初期化
                  │
                  ├─ Compilation.update
                  │      │
                  │      ├─ AstGen (AST生成)
                  │      │
                  │      ├─ Sema (意味解析)
                  │      │      └─ 型チェック
                  │      │
                  │      └─ codegen (コード生成)
                  │             ├─ LLVMバックエンド
                  │             └─ ネイティブバックエンド
                  │
                  └─ link.File
                         ├─ ELFリンカ (Linux)
                         ├─ MachOリンカ (macOS)
                         ├─ COFFリンカ (Windows)
                         └─ WASMリンカ (WebAssembly)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig/.c/.o ─────────────▶ buildOutputType ─────────────▶ 実行ファイル
   │                          │                          (.exe等)
   │                          ▼
   │                    Compilation.create
   │                          │
   │                          ▼
   │                    AstGen (AST生成)
   │                          │
   │                          ▼
   │                    Sema (意味解析)
   │                          │
   │                          ▼
   │                    codegen (コード生成)
   │                          │
   │                          ▼
-target ────────────────▶ link.File
-O option                     │
                             ▼
                       ELF/MachO/COFF/WASM
                             │
                             ▼
                       実行ファイル出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント、buildOutputType関数 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理の中核 |
| Sema.zig | `src/Sema.zig` | ソース | 意味解析（型チェック） |
| link.zig | `src/link.zig` | ソース | リンク処理の抽象化 |
| codegen/llvm.zig | `src/codegen/llvm.zig` | ソース | LLVMバックエンド |
| codegen.zig | `src/codegen.zig` | ソース | コード生成の抽象化 |
| Zcu.zig | `src/Zcu.zig` | ソース | Zigコンパイルユニット |
| target.zig | `src/target.zig` | ソース | ターゲット情報処理 |
