# 画面設計書 32-LLVM整数ダンプ画面

## 概要

本ドキュメントは、Zigコンパイラの `zig llvm-ints` コマンド（LLVM整数ダンプ画面）の設計仕様を定義する。このコマンドは、指定したターゲットトリプルにおける各整数型のLLVM ABIアライメント値をダンプするデバッグ用コマンドである。

### 本画面の処理概要

LLVM整数ダンプ画面は、LLVMバックエンドが特定のターゲットアーキテクチャに対してどのようなアライメント値を返すかを調査するためのデバッグツールである。整数型（1ビット、8ビット、16ビット、32ビット、64ビット、128ビット、256ビット）に対する `LLVMABIAlignmentOfType` の結果を一覧表示する。

**業務上の目的・背景**：
Zigコンパイラは複数のターゲットアーキテクチャ向けにコードを生成するが、各アーキテクチャのABI（Application Binary Interface）には異なるアライメント要件がある。LLVMがレポートするアライメント値がZigコンパイラの期待する値と一致しているかを確認することは、正しいコード生成とABI互換性を保証するために重要である。本コマンドは、開発者がターゲット固有のアライメント情報を迅速に取得し、潜在的な互換性問題やバグの診断を行うために提供されている。特に、異なるプラットフォーム間でのデータ構造のレイアウト問題の調査に有用である。

**画面へのアクセス方法**：
ターミナル（コマンドライン）から `zig llvm-ints <triple>` コマンドを実行する。このコマンドはデバッグビルドでのみ利用可能であり、リリースビルドのZigコンパイラでは実行できない。また、LLVMバックエンドが有効なビルドでのみ動作する。

**主要な操作・処理内容**：
1. `zig llvm-ints <triple>`：指定したターゲットトリプルに対する整数型のアライメント値を出力
2. ターゲットトリプルは必須引数として指定（例：`x86_64-linux-gnu`, `aarch64-apple-darwin`）

**画面遷移**：
- 遷移元：zig コマンド（エントリポイント）から直接アクセス
- 遷移先：なし（結果を標準出力に出力して終了）

**権限による表示制御**：
- デバッグビルド（`build_options.enable_debug_extensions = true`）でのみ利用可能
- LLVMバックエンド有効ビルド（`build_options.have_llvm = true`）が必須
- リリースビルドまたはLLVM無効ビルドではコマンド自体が存在しない/動作しない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 72 | llvm-ints | 主機能 | 全整数型のLLVMABIAlignmentOfTypeのダンプ処理 |

## 画面種別

情報表示（デバッグ情報出力）

## URL/ルーティング

コマンドライン: `zig llvm-ints <triple>`

## 入出力項目

### 入力（コマンドライン引数）

| 項目名 | 引数形式 | 必須 | 説明 | 例 |
|--------|----------|------|------|-----|
| triple | 位置引数（第1引数） | Yes | ターゲットトリプル文字列 | `x86_64-linux-gnu`, `aarch64-apple-darwin`, `arm-none-eabi` |

### 出力（標準出力）

| 出力項目 | 形式 | 説明 |
|----------|------|------|
| アライメント情報 | `LLVMABIAlignmentOfType(i{bits}) == {alignment}` | 各整数型のABIアライメント値 |

## 表示項目

### 出力フォーマット

```
LLVMABIAlignmentOfType(i1) == {alignment}
LLVMABIAlignmentOfType(i8) == {alignment}
LLVMABIAlignmentOfType(i16) == {alignment}
LLVMABIAlignmentOfType(i32) == {alignment}
LLVMABIAlignmentOfType(i64) == {alignment}
LLVMABIAlignmentOfType(i128) == {alignment}
LLVMABIAlignmentOfType(i256) == {alignment}
```

| 項目 | 説明 | 単位 |
|------|------|------|
| bits | 整数型のビット幅 | ビット（1, 8, 16, 32, 64, 128, 256） |
| alignment | ABIアライメント値 | バイト |

### 出力例

x86_64-linux-gnu ターゲットの例：
```
LLVMABIAlignmentOfType(i1) == 1
LLVMABIAlignmentOfType(i8) == 1
LLVMABIAlignmentOfType(i16) == 2
LLVMABIAlignmentOfType(i32) == 4
LLVMABIAlignmentOfType(i64) == 8
LLVMABIAlignmentOfType(i128) == 16
LLVMABIAlignmentOfType(i256) == 32
```

## イベント仕様

### 1-コマンド実行

1. ユーザーが `zig llvm-ints <triple>` を実行
2. `dev.check(.llvm_ints_command)` で開発チェックを実行
3. `build_options.have_llvm` をチェック（LLVMが利用可能か確認）
4. ターゲットトリプル文字列を引数から取得してnull終端化
5. aarch64およびx86アーキテクチャのLLVMターゲットを初期化
6. 指定されたトリプルからLLVMターゲットを取得
7. LLVMターゲットマシンを作成
8. ターゲットデータレイアウトを取得
9. LLVMコンテキストを作成
10. 各整数型（1, 8, 16, 32, 64, 128, 256ビット）について：
    - LLVMの整数型を作成
    - `abiAlignmentOfType()` でアライメント値を取得
    - 結果を標準出力に出力
11. プログラムが正常終了（exit code 0）

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはデータベースを使用しない（読み取り専用の情報表示コマンド）。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 発生条件 |
|--------------|--------------|----------|
| エラー | `compiler does not use LLVM; cannot dump LLVM integer sizes` | LLVMが利用不可能なビルド |
| パニック | `bad` | 無効なターゲットトリプルが指定された場合（`Target.getFromTriple`失敗時） |

## 例外処理

| 例外条件 | 処理内容 | 終了コード |
|---------|---------|-----------|
| LLVM未対応 | エラーメッセージを表示して終了 | 1（fatal経由） |
| 無効なターゲットトリプル | パニック発生 | 異常終了 |

## 備考

- 本コマンドはデバッグビルド限定で、`build_options.enable_debug_extensions` が `true` の場合のみ利用可能
- `build_options.have_llvm` が `true` の場合のみ動作
- 対象の整数型は固定：1, 8, 16, 32, 64, 128, 256ビット
- aarch64とx86アーキテクチャのLLVMターゲットが事前に初期化される
- ターゲットトリプルはLLVM形式（例：`x86_64-unknown-linux-gnu`）で指定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LLVM関連のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bindings.zig | `src/codegen/llvm/bindings.zig` | `TargetData`、`Target`、`TargetMachine`、`Context`、`Type`の定義を確認 |
| 1-2 | bindings.zig | `src/codegen/llvm/bindings.zig` | `abiAlignmentOfType`関数（行155-156）を確認 |

**読解のコツ**: LLVMのC APIをZigでラップしたopaqueポインタ型が多用されている。`extern fn`宣言がC関数へのバインディングを定義している。

#### Step 2: エントリーポイントを理解する

コマンドディスパッチ部分を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | 387-388行目のコマンドディスパッチ部分を確認 |

**主要処理フロー**:
1. **387行目**: `build_options.enable_debug_extensions and mem.eql(u8, cmd, "llvm-ints")` でコマンド名を判定
2. **388行目**: `cmdDumpLlvmInts(gpa, arena, io, cmd_args)` を呼び出し

#### Step 3: コマンド処理関数を理解する

`cmdDumpLlvmInts` 関数の詳細処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | 6484-6525行目の `cmdDumpLlvmInts` 関数を確認 |

**主要処理フロー**:
- **6490行目**: `dev.check(.llvm_ints_command)` - 開発モードチェック
- **6494-6495行目**: `build_options.have_llvm` チェック
- **6497行目**: ターゲットトリプル文字列の取得とnull終端化
- **6501-6503行目**: aarch64とx86のLLVMターゲット初期化
- **6505-6510行目**: トリプルからLLVMターゲットを取得
- **6511行目**: LLVMターゲットマシンを作成
- **6512行目**: ターゲットデータレイアウトを取得
- **6513行目**: LLVMコンテキストを作成
- **6517-6521行目**: 各整数型のアライメント値を出力

#### Step 4: LLVM初期化処理を理解する

LLVMターゲットの初期化処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm.zig | `src/codegen/llvm.zig` | `initializeLLVMTarget` 関数を確認 |
| 4-2 | bindings.zig | `src/codegen/llvm/bindings.zig` | `Target`, `TargetMachine`, `TargetData` のメソッドを確認 |

**主要処理フロー**:
- **6501行目**: `@import("codegen/llvm.zig").initializeLLVMTarget(arch)` でターゲット初期化
- **6505-6510行目**: `llvm.Target.getFromTriple()` でトリプルからターゲット取得
- **6511行目**: `llvm.TargetMachine.create()` でターゲットマシン作成
- **6512行目**: `tm.createTargetDataLayout()` でデータレイアウト取得

#### Step 5: 出力処理を理解する

アライメント値の出力処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | main.zig | `src/main.zig` | 6515-6522行目の出力ループを確認 |

**主要処理フロー**:
- **6517行目**: `[_]u16{ 1, 8, 16, 32, 64, 128, 256 }` の各ビット幅についてループ
- **6518行目**: `context.intType(bits)` で整数型を作成
- **6519行目**: `dl.abiAlignmentOfType(int_type)` でアライメント取得
- **6520行目**: フォーマットして出力

### プログラム呼び出し階層図

```
main() [src/main.zig]
    |
    +-- mainArgs() [行番号: 256]
        |
        +-- コマンドディスパッチ [行番号: 387-388]
            |
            +-- cmdDumpLlvmInts() [行番号: 6484-6525]
                |
                +-- dev.check(.llvm_ints_command) [行番号: 6490]
                |
                +-- build_options.have_llvm チェック [行番号: 6494-6495]
                |
                +-- arena.dupeZ() [行番号: 6497]
                |   （トリプル文字列のnull終端化）
                |
                +-- initializeLLVMTarget(aarch64) [行番号: 6501]
                +-- initializeLLVMTarget(x86) [行番号: 6502]
                |
                +-- llvm.Target.getFromTriple() [行番号: 6505-6509]
                |
                +-- llvm.TargetMachine.create() [行番号: 6511]
                |
                +-- tm.createTargetDataLayout() [行番号: 6512]
                |
                +-- llvm.Context.create() [行番号: 6513]
                |
                +-- [各整数型についてループ]
                    |
                    +-- context.intType(bits) [行番号: 6518]
                    +-- dl.abiAlignmentOfType(int_type) [行番号: 6519]
                    +-- stdout_bw.print() [行番号: 6520]
                |
                +-- cleanExit() [行番号: 6524]
```

### データフロー図

```
[入力]                       [処理]                            [出力]

コマンドライン引数
    |
    +-- <triple>        --> cmdDumpLlvmInts()
    (例: x86_64-linux-gnu)      |
                               v
                    +-------------------+
                    | have_llvmチェック   |
                    +-------------------+
                               |
                               v
                    +-------------------+
                    | トリプル文字列取得  |
                    | null終端化         |
                    +-------------------+
                               |
                               v
                    +-------------------+
                    | LLVMターゲット     |
                    | 初期化             |
                    | (aarch64, x86)    |
                    +-------------------+
                               |
                               v
                    +-------------------+
                    | Target取得         |
                    | TargetMachine作成 |
                    | DataLayout取得    |
                    +-------------------+
                               |
                               v
                    +-------------------+
                    | 各整数型ループ      |
                    | (1,8,16,32,64,    |
                    |  128,256 bits)    |
                    +-------------------+
                               |
       +-------+-------+-------+-------+-------+-------+-------+
       |       |       |       |       |       |       |       |
       v       v       v       v       v       v       v       v
    i1      i8     i16    i32    i64   i128   i256
       |       |       |       |       |       |       |       |
       +-------+-------+-------+-------+-------+-------+-------+
                               |
                               v
                    +-------------------+      標準出力
                    | abiAlignmentOfType| ---> LLVMABIAlignmentOfType(iN) == M
                    | 結果フォーマット    |
                    +-------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント、`cmdDumpLlvmInts`関数の実装 |
| bindings.zig | `src/codegen/llvm/bindings.zig` | ソース | LLVM C API のZigバインディング（Target, TargetMachine, TargetData, Context, Type） |
| llvm.zig | `src/codegen/llvm.zig` | ソース | LLVMコード生成バックエンド、`initializeLLVMTarget`関数 |
| build_options.zig | `src/build_options.zig` | 生成ファイル | ビルド時オプション（`enable_debug_extensions`, `have_llvm`） |
