# 画面設計書 4-ライブラリビルド画面

## 概要

本ドキュメントは、Zigコンパイラの「ライブラリビルド画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

ライブラリビルド画面は、Zigソースコードまたはオブジェクトファイルからライブラリ（静的ライブラリまたは動的ライブラリ）を生成するCLI画面である。他のプログラムから再利用可能なコードモジュールを作成する。

**業務上の目的・背景**：ソフトウェア開発において、共通機能をライブラリとして切り出すことは、コードの再利用性と保守性を高める重要な手法である。`zig build-lib`コマンドは、Zigコードから静的ライブラリ（.a、.lib）や動的ライブラリ（.so、.dll、.dylib）を生成し、他のZigプロジェクトやC/C++プロジェクトから利用できるようにする。

**画面へのアクセス方法**：
- `zig build-lib [ソースファイル]` - ライブラリをビルド
- `zig build-lib [オプション] [ファイル...]` - オプション付きでビルド

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ソースファイルのパース
3. 意味解析（Sema）
4. コード生成
5. ライブラリのアーカイブ作成（静的）またはリンク（動的）
6. ライブラリファイルの出力

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：ビルド完了後にプロセス終了

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | build-lib | 主機能 | Zigソースコードからライブラリを生成する処理 |
| 43 | Sema（意味解析） | 補助機能 | ビルド時の型チェックと意味解析処理 |
| 29 | LLVMバックエンド | 遷移先機能 | LLVMを使用したネイティブコード生成処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig build-lib [options] [files]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | ○ | ソースファイルまたはオブジェクトファイル |
| -target | string | - | ターゲットトリプル |
| -O | Debug/ReleaseFast/ReleaseSafe/ReleaseSmall | - | 最適化モード |
| --name | string | - | 出力ライブラリ名 |
| -dynamic | - | - | 動的ライブラリを生成 |
| -static | - | - | 静的ライブラリを生成 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ライブラリファイル | binary | 生成されたライブラリ（.a/.so/.dll/.dylib等） |
| ヘッダファイル | text | C互換ヘッダ（-femit-h使用時） |

## 表示項目

| セクション | 説明 |
|-----------|------|
| 進捗表示 | コンパイルの進捗状況 |
| コンパイルエラー | ソースコードのエラー情報 |

## イベント仕様

### 1-ライブラリビルド実行

ユーザーが`zig build-lib [ファイル]`を実行した場合。

**処理フロー**：
1. `buildOutputType`関数を`.{ .build = .Lib }`モードで呼び出し
2. 引数解析、ターゲット解決
3. コンパイル処理
4. ライブラリ生成

## データベース更新仕様

本画面はデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | エラー | コンパイルエラー詳細 | ソースコードにエラー |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | ソースファイルが存在しない | エラーメッセージを表示 |
| 構文エラー | ソースコードに構文エラー | エラー位置と詳細を表示 |

## 備考

- 静的ライブラリはアーカイバによって生成される
- 動的ライブラリはリンカによって生成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `ArgMode`構造体（742-750行目） |

**読解のコツ**: `ArgMode`の`.build = .Lib`がbuild-libに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（264-266行目）：build-libへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `buildOutputType`関数（809行目〜） |

**主要処理フロー**:
1. **264行目**: `mem.eql(u8, cmd, "build-lib")`でコマンド判定
2. **265行目**: `dev.check(.build_lib_command)`でデバッグチェック
3. **266行目**: `buildOutputType`を`.{ .build = .Lib }`モードで呼び出し

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ buildOutputType (809行目) [mode = .{ .build = .Lib }]
                  │
                  ├─ 引数解析
                  │
                  ├─ Compilation.create
                  │
                  └─ Compilation.update
                         │
                         └─ ライブラリ生成
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig/.c/.o ─────────────▶ buildOutputType ─────────────▶ ライブラリ
                               │                          (.a/.so等)
                               ▼
                         Compilation
                               │
                               ▼
                         codegen
                               │
                               ▼
                         link/archive
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
| link.zig | `src/link.zig` | ソース | リンク/アーカイブ処理 |
