# 画面設計書 5-オブジェクトビルド画面

## 概要

本ドキュメントは、Zigコンパイラの「オブジェクトビルド画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

オブジェクトビルド画面は、Zigソースコードまたはオブジェクトファイルからオブジェクトファイル（.o、.obj）を生成するCLI画面である。リンク前の中間成果物を生成し、後続のビルドプロセスで使用できるようにする。

**業務上の目的・背景**：大規模プロジェクトでは、コンパイルとリンクを分離することで、変更されたファイルのみを再コンパイルする増分ビルドが可能になる。`zig build-obj`コマンドは、個々のソースファイルからオブジェクトファイルを生成し、他のビルドシステムとの統合や段階的なビルドプロセスを実現する。

**画面へのアクセス方法**：
- `zig build-obj [ソースファイル]` - オブジェクトファイルを生成
- `zig build-obj [オプション] [ファイル...]` - オプション付きで生成

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ソースファイルのパース
3. 意味解析（Sema）
4. コード生成
5. オブジェクトファイルの出力（リンクなし）

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：ビルド完了後にプロセス終了

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | build-obj | 主機能 | Zigソースコードからオブジェクトファイルを生成する処理 |
| 43 | Sema（意味解析） | 補助機能 | ビルド時の型チェックと意味解析処理 |
| 29 | LLVMバックエンド | 遷移先機能 | LLVMを使用したネイティブコード生成処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig build-obj [options] [files]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | ○ | ソースファイルまたはオブジェクトファイル |
| -target | string | - | ターゲットトリプル |
| -O | Debug/ReleaseFast/ReleaseSafe/ReleaseSmall | - | 最適化モード |
| --name | string | - | 出力ファイル名 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | binary | 生成されたオブジェクトファイル（.o/.obj） |

## 表示項目

| セクション | 説明 |
|-----------|------|
| 進捗表示 | コンパイルの進捗状況 |
| コンパイルエラー | ソースコードのエラー情報 |

## イベント仕様

### 1-オブジェクトビルド実行

ユーザーが`zig build-obj [ファイル]`を実行した場合。

**処理フロー**：
1. `buildOutputType`関数を`.{ .build = .Obj }`モードで呼び出し
2. 引数解析、ターゲット解決
3. コンパイル処理（リンクなし）
4. オブジェクトファイル生成

## データベース更新仕様

本画面はデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | エラー | コンパイルエラー詳細 | ソースコードにエラー |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | ソースファイルが存在しない | エラーメッセージを表示 |
| 構文エラー | ソースコードに構文エラー | エラー位置と詳細を表示 |

## 備考

- オブジェクトファイルはリンクを行わず、コンパイルのみを実行
- 生成されたオブジェクトファイルは`zig build-exe`や`zig build-lib`の入力として使用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `ArgMode`構造体（742-750行目） |

**読解のコツ**: `ArgMode`の`.build = .Obj`がbuild-objに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（267-269行目）：build-objへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `buildOutputType`関数（809行目〜） |

**主要処理フロー**:
1. **267行目**: `mem.eql(u8, cmd, "build-obj")`でコマンド判定
2. **268行目**: `dev.check(.build_obj_command)`でデバッグチェック
3. **269行目**: `buildOutputType`を`.{ .build = .Obj }`モードで呼び出し

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ buildOutputType (809行目) [mode = .{ .build = .Obj }]
                  │
                  ├─ 引数解析
                  │
                  ├─ Compilation.create
                  │
                  └─ Compilation.update
                         │
                         └─ オブジェクトファイル生成（リンクなし）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig/.c ──────────────▶ buildOutputType ─────────────▶ オブジェクトファイル
                              │                          (.o/.obj)
                              ▼
                        Compilation
                              │
                              ▼
                        codegen
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
