# 画面設計書 6-テスト実行画面

## 概要

本ドキュメントは、Zigコンパイラの「テスト実行画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

テスト実行画面は、Zigソースコードに含まれるユニットテストをビルドして実行するCLI画面である。`test`ブロックで定義されたテストケースを自動的に検出し、実行結果を報告する。

**業務上の目的・背景**：ソフトウェアの品質保証において、ユニットテストは不可欠な手法である。Zigは言語レベルでテスト機能をサポートしており、`zig test`コマンドによりソースコード内の`test`ブロックを自動的に検出・実行できる。これにより、テストの作成と実行が容易になり、継続的インテグレーション（CI）パイプラインへの統合も簡単になる。

**画面へのアクセス方法**：
- `zig test [ソースファイル]` - テストを実行
- `zig test [オプション] [ファイル...]` - オプション付きで実行

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ソースファイルのパース
3. testブロックの検出
4. テスト用実行ファイルのビルド
5. テストの実行
6. 結果の報告

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：テスト完了後にプロセス終了（成功時：終了コード0、失敗時：非0）

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | test | 主機能 | Zigソースコードのユニットテストを実行する処理 |
| 43 | Sema（意味解析） | 補助機能 | テストコードの型チェックと意味解析処理 |
| 73 | Tracy統合 | 補助機能 | テスト実行時のプロファイリング・トレーシング処理 |
| 61 | fuzzer | 補助機能 | ファジングテスト支援処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig test [options] [files]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | ○ | テスト対象のソースファイル |
| -target | string | - | ターゲットトリプル |
| -O | Debug/ReleaseFast/ReleaseSafe/ReleaseSmall | - | 最適化モード |
| --test-filter | string | - | 実行するテストをフィルタリング |
| --test-cmd | string[] | - | テスト実行コマンドを指定 |
| --test-no-exec | - | - | コンパイルのみでテスト実行しない |
| --test-runner | path | - | カスタムテストランナーを指定 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テスト結果 | text | 各テストの成功/失敗情報 |
| 終了コード | number | 全テスト成功時0、失敗時非0 |

## 表示項目

| セクション | 説明 |
|-----------|------|
| テスト進捗 | 実行中のテスト名 |
| テスト結果 | 各テストの成功/失敗 |
| 失敗詳細 | 失敗したテストのスタックトレースやメッセージ |
| サマリー | 全体の成功/失敗数 |

## イベント仕様

### 1-テスト実行

ユーザーが`zig test [ファイル]`を実行した場合。

**処理フロー**：
1. `buildOutputType`関数を`.zig_test`モードで呼び出し
2. ソースファイルのパース
3. testブロックの収集
4. テスト用実行ファイルのビルド
5. テストの実行
6. 結果の集計と表示

### 2-フィルタ付きテスト実行

`--test-filter`オプションが指定された場合。

**処理フロー**：
1. 指定されたパターンに一致するテストのみを実行
2. 一致しないテストはスキップ

## データベース更新仕様

本画面はデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | "All X tests passed" | 全テスト成功時 |
| - | 失敗 | テスト失敗詳細 | テスト失敗時 |
| - | エラー | コンパイルエラー詳細 | テストコードにエラー |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | ソースファイルが存在しない | エラーメッセージを表示 |
| コンパイルエラー | テストコードに構文/意味エラー | エラー詳細を表示 |
| テスト失敗 | テストアサーションが失敗 | 失敗詳細を表示、非0終了 |

## 備考

- `test`ブロックはコンパイル時に自動的に検出される
- `--test-no-exec`オプションでコンパイルのみ実行可能
- ファジングテストにはfuzzer機能を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `ArgMode`構造体（742-750行目）：`.zig_test`モード |

**読解のコツ**: `ArgMode`の`.zig_test`がtestコマンドに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（270-272行目）：testへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `buildOutputType`関数（809行目〜） |

**主要処理フロー**:
1. **270行目**: `mem.eql(u8, cmd, "test")`でコマンド判定
2. **271行目**: `dev.check(.test_command)`でデバッグチェック
3. **272行目**: `buildOutputType`を`.zig_test`モードで呼び出し

#### Step 3: テストオプション解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | usage_build_generic（669-675行目）：テストオプション定義 |

**テストオプション**:
- `--test-filter`：テスト名フィルタリング
- `--test-cmd`：テスト実行コマンド
- `--test-no-exec`：実行なしコンパイルのみ
- `--test-runner`：カスタムテストランナー

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ buildOutputType (809行目) [mode = .zig_test]
                  │
                  ├─ 引数解析
                  │      ├─ --test-filter
                  │      ├─ --test-cmd
                  │      └─ --test-no-exec
                  │
                  ├─ Compilation.create [is_test = true]
                  │
                  ├─ Compilation.update
                  │      │
                  │      ├─ testブロック検出
                  │      │
                  │      └─ テスト用バイナリ生成
                  │
                  └─ テスト実行
                         │
                         └─ 結果報告
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig (test含む) ────────▶ buildOutputType ─────────────▶ テスト結果
   │                          │                          (stdout)
   │                          ▼
   │                    Compilation [is_test=true]
   │                          │
   │                          ▼
   │                    testブロック検出
   │                          │
   │                          ▼
   │                    テストバイナリ生成
   │                          │
--test-filter ────────────────┤
                              ▼
                         テスト実行
                              │
                              ▼
                         結果集計・表示
                              │
                              ▼
                         終了コード(0/非0)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理（is_testフラグ） |
| tracy.zig | `src/tracy.zig` | ソース | プロファイリング統合 |
