# 画面設計書 7-テストオブジェクト画面

## 概要

本ドキュメントは、Zigコンパイラの「テストオブジェクト画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

テストオブジェクト画面は、Zigソースコードからテスト用のオブジェクトファイルを生成するCLI画面である。テストを実行せずにコンパイルのみを行い、オブジェクトファイルを出力する。

**業務上の目的・背景**：テストのビルドと実行を分離したい場合や、テスト用オブジェクトファイルを他のビルドシステムと統合したい場合に使用する。`zig test-obj`コマンドは、テストブロックを含むオブジェクトファイルを生成し、後続の処理で使用できるようにする。

**画面へのアクセス方法**：
- `zig test-obj [ソースファイル]` - テスト用オブジェクトを生成
- `zig test-obj [オプション] [ファイル...]` - オプション付きで生成

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ソースファイルのパース
3. testブロックの検出
4. テスト用オブジェクトファイルの生成（実行なし）

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：生成完了後にプロセス終了

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | test-obj | 主機能 | テスト用オブジェクトファイルを生成する処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig test-obj [options] [files]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | ○ | テスト対象のソースファイル |
| -target | string | - | ターゲットトリプル |
| -O | Debug/ReleaseFast/ReleaseSafe/ReleaseSmall | - | 最適化モード |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| オブジェクトファイル | binary | テスト用オブジェクトファイル（.o/.obj） |

## 表示項目

| セクション | 説明 |
|-----------|------|
| 進捗表示 | コンパイルの進捗状況 |
| コンパイルエラー | ソースコードのエラー情報 |

## イベント仕様

### 1-テストオブジェクト生成

ユーザーが`zig test-obj [ファイル]`を実行した場合。

**処理フロー**：
1. `buildOutputType`関数を`.zig_test_obj`モードで呼び出し
2. ソースファイルのパース
3. testブロックの収集
4. オブジェクトファイルの生成（テスト実行なし）

## データベース更新仕様

本画面はデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | エラー | コンパイルエラー詳細 | テストコードにエラー |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | ソースファイルが存在しない | エラーメッセージを表示 |
| コンパイルエラー | テストコードに構文/意味エラー | エラー詳細を表示 |

## 備考

- `zig test`との違いは、テストを実行せずにオブジェクトファイルのみを生成する点
- 生成されたオブジェクトファイルは後続のリンク処理で使用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `ArgMode`構造体（742-750行目）：`.zig_test_obj`モード |

**読解のコツ**: `ArgMode`の`.zig_test_obj`がtest-objコマンドに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（273-275行目）：test-objへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `buildOutputType`関数（809行目〜） |

**主要処理フロー**:
1. **273行目**: `mem.eql(u8, cmd, "test-obj")`でコマンド判定
2. **274行目**: `dev.check(.test_command)`でデバッグチェック
3. **275行目**: `buildOutputType`を`.zig_test_obj`モードで呼び出し

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ buildOutputType (809行目) [mode = .zig_test_obj]
                  │
                  ├─ 引数解析
                  │
                  ├─ Compilation.create [is_test = true]
                  │
                  └─ Compilation.update
                         │
                         └─ テスト用オブジェクトファイル生成（実行なし）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig (test含む) ────────▶ buildOutputType ─────────────▶ オブジェクトファイル
                              │                          (.o/.obj)
                              ▼
                        Compilation [is_test=true]
                              │
                              ▼
                        testブロック検出
                              │
                              ▼
                        オブジェクト生成（リンクなし、実行なし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
