# 画面設計書 8-即時実行画面

## 概要

本ドキュメントは、Zigコンパイラの「即時実行画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

即時実行画面は、Zigソースコードから実行ファイルを生成し、即座に実行するCLI画面である。コンパイルと実行を一度のコマンドで行うことで、スクリプト言語のような手軽さでZigプログラムを実行できる。

**業務上の目的・背景**：開発中のコードを素早く試したい場合や、小さなユーティリティプログラムを実行したい場合に、ビルドと実行を別々に行うのは非効率である。`zig run`コマンドは、ソースファイルをその場でコンパイルして実行することで、開発サイクルを高速化する。これにより、Zigをスクリプト言語のように使用することも可能になる。

**画面へのアクセス方法**：
- `zig run [ソースファイル]` - コンパイルして即時実行
- `zig run [オプション] [ファイル] -- [実行時引数]` - オプションと実行時引数付きで実行

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ソースファイルのコンパイル（build-exe相当）
3. 生成された実行ファイルの即時実行
4. 実行結果の出力

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：実行完了後にプロセス終了（実行されたプログラムの終了コードを継承）

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | run | 主機能 | 実行可能ファイルを生成し即座に実行する処理 |
| 1 | build-exe | 補助機能 | 内部でbuild-exeを呼び出して実行ファイルを生成 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig run [options] [files] [-- [args]]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| files | string[] | ○ | 実行するソースファイル |
| -target | string | - | ターゲットトリプル |
| -O | Debug/ReleaseFast/ReleaseSafe/ReleaseSmall | - | 最適化モード |
| -- [args] | string[] | - | 実行時引数（--以降は実行ファイルに渡される） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プログラム出力 | text | 実行されたプログラムの標準出力/標準エラー出力 |
| 終了コード | number | 実行されたプログラムの終了コード |

## 表示項目

| セクション | 説明 |
|-----------|------|
| コンパイルエラー | コンパイル時のエラー情報 |
| プログラム出力 | 実行されたプログラムの出力 |

## イベント仕様

### 1-即時実行

ユーザーが`zig run [ファイル]`を実行した場合。

**処理フロー**：
1. `buildOutputType`関数を`.run`モードで呼び出し
2. ソースファイルをコンパイル
3. 実行ファイルを生成（一時ディレクトリまたはキャッシュ）
4. 生成された実行ファイルを実行
5. 実行結果を出力

### 2-引数付き実行

`zig run file.zig -- arg1 arg2`のように実行時引数を指定した場合。

**処理フロー**：
1. `--`以降の引数を実行時引数として保存
2. コンパイル処理
3. 実行ファイルに引数を渡して実行

## データベース更新仕様

本画面はデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | エラー | コンパイルエラー詳細 | ソースコードにエラー |
| - | エラー | ランタイムエラー | 実行時にエラー発生 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | ソースファイルが存在しない | エラーメッセージを表示 |
| コンパイルエラー | ソースコードに構文/意味エラー | エラー詳細を表示 |
| 実行時エラー | プログラム実行中にエラー発生 | スタックトレースを表示 |

## 備考

- 実行ファイルはキャッシュに保存され、ソースが変更されない限り再利用される
- `--`以降の引数はZigコンパイラではなく実行されるプログラムに渡される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `ArgMode`構造体（742-750行目）：`.run`モード |

**読解のコツ**: `ArgMode`の`.run`がrunコマンドに対応する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（276-278行目）：runへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `buildOutputType`関数（809行目〜） |

**主要処理フロー**:
1. **276行目**: `mem.eql(u8, cmd, "run")`でコマンド判定
2. **277行目**: `dev.check(.run_command)`でデバッグチェック
3. **278行目**: `buildOutputType`を`.run`モードで呼び出し

#### Step 3: 実行時引数の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | `runtime_args_start`変数（900行目）：実行時引数開始位置 |

**実行時引数の処理**:
- `--`を検出すると、それ以降の引数は`runtime_args`として保存
- 保存された引数は実行ファイル起動時に渡される

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ buildOutputType (809行目) [mode = .run]
                  │
                  ├─ 引数解析
                  │      └─ -- 以降の引数を runtime_args として保存
                  │
                  ├─ Compilation.create
                  │
                  ├─ Compilation.update
                  │      └─ 実行ファイル生成
                  │
                  └─ 実行ファイルの起動
                         │
                         ├─ runtime_args を引数として渡す
                         │
                         └─ 実行結果を返却
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig ────────────────────▶ buildOutputType ─────────────▶ プログラム出力
   │                           │                          (stdout/stderr)
   │                           ▼
   │                     Compilation
   │                           │
   │                           ▼
   │                     実行ファイル生成（キャッシュ）
   │                           │
-- arg1 arg2 ─────────────────┤
                               ▼
                         実行ファイル起動
                               │
                               ▼
                         終了コード
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理 |
