# 画面設計書 9-AST検査画面

## 概要

本ドキュメントは、Zigコンパイラの「AST検査画面」機能について、コマンドラインインターフェース（CLI）の仕様と実装を詳細に記述した画面設計書である。

### 本画面の処理概要

AST検査画面は、Zigソースファイルまたは.zonファイルの構文エラーをチェックするCLI画面である。ソースコード単体で検出可能なエラーを報告し、完全なビルドを行わずに素早くコードの妥当性を確認できる。

**業務上の目的・背景**：開発中にコードの構文的な正しさを素早く確認したい場合がある。完全なビルドはターゲット情報や依存関係の解決が必要で時間がかかるが、`zig ast-check`は構文解析と基本的な意味解析のみを行うため、高速にエラーを検出できる。エディタの保存時フックやCI/CDパイプラインの初期段階での使用に適している。

**画面へのアクセス方法**：
- `zig ast-check [ファイル]` - ファイルの構文をチェック
- `zig ast-check` - 標準入力からコードを読み取りチェック
- `zig ast-check --zon [ファイル]` - ZONファイルとしてチェック

**主要な操作・処理内容**：
1. コマンドライン引数の解析
2. ソースファイルの読み込み（またはstdinから読み取り）
3. AST（抽象構文木）のパース
4. ZIR（Zig中間表現）の生成と基本的な意味解析
5. エラーの報告

**画面遷移**：
- 遷移元：任意（コマンドラインからの直接実行）
- 遷移先：チェック完了後にプロセス終了（エラーなし：終了コード0、エラーあり：非0）

**権限による表示制御**：権限による表示制御は存在しない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | ast-check | 主機能 | ファイルの構文エラーをチェックする処理 |
| 43 | Sema（意味解析） | 補助機能 | 構文解析後の意味解析処理 |

## 画面種別

処理実行（CLIテキスト出力）

## URL/ルーティング

```
zig ast-check [options] [file]
```

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| file | string | - | チェック対象のファイル（省略時はstdin） |
| --color | auto/on/off | - | 色付き出力の制御 |
| --zon | - | - | ZONファイルとして扱う |
| -t | - | - | ZIRのテキスト形式出力（デバッグ用） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エラーメッセージ | text | 検出されたエラーの詳細 |
| 終了コード | number | エラーなし：0、エラーあり：1以上 |

## 表示項目

| セクション | 説明 |
|-----------|------|
| 構文エラー | パース時のエラー（行番号、カラム番号付き） |
| 意味エラー | ZIR生成時のエラー |

## イベント仕様

### 1-ファイルチェック

ユーザーが`zig ast-check [ファイル]`を実行した場合。

**処理フロー**：
1. `cmdAstCheck`関数で引数を解析
2. ファイルを読み込み
3. `std.zig.Ast.parse`でASTを生成
4. `AstGen.generate`でZIRを生成
5. エラーがあれば報告

### 2-標準入力からのチェック

ファイルを省略した場合。

**処理フロー**：
1. 標準入力からソースコードを読み取り
2. 以降はファイルチェックと同様

### 3-ZONファイルチェック

`--zon`オプションが指定された場合。

**処理フロー**：
1. ファイルをZONとしてパース
2. `ZonGen.generate`でZOIRを生成
3. エラーがあれば報告

## データベース更新仕様

本画面はデータベースを使用しない。読み取り専用の検証処理である。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | エラー | 構文エラー詳細 | パース失敗時 |
| - | エラー | 意味エラー詳細 | ZIR生成失敗時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ファイル未発見 | 指定されたファイルが存在しない | エラーメッセージを表示 |
| 構文エラー | ソースコードに構文エラー | エラー位置と詳細を表示 |
| 意味エラー | ZIR生成時にエラー | エラー詳細を表示 |

## 備考

- ターゲット情報や型チェックは行わない（それらはビルド時に実行）
- `-t`オプションはデバッグビルドでのみ使用可能
- .zigファイルと.zonファイルの両方に対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | main.zig | `src/main.zig` | `usage_ast_check`定数（6166-6181行目）：ヘルプテキスト |

**読解のコツ**: ast-checkは他のビルドコマンドと異なり、専用の`cmdAstCheck`関数を持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | `mainArgs`関数（379-380行目）：ast-checkへのディスパッチ |
| 2-2 | main.zig | `src/main.zig` | `cmdAstCheck`関数（6184-6349行目）：AST検査処理 |

**主要処理フロー**:
1. **379行目**: `mem.eql(u8, cmd, "ast-check")`でコマンド判定
2. **380行目**: `cmdAstCheck(arena, io, cmd_args)`を呼び出し
3. **6184行目**: `cmdAstCheck`関数開始
4. **6185行目**: `dev.check(.ast_check_command)`でデバッグチェック
5. **6194-6222行目**: 引数解析ループ
6. **6248行目**: `Ast.parse`でAST生成
7. **6254行目**: `AstGen.generate`でZIR生成

#### Step 3: パースと意味解析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | .zigモードの処理（6253-6323行目） |
| 3-2 | main.zig | `src/main.zig` | .zonモードの処理（6325-6347行目） |

**主要処理フロー**:
- **6248行目**: `Ast.parse(arena, source, mode)`でASTを生成
- **6254行目**: `AstGen.generate(arena, tree)`でZIRを生成
- **6256-6265行目**: コンパイルエラーがあれば報告
- **6326行目**: `ZonGen.generate`でZONの場合のZOIRを生成

### プログラム呼び出し階層図

```
main (171行目)
    │
    └─ mainArgs (219行目)
           │
           └─ cmdAstCheck (6184行目)
                  │
                  ├─ dev.check(.ast_check_command) (6185行目)
                  │
                  ├─ 引数解析 (6194-6222行目)
                  │      ├─ --color
                  │      ├─ --zon
                  │      └─ -t (デバッグ)
                  │
                  ├─ ソースファイル読み込み (6225-6236行目)
                  │
                  ├─ Ast.parse (6248行目)
                  │      └─ AST生成
                  │
                  ├─ [.zigモード]
                  │      │
                  │      ├─ AstGen.generate (6254行目)
                  │      │      └─ ZIR生成
                  │      │
                  │      └─ エラー報告 (6256-6265行目)
                  │
                  └─ [.zonモード]
                         │
                         ├─ ZonGen.generate (6326行目)
                         │      └─ ZOIR生成
                         │
                         └─ エラー報告 (6327-6334行目)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

.zig/.zon ───────────────▶ cmdAstCheck ─────────────────▶ エラー報告
   │                           │                          (stderr)
   │                           ▼
   │                      ファイル読み込み
   │                           │
   │                           ▼
   │                      Ast.parse
   │                           │
   │                           ▼
   │                      [.zigモード]
   │                           │
   │                      AstGen.generate
   │                           │
   │                           ▼
stdin ─────────────────────────┤
                               ▼
                         エラー有無判定
                               │
                               ▼
                         終了コード(0/1/2)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | コマンドエントリポイント、cmdAstCheck関数 |
| Ast（標準ライブラリ） | `lib/std/zig/Ast.zig` | ソース | AST定義とパース処理 |
| AstGen（標準ライブラリ） | `lib/std/zig/AstGen.zig` | ソース | ZIR生成 |
| ZonGen（標準ライブラリ） | `lib/std/zig/ZonGen.zig` | ソース | ZOIR生成 |
| print_zir.zig | `src/print_zir.zig` | ソース | ZIRのテキスト形式出力（-tオプション用） |
