---
generated_at: 2026-02-01 17:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-ヘルプ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **dev.check関数の動作**：dev.zigの詳細実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` 77-119行目 - normal_usage定数定義
- E-02: `src/main.zig` 121-130行目 - debug_usage定数定義
- E-03: `src/main.zig` 132行目 - usage定数（条件分岐）
- E-04: `src/main.zig` 171-217行目 - main関数
- E-05: `src/main.zig` 219-393行目 - mainArgs関数
- E-06: `src/main.zig` 376-378行目 - helpコマンド処理
- E-07: `src/main.zig` 189-191行目 - 引数なし時の処理
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig help / zig -h / zig --help でヘルプ表示 | E-06 | ○ |
| C-02 | 引数なしでzigを実行するとヘルプが表示される | E-07 | ○ |
| C-03 | normal_usageが77-119行目に定義されている | E-01 | ○ |
| C-04 | debug_usageが121-130行目に定義されている | E-02 | ○ |
| C-05 | usageはビルド設定で切り替わる | E-03 | ○ |
| C-06 | main関数が171行目から始まる | E-04 | ○ |
| C-07 | mainArgs関数でコマンドディスパッチ | E-05 | ○ |
| C-08 | helpコマンドは376-378行目で処理 | E-06 | ○ |
| C-09 | dev.checkでデバッグチェックを実行 | E-06 | △ |
| C-10 | 標準出力にヘルプテキストを出力 | E-06 | ○ |
| C-11 | デバッグビルドでデバッグコマンドが表示される | E-02, E-03 | ○ |
| C-12 | 画面Noが1である | E-08 | ○ |
| C-13 | 機能Noが23である | E-09 | ○ |
| C-14 | 関連機能はhelp | E-09 | ○ |
| C-15 | 引数なし時にfatalでエラー終了 | E-07 | ○ |
| C-16 | Io.File.stdout().writeStreamingAllで出力 | E-06 | ○ |
| C-17 | デバッグコマンドにchangelist、dump-zir、detect-cpu、llvm-intsが含まれる | E-02 | ○ |
| C-18 | プロセスが正常終了する | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- dev.zigの詳細実装（dev.check関数の内部動作）
  - 候補：`src/dev.zig`を詳細確認 / 開発者に確認 / 実行時動作確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ヘルプ表示は読み取り専用の単純な処理であり、副作用はない

## 6) レビュアーチェックリスト（最小）
- [ ] normal_usageとdebug_usageの内容が最新のコマンド一覧と一致しているか確認
- [ ] dev.check(.help_command)の動作がドキュメント通りか確認
- [ ] デバッグビルド時の表示内容を実際に確認
