---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-フォーマット画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 318-320行目 - fmtコマンドへのディスパッチ
- E-02: `src/fmt.zig` 10-27行目 - usage_fmt定数
- E-03: `src/fmt.zig` 30-43行目 - Fmt構造体
- E-04: `src/fmt.zig` 45-205行目 - run関数
- E-05: `src/fmt.zig` 56-94行目 - 引数解析ループ
- E-06: `src/fmt.zig` 97-158行目 - --stdin処理
- E-07: `src/fmt.zig` 207-216行目 - fmtPath関数
- E-08: `src/fmt.zig` 218-254行目 - fmtPathDir関数
- E-09: `src/fmt.zig` 256-365行目 - fmtPathFile関数
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig fmtでソースコードをフォーマット | E-01 | ○ |
| C-02 | 318行目でfmtコマンド判定 | E-01 | ○ |
| C-03 | dev.check(.fmt_command)を呼び出す | E-01 | ○ |
| C-04 | fmt.zigのrun関数を呼び出す | E-01, E-04 | ○ |
| C-05 | usage_fmtが10行目から定義 | E-02 | ○ |
| C-06 | Fmt構造体が30行目から定義 | E-03 | ○ |
| C-07 | --stdinオプションで標準入力から読み取り | E-02, E-05, E-06 | ○ |
| C-08 | --checkオプションで変更なしチェック | E-02, E-05 | ○ |
| C-09 | --ast-checkオプションで構文チェック併用 | E-02, E-05 | ○ |
| C-10 | --excludeオプションで除外指定 | E-02, E-05 | ○ |
| C-11 | --zonオプションでZONファイルとして扱う | E-02, E-05 | ○ |
| C-12 | --colorオプションで色付き出力制御 | E-02, E-05 | ○ |
| C-13 | fmtPath関数でパス処理 | E-07 | ○ |
| C-14 | fmtPathDir関数でディレクトリ走査 | E-08 | ○ |
| C-15 | fmtPathFile関数でファイルフォーマット | E-09 | ○ |
| C-16 | Ast.parseでAST生成 | E-09 | ○ |
| C-17 | tree.renderで整形 | E-09 | ○ |
| C-18 | アトミック書き込みでファイル更新 | E-09 | ○ |
| C-19 | .で始まるファイルはスキップ | E-08 | ○ |
| C-20 | 画面Noが10である | E-10 | ○ |
| C-21 | 主機能は機能No11のfmt | E-11 | ○ |
| C-22 | 補助機能に機能No47のZIRが含まれる | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - fmtコマンドはファイルを上書きするため、意図しない変更に注意

## 6) レビュアーチェックリスト（最小）
- [ ] アトミック書き込みの動作を確認
- [ ] --checkオプションの動作を確認
- [ ] --excludeオプションの動作を確認
- [ ] ディレクトリ再帰走査の動作を確認
- [ ] .で始まるファイルのスキップ動作を確認
