---
generated_at: 2026-02-01 16:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-C言語変換画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **aroフロントエンドの詳細動作**：JIT版translate-cの実装詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 306-308行目 - translate-cコマンドのディスパッチ
- E-02: `src/main.zig` 746行目 - ArgMode.translate_c定義
- E-03: `src/main.zig` 1025-1028行目 - translate_cモードの初期化
- E-04: `src/main.zig` 2987-2988行目 - ソースファイル数の検証
- E-05: `src/main.zig` 3718-3719行目 - cmdTranslateC呼び出し
- E-06: `src/main.zig` 4641-4721行目 - cmdTranslateC関数の実装
- E-07: `src/main.zig` 4724-4740行目 - JIT版translateC関数
- E-08: `画面一覧.csv` 12行目 - C言語変換画面の定義
- E-09: `画面機能マッピング.csv` 26行目 - translate-c機能のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig translate-cコマンドで変換機能にアクセス | E-01, E-02 | ○ |
| C-02 | CソースファイルをZigコードに変換 | E-06, E-08 | ○ |
| C-03 | ソースファイルは1つのみ許可 | E-04 | ○ |
| C-04 | translate_cモードではemit_bin = no | E-03 | ○ |
| C-05 | translate_cモードではoutput_mode = Obj | E-03 | ○ |
| C-06 | キャッシュマニフェストで結果をキャッシュ | E-06 | ○ |
| C-07 | Cache.Manifestのhit()でキャッシュ判定 | E-06 | ○ |
| C-08 | comp.translateC()で実際の変換処理 | E-06 | ○ |
| C-09 | 変換結果は標準出力に出力 | E-06 | ○ |
| C-10 | エラー時はerrors.renderToStderrで表示 | E-06 | ○ |
| C-11 | 関連機能No.13がtranslate-c | E-09 | ○ |
| C-12 | JIT版はjitCmdで実行 | E-07 | ○ |
| C-13 | JIT版はaro（arocc）を使用 | E-07 | ○ |
| C-14 | LLVM拡張機能が必要（Clang使用時） | E-06 | ○ |
| C-15 | aroフロントエンドの詳細な変換ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- aroによるC解析の詳細実装
  - 候補：`lib/compiler/aro/` ディレクトリ内のファイル
- translate-c JIT版のメイン関数
  - 候補：`lib/compiler/translate-c/main.zig`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能説明と入出力仕様
- 1: 中リスク - aroフロントエンドの動作詳細
- 0: 低リスク - キャッシュ処理フロー

## 6) レビュアーチェックリスト（最小）
- [ ] cmdTranslateC関数のフローが設計書と一致するか確認
- [ ] キャッシュヒット/ミスの処理パスが正確か確認
- [ ] aroフロントエンドの動作を確認し、必要に応じて設計書を補完
- [ ] -cflagsなどのオプション処理が網羅されているか確認
