---
generated_at: 2026-02-01 17:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：15-C++コンパイラ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **libc++統合の詳細処理**：libc++のリンク方法とバンドル仕様

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 100行目 - c++コマンドのヘルプ文字列
- E-02: `src/main.zig` 303-305行目 - c++コマンドのディスパッチ
- E-03: `src/main.zig` 745行目 - ArgMode.cpp定義
- E-04: `src/main.zig` 5773行目 - ZigClang_main外部関数宣言
- E-05: `src/main.zig` 5784-5796行目 - clangMain関数の実装
- E-06: `src/main.zig` 5785-5786行目 - LLVM拡張チェック
- E-07: `画面一覧.csv` 15行目 - C++コンパイラ画面の定義
- E-08: `画面機能マッピング.csv` 30-31行目 - c++機能とlibcxxのマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig c++コマンドでC++コンパイラ機能にアクセス | E-01, E-02 | ○ |
| C-02 | LLVM拡張機能が必要 | E-05, E-06 | ○ |
| C-03 | ArgMode.cppでbuildOutputTypeを呼び出し | E-02, E-03 | ○ |
| C-04 | ccと同じclangMain関数を使用 | E-05 | ○ |
| C-05 | G++/Clang++互換のコマンドライン構文 | E-01 | ○ |
| C-06 | ドロップインC++コンパイラとして動作 | E-01, E-07 | ○ |
| C-07 | 関連機能No.15がc++ | E-08 | ○ |
| C-08 | libcxx（No.63）が補助機能 | E-08 | ○ |
| C-09 | ccと同じcc_command機能フラグを使用 | E-02 | ○ |
| C-10 | ZigClang_mainでClangを呼び出し | E-04, E-05 | ○ |
| C-11 | libc++のバンドルとクロスコンパイル | E-08 | ○ |
| C-12 | libc++リンクの具体的な処理フロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- libc++統合処理の詳細
  - 候補：`src/libs/` ディレクトリ内のlibc++関連ファイル、`src/Compilation.zig`内のC++処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能説明
- 1: 中リスク - libc++統合の詳細
- 0: 低リスク - ccとの共通処理

## 6) レビュアーチェックリスト（最小）
- [ ] c++とccの処理の差異が正確に記載されているか確認
- [ ] libc++のリンク処理を確認し、必要に応じて設計書を補完
- [ ] サポートされているC++標準のバージョンを確認
