---
generated_at: 2026-02-01 17:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-Objcopyツール画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 104行目 - objcopyコマンドのヘルプ文字列
- E-02: `src/main.zig` 321-325行目 - objcopyコマンドのディスパッチ
- E-03: `lib/compiler/objcopy.zig` 20-24行目 - main関数
- E-04: `lib/compiler/objcopy.zig` 26-244行目 - cmdObjCopy関数
- E-05: `lib/compiler/objcopy.zig` 43-141行目 - 引数解析
- E-06: `lib/compiler/objcopy.zig` 152-155行目 - ELFヘッダー読み込み
- E-07: `lib/compiler/objcopy.zig` 178-209行目 - 出力形式分岐
- E-08: `lib/compiler/objcopy.zig` 246-266行目 - usageメッセージ
- E-09: `lib/compiler/objcopy.zig` 268-275行目 - EmitRawElfOptions構造体
- E-10: `画面一覧.csv` 19行目 - Objcopyツール画面の定義
- E-11: `画面機能マッピング.csv` 35行目 - objcopy機能のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig objcopyコマンドでObjcopyツール機能にアクセス | E-01, E-02 | ○ |
| C-02 | jitCmdでobjcopy.zigをJITコンパイル | E-02 | ○ |
| C-03 | LLVM拡張は不要（純粋Zig実装） | E-02, E-03 | ○ |
| C-04 | ELF形式の入力をサポート | E-06, E-07 | ○ |
| C-05 | バイナリ形式への変換をサポート | E-07 | ○ |
| C-06 | Intel HEX形式への変換をサポート | E-07 | ○ |
| C-07 | --strip-debugオプションをサポート | E-05 | ○ |
| C-08 | --strip-allオプションをサポート | E-05 | ○ |
| C-09 | --only-keep-debugオプションをサポート | E-05 | ○ |
| C-10 | --only-sectionオプションをサポート | E-05 | ○ |
| C-11 | --pad-toオプションをサポート | E-05 | ○ |
| C-12 | --add-sectionオプションをサポート | E-05 | ○ |
| C-13 | --listen=-でビルドシステム統合モード | E-04 | ○ |
| C-14 | 関連機能No.20がobjcopy | E-11 | ○ |
| C-15 | ドロップインobjcopyとして動作 | E-01, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能説明
- 0: 低リスク - ELF処理フロー
- 0: 低リスク - オプション処理

## 6) レビュアーチェックリスト（最小）
- [ ] cmdObjCopy関数のオプション処理が網羅されているか確認
- [ ] ELF読み込み処理が正確に記載されているか確認
- [ ] 出力形式の変換処理が正確に記載されているか確認
- [ ] エラーメッセージがソースコードと一致するか確認
