---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-RCツール画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 105行目 - rcコマンドのヘルプ文字列
- E-02: `src/main.zig` 309-317行目 - rcコマンドのディスパッチ
- E-03: `lib/compiler/resinator/main.zig` 21行目以降 - main関数
- E-04: `lib/compiler/resinator/main.zig` 50-67行目 - 初期化処理
- E-05: `lib/compiler/resinator/main.zig` 69-94行目 - オプション解析
- E-06: `lib/compiler/resinator/main.zig` 125-191行目 - プリプロセス処理
- E-07: `lib/compiler/resinator/cli.zig` 14-82行目 - usageメッセージ
- E-08: `lib/compiler/resinator/cli.zig` 152-200行目 - Options構造体
- E-09: `画面一覧.csv` 20行目 - RCツール画面の定義
- E-10: `画面機能マッピング.csv` 36行目 - rc機能のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig rcコマンドでRCツール機能にアクセス | E-01, E-02 | ○ |
| C-02 | jitCmdでresinator/main.zigをJITコンパイル | E-02 | ○ |
| C-03 | LLVM拡張は不要（純粋Zig実装） | E-02, E-03 | ○ |
| C-04 | aroプリプロセッサを使用 | E-02, E-06 | ○ |
| C-05 | --zig-integrationでサーバーモード | E-02 | ○ |
| C-06 | /foオプションで出力ファイル指定 | E-07 | ○ |
| C-07 | /dオプションでマクロ定義 | E-07 | ○ |
| C-08 | /iオプションでインクルードパス追加 | E-07 | ○ |
| C-09 | /lオプションでデフォルト言語ID設定 | E-07 | ○ |
| C-10 | /vオプションで詳細出力モード | E-07 | ○ |
| C-11 | /:no-preprocessオプションでプリプロセスをスキップ | E-07 | ○ |
| C-12 | /:output-formatオプションで出力形式を指定 | E-07, E-08 | ○ |
| C-13 | res形式とcoff形式をサポート | E-08 | ○ |
| C-14 | Microsoft rc.exe互換のコマンドライン構文 | E-07 | ○ |
| C-15 | 独自オプションは「:」で始まる | E-07 | ○ |
| C-16 | 関連機能No.21がrc | E-10 | ○ |
| C-17 | ドロップインrc.exeとして動作 | E-01, E-09 | ○ |
| C-18 | Windowsリソースコンパイル処理を実行 | E-09, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能説明
- 0: 低リスク - オプション処理
- 0: 低リスク - aroプリプロセッサ統合

## 6) レビュアーチェックリスト（最小）
- [ ] cli.zigのOptions構造体がすべてのオプションを網羅しているか確認
- [ ] プリプロセス処理のエラーハンドリングが正確に記載されているか確認
- [ ] 出力形式（res/coff）の変換処理が正確に記載されているか確認
- [ ] rc.exe互換性の範囲を確認
