---
generated_at: 2026-02-01 17:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-環境情報画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 354-367行目 - envコマンドのディスパッチ処理
- E-02: `src/print_env.zig` 12-65行目 - cmdEnv関数の実装
- E-03: `src/print_env.zig` 21-22行目 - 環境変数オーバーライド処理
- E-04: `src/print_env.zig` 24-29行目 - 実行ファイルパス取得
- E-05: `src/print_env.zig` 31-40行目 - Directories初期化
- E-06: `src/print_env.zig` 43-46行目 - パス情報の取得
- E-07: `src/print_env.zig` 48-62行目 - ZONシリアライズ処理
- E-08: `src/print_env.zig` 51-56行目 - 出力フィールド定義
- E-09: `src/print_env.zig` 58-60行目 - 環境変数列挙出力
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` 22行目 - 画面定義
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 37行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig env` である | E-01, E-10 | ○ |
| C-02 | 環境情報をZON形式で出力する | E-07 | ○ |
| C-03 | zig_exe フィールドを出力する | E-08 (51行目) | ○ |
| C-04 | lib_dir フィールドを出力する | E-08 (52行目) | ○ |
| C-05 | std_dir フィールドを出力する | E-08 (53行目) | ○ |
| C-06 | global_cache_dir フィールドを出力する | E-08 (54行目) | ○ |
| C-07 | version フィールドを出力する | E-08 (55行目) | ○ |
| C-08 | target フィールドを出力する | E-08 (56行目) | ○ |
| C-09 | env フィールドで環境変数を出力する | E-09 | ○ |
| C-10 | ZIG_LIB_DIR 環境変数でオーバーライド可能 | E-03 (21行目) | ○ |
| C-11 | ZIG_GLOBAL_CACHE_DIR 環境変数でオーバーライド可能 | E-03 (22行目) | ○ |
| C-12 | WASI環境では引数からパスを取得 | E-04 (24-25行目) | ○ |
| C-13 | dev.check(.env_command)で機能確認 | E-01 (355行目) | ○ |
| C-14 | 関連機能No.22(env)が主機能 | E-11 | ○ |
| C-15 | エラー時にfatalでプロセス終了 | E-04 (27行目) | ○ |
| C-16 | print_env.zigのcmdEnvが実装 | E-02 | ○ |
| C-17 | ホストターゲット情報を解決する | E-01 (356行目) | ○ |
| C-18 | 入力引数を受け取らない | E-02 (16行目 argsは使用されるがオプションなし) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] ZON出力形式のフィールド名がソースコードと一致しているか確認
- [ ] 環境変数名（ZIG_LIB_DIR, ZIG_GLOBAL_CACHE_DIR）が正確か確認
- [ ] WASI環境での動作差異の記述が正確か確認
