---
generated_at: 2026-02-01 17:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-標準ライブラリドキュメント画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 334-341行目 - stdコマンドのjitCmdディスパッチ
- E-02: `lib/compiler/std-docs.zig` 10-22行目 - usage定義
- E-03: `lib/compiler/std-docs.zig` 24-89行目 - main関数
- E-04: `lib/compiler/std-docs.zig` 39-57行目 - 引数パース
- E-05: `lib/compiler/std-docs.zig` 60-64行目 - HTTPサーバー起動
- E-06: `lib/compiler/std-docs.zig` 67-71行目 - ブラウザ起動
- E-07: `lib/compiler/std-docs.zig` 125-132行目 - Context構造体
- E-08: `lib/compiler/std-docs.zig` 134-160行目 - serveRequest関数
- E-09: `lib/compiler/std-docs.zig` 167-186行目 - serveDocsFile関数
- E-10: `lib/compiler/std-docs.zig` 188-244行目 - serveSourcesTar関数
- E-11: `lib/compiler/std-docs.zig` 246-279行目 - serveWasm関数
- E-12: `lib/compiler/std-docs.zig` 285-425行目 - buildWasmBinary関数
- E-13: `lib/compiler/std-docs.zig` 281-283行目 - WASMターゲット設定
- E-14: `lib/compiler/std-docs.zig` 438-458行目 - openBrowserTab関数
- E-15: `docs/code-to-docs/画面一覧/画面一覧.csv` 22行目 - 画面定義
- E-16: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 38行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig std` である | E-01, E-15 | ○ |
| C-02 | jitCmdでJITコンパイル実行される | E-01 (335行目) | ○ |
| C-03 | std-docs.zigが実行される | E-01 (337行目) | ○ |
| C-04 | -p, --port でポート指定可能 | E-02, E-04 (44-48行目) | ○ |
| C-05 | --open-browser でブラウザ起動強制 | E-02, E-04 (49-50行目) | ○ |
| C-06 | --no-open-browser でブラウザ起動抑制 | E-02, E-04 (51-52行目) | ○ |
| C-07 | デフォルトポートは0（エフェメラル） | E-03 (39行目) | ○ |
| C-08 | 127.0.0.1でリッスンする | E-05 (60行目) | ○ |
| C-09 | / で index.html を配信 | E-08 (135-139行目) | ○ |
| C-10 | /main.js で main.js を配信 | E-08 (140-143行目) | ○ |
| C-11 | /main.wasm で WASM を配信 | E-08 (144-147行目) | ○ |
| C-12 | /sources.tar でソースを配信 | E-08 (148-151行目) | ○ |
| C-13 | wasm32-freestanding ターゲット | E-13 (282行目) | ○ |
| C-14 | ReleaseFast/Debug両ビルド対応 | E-11 (145-147行目) | ○ |
| C-15 | cache-controlヘッダーを設定 | E-09 (162-165行目) | ○ |
| C-16 | ビルド結果をキャッシュ利用 | E-12 (302-303行目) | ○ |
| C-17 | ブラウザ起動にxdg-open/open使用 | E-14 (446-450行目) | ○ |
| C-18 | Context構造体でサーバー状態管理 | E-07 | ○ |
| C-19 | 不明なパスは404を返す | E-08 (152-159行目) | ○ |
| C-20 | 関連機能No.24(std)が主機能 | E-16 | ○ |
| C-21 | tarアーカイブに.zigファイルのみ含む | E-10 (213-220行目) | ○ |
| C-22 | HTTPリクエストは並行処理 | E-03 (82,87行目 Io.Group) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] HTTPエンドポイントのパスがソースコードと一致しているか確認
- [ ] WASMビルドのターゲット設定が正確か確認
- [ ] ブラウザ起動コマンドがOS別に正しいか確認
