---
generated_at: 2026-02-01 17:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-libc情報画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 328-333行目 - libcコマンドのjitCmdディスパッチ
- E-02: `lib/compiler/libc.zig` 6-23行目 - usage定義
- E-03: `lib/compiler/libc.zig` 27-135行目 - main関数
- E-04: `lib/compiler/libc.zig` 36-38行目 - 変数初期化
- E-05: `lib/compiler/libc.zig` 41-65行目 - 引数パース
- E-06: `lib/compiler/libc.zig` 67-70行目 - ターゲット解決
- E-07: `lib/compiler/libc.zig` 72-112行目 - includesモード処理
- E-08: `lib/compiler/libc.zig` 114-134行目 - 検出/検証モード処理
- E-09: `lib/compiler/libc.zig` 123-130行目 - findNative呼び出し
- E-10: `lib/compiler/libc.zig` 115-117行目 - parse呼び出し
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` 23行目 - 画面定義
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 39行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig libc` である | E-01, E-11 | ○ |
| C-02 | jitCmdでJITコンパイル実行される | E-01 (329行目) | ○ |
| C-03 | libc.zigが実行される | E-01 (331行目) | ○ |
| C-04 | -target でターゲット指定可能 | E-02, E-05 (50-53行目) | ○ |
| C-05 | -includes でインクルード表示 | E-02, E-05 (54-55行目) | ○ |
| C-06 | paths_fileで検証モード | E-05 (59-62行目) | ○ |
| C-07 | デフォルトターゲットはnative | E-04 (37行目) | ○ |
| C-08 | LibCInstallation.parseで検証 | E-10 | ○ |
| C-09 | LibCInstallation.findNativeで検出 | E-09 | ○ |
| C-10 | verbose=trueで検出 | E-09 (124行目) | ○ |
| C-11 | libc.renderで出力 | E-08 (132行目) | ○ |
| C-12 | LibCDirs.detectでインクルード検出 | E-07 (87-99行目) | ○ |
| C-13 | 非ネイティブターゲットで検出不可 | E-08 (120-121行目) | ○ |
| C-14 | 関連機能No.25(libc)が主機能 | E-12 | ○ |
| C-15 | インクルードなしでエラー | E-07 (101-103行目) | ○ |
| C-16 | パースエラー時にfatal | E-10 (116-117行目) | ○ |
| C-17 | 検出失敗時にfatal | E-09 (127-128行目) | ○ |
| C-18 | -h, --help でヘルプ表示 | E-05 (46-49行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 3つのモード（検出/検証/インクルード表示）の動作が正確か確認
- [ ] エラーメッセージがソースコードと一致しているか確認
- [ ] LibCInstallation構造体のフィールドが正確か確認
