---
generated_at: 2026-02-01 17:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-ターゲット一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 344-349行目 - targetsコマンドのディスパッチ
- E-02: `src/print_targets.zig` 15-137行目 - cmdTargets関数
- E-03: `src/print_targets.zig` 23-26行目 - ライブラリディレクトリ検出
- E-04: `src/print_targets.zig` 28-36行目 - glibc ABIリスト読み込み
- E-05: `src/print_targets.zig` 39-40行目 - glibcメタデータロード
- E-06: `src/print_targets.zig` 47-49行目 - arch/os/abiフィールド出力
- E-07: `src/print_targets.zig` 51-59行目 - libc配列出力
- E-08: `src/print_targets.zig` 61-69行目 - glibcバージョン出力
- E-09: `src/print_targets.zig` 71-88行目 - cpusオブジェクト出力
- E-10: `src/print_targets.zig` 90-100行目 - cpu_features出力
- E-11: `src/print_targets.zig` 102-131行目 - nativeオブジェクト出力
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` 24行目 - 画面定義
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 40行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig targets` である | E-01, E-12 | ○ |
| C-02 | ZON形式で出力する | E-02 (42行目 std.zon.Serializer) | ○ |
| C-03 | archフィールドを出力する | E-06 (47行目) | ○ |
| C-04 | osフィールドを出力する | E-06 (48行目) | ○ |
| C-05 | abiフィールドを出力する | E-06 (49行目) | ○ |
| C-06 | libcフィールドを出力する | E-07 | ○ |
| C-07 | glibcフィールドを出力する | E-08 | ○ |
| C-08 | cpusフィールドを出力する | E-09 | ○ |
| C-09 | cpu_featuresフィールドを出力する | E-10 | ○ |
| C-10 | nativeフィールドを出力する | E-11 | ○ |
| C-11 | native.tripleを出力する | E-11 (105-107行目) | ○ |
| C-12 | native.cpu.archを出力する | E-11 (111行目) | ○ |
| C-13 | native.cpu.nameを出力する | E-11 (113行目) | ○ |
| C-14 | native.featuresを出力する | E-11 (115-124行目) | ○ |
| C-15 | native.osを出力する | E-11 (128行目) | ○ |
| C-16 | native.abiを出力する | E-11 (129行目) | ○ |
| C-17 | Zigライブラリディレクトリを検出する | E-03 | ○ |
| C-18 | glibc ABIリストを読み込む | E-04, E-05 | ○ |
| C-19 | 関連機能No.26(targets)が主機能 | E-13 | ○ |
| C-20 | 入力引数を受け取らない | E-02 (22行目 _ = args) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 出力フィールド名がソースコードと一致しているか確認
- [ ] nativeオブジェクトの構造が正確か確認
- [ ] glibc ABIリストのパスが正確か確認
