---
generated_at: 2026-02-01 17:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-Zen画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 373-375行目 - zenコマンドの実装
- E-02: `src/main.zig` 5752-5769行目 - info_zen定数の定義
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 26行目 - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 42行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig zen` である | E-01 (373行目), E-03 | ○ |
| C-02 | dev.check(.zen_command)で機能確認 | E-01 (374行目) | ○ |
| C-03 | info_zen定数を出力する | E-01 (375行目) | ○ |
| C-04 | "Communicate intent precisely"を含む | E-02 (5754行目) | ○ |
| C-05 | "Edge cases matter"を含む | E-02 (5755行目) | ○ |
| C-06 | "Favor reading code over writing code"を含む | E-02 (5756行目) | ○ |
| C-07 | "Only one obvious way to do things"を含む | E-02 (5757行目) | ○ |
| C-08 | "Runtime crashes are better than bugs"を含む | E-02 (5758行目) | ○ |
| C-09 | "Compile errors are better than runtime crashes"を含む | E-02 (5759行目) | ○ |
| C-10 | "Incremental improvements"を含む | E-02 (5760行目) | ○ |
| C-11 | "Memory is a resource"を含む | E-02 (5765行目) | ○ |
| C-12 | "Together we serve the users"を含む | E-02 (5766行目) | ○ |
| C-13 | 入力引数を受け取らない | E-01 (引数処理なし) | ○ |
| C-14 | 関連機能No.28(zen)が主機能 | E-04 | ○ |
| C-15 | マルチライン文字列リテラルで定義 | E-02 (\\プレフィックス) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] Zen項目が全13項目含まれているか確認
- [ ] 各Zen項目の翻訳が適切か確認
