---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-プロジェクト初期化画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 342-343行目 - initコマンドのディスパッチ
- E-02: `src/main.zig` 4742-4753行目 - usage_init定義
- E-03: `src/main.zig` 4755-4854行目 - cmdInit関数
- E-04: `src/main.zig` 4758-4775行目 - テンプレート選択と引数パース
- E-05: `src/main.zig` 4778-4780行目 - プロジェクト名導出
- E-06: `src/main.zig` 4782-4783行目 - フィンガープリント生成
- E-07: `src/main.zig` 4785-4814行目 - exampleテンプレート処理
- E-08: `src/main.zig` 4816-4852行目 - minimalテンプレート処理
- E-09: `src/main.zig` 4856-4872行目 - sanitizeExampleName関数
- E-10: `src/main.zig` 4791-4796行目 - 生成ファイル一覧（example）
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv` 28行目 - 画面定義
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 45-46行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig init` である | E-01, E-11 | ○ |
| C-02 | -m, --minimal でminimalテンプレート | E-02, E-04 (4764-4765行目) | ○ |
| C-03 | -h, --help でヘルプ表示 | E-02, E-04 (4766-4768行目) | ○ |
| C-04 | exampleで4ファイル生成 | E-10 | ○ |
| C-05 | minimalで2ファイル生成 | E-08 (4817,4834行目) | ○ |
| C-06 | ディレクトリ名からプロジェクト名導出 | E-05 | ○ |
| C-07 | フィンガープリントを生成 | E-06 | ○ |
| C-08 | 既存ファイルは保持 | E-07 (4804行目) | ○ |
| C-09 | 成功時にヘルプメッセージ表示（example） | E-07 (4811-4813行目) | ○ |
| C-10 | 成功時に成功メッセージ表示（minimal） | E-08 (4850行目) | ○ |
| C-11 | minimum_zig_versionを設定 | E-08 (4821,4828行目) | ○ |
| C-12 | 数字始まりに_を追加 | E-09 (4859-4861行目) | ○ |
| C-13 | ハイフン等を_に変換 | E-09 (4864行目) | ○ |
| C-14 | 予約語はfooを返す | E-09 (4867行目) | ○ |
| C-15 | 最大長で切り詰め | E-09 (4868-4869行目) | ○ |
| C-16 | 関連機能No.8(init)が主機能 | E-12 | ○ |
| C-17 | 関連機能No.57(std.Build)が補助機能 | E-12 | ○ |
| C-18 | dev.check(.init_command)で機能確認 | E-03 (4756行目) | ○ |
| C-19 | findTemplatesでテンプレート検索 | E-07 (4787行目) | ○ |
| C-20 | templates.writeでファイル書き込み | E-07 (4800行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] 生成ファイル一覧がソースコードと一致しているか確認
- [ ] sanitizeExampleNameのルールが正確か確認
- [ ] exampleとminimalの違いが正確に記述されているか確認
