---
generated_at: 2026-02-01 17:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-変更リスト画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 383-384行目 - changelistコマンドのディスパッチ
- E-02: `src/main.zig` 6572-6624行目 - cmdChangelist関数
- E-03: `src/main.zig` 6573行目 - dev.check呼び出し
- E-04: `src/main.zig` 6575行目 - color設定
- E-05: `src/main.zig` 6578-6579行目 - 引数取得
- E-06: `src/main.zig` 6581-6588行目 - 古いソース読み込み
- E-07: `src/main.zig` 6589-6596行目 - 新しいソース読み込み
- E-08: `src/main.zig` 6598-6599行目 - 古いAST/ZIR生成
- E-09: `src/main.zig` 6601-6608行目 - 古いZIRエラーチェック
- E-10: `src/main.zig` 6610-6611行目 - 新しいAST/ZIR生成
- E-11: `src/main.zig` 6613-6620行目 - 新しいZIRエラーチェック
- E-12: `src/main.zig` 6622-6623行目 - マッピング計算
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 29行目 - 画面定義
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 47-48行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig changelist` である | E-01, E-13 | ○ |
| C-02 | デバッグビルドでのみ利用可能 | E-01 (build_options.enable_debug_extensions) | ○ |
| C-03 | 2つのソースファイルを引数に取る | E-05 | ○ |
| C-04 | dev.check(.changelist_command)で機能確認 | E-03 | ○ |
| C-05 | 古いソースを読み込む | E-06 | ○ |
| C-06 | 新しいソースを読み込む | E-07 | ○ |
| C-07 | Ast.parseでパース | E-08 (6598行目), E-10 (6610行目) | ○ |
| C-08 | AstGen.generateでZIR生成 | E-08 (6599行目), E-10 (6611行目) | ○ |
| C-09 | loweringFailed()でエラー検出 | E-09 (6601行目), E-11 (6613行目) | ○ |
| C-10 | エラー時にexit(1) | E-09 (6607行目), E-11 (6619行目) | ○ |
| C-11 | Zcu.mapOldZirToNewでマッピング計算 | E-12 | ○ |
| C-12 | color設定は.auto | E-04 | ○ |
| C-13 | inst_mapはAutoHashMapUnmanaged | E-12 (6622行目) | ○ |
| C-14 | 関連機能No.69(changelist)が主機能 | E-14 | ○ |
| C-15 | 関連機能No.47(ZIR)が補助機能 | E-14 | ○ |
| C-16 | ファイルオープン失敗時にfatal | E-06 (6583行目), E-07 (6591行目) | ○ |
| C-17 | ファイル読み込み失敗時にfatal | E-06 (6587行目), E-07 (6595行目) | ○ |
| C-18 | ErrorBundle.Wipでエラー報告 | E-09 (6602-6606行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] デバッグビルド限定の条件が正確か確認
- [ ] ZIRマッピングの出力形式を確認（必要に応じて）
- [ ] エラーハンドリングの流れが正確か確認
