---
generated_at: 2026-02-01 17:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-ZIRダンプ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 385-386行目 - dump-zirコマンドのディスパッチ
- E-02: `src/main.zig` 6528-6569行目 - cmdDumpZir関数
- E-03: `src/main.zig` 6529行目 - dev.check呼び出し
- E-04: `src/main.zig` 6531行目 - Zir型のインポート
- E-05: `src/main.zig` 6533行目 - 引数取得
- E-06: `src/main.zig` 6535-6538行目 - ファイルオープン
- E-07: `src/main.zig` 6540行目 - Zcu.loadZirCache呼び出し
- E-08: `src/main.zig` 6544-6550行目 - サイズ計算
- E-09: `src/main.zig` 6552-6563行目 - サイズ情報出力
- E-10: `src/main.zig` 6567行目 - print_zir.renderAsText呼び出し
- E-11: `src/main.zig` 6568行目 - flush呼び出し
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` 30行目 - 画面定義
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 49-50行目 - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `zig dump-zir` である | E-01, E-12 | ○ |
| C-02 | デバッグビルドでのみ利用可能 | E-01 (build_options.enable_debug_extensions) | ○ |
| C-03 | キャッシュファイルを引数に取る | E-05 | ○ |
| C-04 | dev.check(.dump_zir_command)で機能確認 | E-03 | ○ |
| C-05 | Zcu.loadZirCacheでZIRロード | E-07 | ○ |
| C-06 | Total ZIR bytesを出力 | E-09 (6553行目) | ○ |
| C-07 | Instructions数を出力 | E-09 (6554行目) | ○ |
| C-08 | String Table Bytesを出力 | E-09 (6555行目) | ○ |
| C-09 | Extra Data Itemsを出力 | E-09 (6556行目) | ○ |
| C-10 | print_zir.renderAsTextで命令出力 | E-10 | ○ |
| C-11 | 出力をフラッシュする | E-11 | ○ |
| C-12 | instruction_bytesの計算式 | E-08 (6544-6547行目) | ○ |
| C-13 | extra_bytesの計算式 | E-08 (6548行目) | ○ |
| C-14 | total_bytesの計算式 | E-08 (6549-6550行目) | ○ |
| C-15 | 関連機能No.70(dump-zir)が主機能 | E-13 | ○ |
| C-16 | 関連機能No.47(ZIR)が補助機能 | E-13 | ○ |
| C-17 | ファイルオープン失敗時にfatal | E-06 (6536行目) | ○ |
| C-18 | Zir型はstd.zig.Zir | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] デバッグビルド限定の条件が正確か確認
- [ ] サイズ計算のフォーマット（{Bi}等）が正確か確認
- [ ] print_zir.renderAsTextの出力形式を確認（必要に応じて）
