---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-CPU検出画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` 行番号121-130（debug_usage定義）
- E-02: `src/main.zig` 行番号381-382（コマンドディスパッチ）
- E-03: `src/main.zig` 行番号6351-6399（cmdDetectCpu関数）
- E-04: `src/main.zig` 行番号6354-6363（ヘルプメッセージ定義）
- E-05: `src/main.zig` 行番号6386-6398（LLVMモード処理）
- E-06: `src/main.zig` 行番号6401-6462（detectNativeCpuWithLLVM関数）
- E-07: `src/main.zig` 行番号6464-6482（printCpu関数）
- E-08: `src/codegen/llvm/bindings.zig` 行番号341-345（LLVM API宣言）
- E-09: `src/codegen/llvm/bindings.zig` 行番号155-156（abiAlignmentOfType）
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` 行番号32
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行番号51

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `zig detect-cpu`コマンドが存在する | E-01, E-02 | ○ |
| C-02 | デバッグビルドでのみ利用可能 | E-01, E-02 | ○ |
| C-03 | CPU名と機能セットを標準出力に表示する | E-07 | ○ |
| C-04 | `--llvm`オプションでLLVM APIを使用可能 | E-03, E-04, E-05 | ○ |
| C-05 | `-h/--help`オプションでヘルプ表示 | E-03, E-04 | ○ |
| C-06 | cmdDetectCpu関数がエントリポイント | E-02, E-03 | ○ |
| C-07 | dev.check(.detect_cpu_command)が呼ばれる | E-03（行6352） | ○ |
| C-08 | llvm.GetHostCPUName()でCPU名を取得 | E-05, E-08 | ○ |
| C-09 | llvm.GetHostCPUFeatures()で機能セットを取得 | E-05, E-08 | ○ |
| C-10 | detectNativeCpuWithLLVM()でLLVM→Zig変換 | E-05, E-06 | ○ |
| C-11 | printCpu()で出力処理 | E-03, E-07 | ○ |
| C-12 | 機能フラグは+/-形式で出力 | E-07（行6477） | ○ |
| C-13 | build_options.have_llvmのチェックあり | E-05（行6387-6388） | ○ |
| C-14 | LLVM未対応時にエラーメッセージ出力 | E-05（行6388） | ○ |
| C-15 | CPU名検出失敗時にエラー出力 | E-05（行6391） | ○ |
| C-16 | CPU機能検出失敗時にエラー出力 | E-05（行6392） | ○ |
| C-17 | 不明な引数でエラー出力 | E-03（行6378） | ○ |
| C-18 | 予期しない追加引数でエラー出力 | E-03（行6381） | ○ |
| C-19 | ベースラインCPUから初期化 | E-06（行6406） | ○ |
| C-20 | LLVM CPU名からZigモデルにマッピング | E-06（行6408-6425） | ○ |
| C-21 | LLVM機能文字列をパース | E-06（行6429-6458） | ○ |
| C-22 | 機能依存関係をpopulateDependencies()で解決 | E-06（行6460） | ○ |
| C-23 | std.zig.resolveTargetQueryOrFatalでホストターゲット取得 | E-03（行6396） | ○ |
| C-24 | 画面No.31としてCPU検出画面が定義 | E-10 | ○ |
| C-25 | 機能No.71 detect-cpuが主機能 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張について、ソースコード（src/main.zig, src/codegen/llvm/bindings.zig）から直接的な根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接抽出されており、信頼性が高い
- 注意点:
  - デバッグビルド限定機能のため、通常のリリースビルドでは検証不可
  - LLVM APIの動作はLLVMバージョンに依存する可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] main.zigの6351-6399行目でcmdDetectCpu関数の実装を確認
- [ ] main.zigの6401-6462行目でdetectNativeCpuWithLLVM関数の実装を確認
- [ ] main.zigの6464-6482行目でprintCpu関数の出力形式を確認
- [ ] bindings.zigのGetHostCPUName, GetHostCPUFeatures関数宣言を確認
- [ ] build_options.enable_debug_extensionsの条件分岐を確認（行381-382）
