---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-LLVM整数ダンプ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` 行番号128（debug_usage内のllvm-ints定義）
- E-02: `src/main.zig` 行番号387-388（コマンドディスパッチ）
- E-03: `src/main.zig` 行番号6484-6525（cmdDumpLlvmInts関数）
- E-04: `src/main.zig` 行番号6490（dev.check呼び出し）
- E-05: `src/main.zig` 行番号6494-6495（have_llvmチェック）
- E-06: `src/main.zig` 行番号6497（トリプル文字列取得）
- E-07: `src/main.zig` 行番号6501-6503（LLVMターゲット初期化）
- E-08: `src/main.zig` 行番号6505-6513（ターゲット・マシン・データレイアウト作成）
- E-09: `src/main.zig` 行番号6517-6521（整数型ループと出力）
- E-10: `src/codegen/llvm/bindings.zig` 行番号151-157（TargetData定義）
- E-11: `src/codegen/llvm/bindings.zig` 行番号155-156（abiAlignmentOfType定義）
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` 行番号33
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行番号52

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `zig llvm-ints`コマンドが存在する | E-01, E-02 | ○ |
| C-02 | デバッグビルドでのみ利用可能 | E-01, E-02 | ○ |
| C-03 | LLVMバックエンド有効時のみ動作 | E-05 | ○ |
| C-04 | ターゲットトリプルを引数に取る | E-06 | ○ |
| C-05 | 整数型のABIアライメント値を出力する | E-09, E-11 | ○ |
| C-06 | cmdDumpLlvmInts関数がエントリポイント | E-02, E-03 | ○ |
| C-07 | dev.check(.llvm_ints_command)が呼ばれる | E-04 | ○ |
| C-08 | 対象整数型は1,8,16,32,64,128,256ビット | E-09（行6517） | ○ |
| C-09 | aarch64とx86のLLVMターゲットを初期化 | E-07 | ○ |
| C-10 | Target.getFromTripleでトリプルからターゲット取得 | E-08（行6505-6509） | ○ |
| C-11 | TargetMachine.createでマシン作成 | E-08（行6511） | ○ |
| C-12 | createTargetDataLayoutでデータレイアウト取得 | E-08（行6512） | ○ |
| C-13 | Context.createでコンテキスト作成 | E-08（行6513） | ○ |
| C-14 | context.intTypeで整数型作成 | E-09（行6518） | ○ |
| C-15 | dl.abiAlignmentOfTypeでアライメント取得 | E-09（行6519）, E-11 | ○ |
| C-16 | 出力形式は`LLVMABIAlignmentOfType(iN) == M` | E-09（行6520） | ○ |
| C-17 | LLVM未対応時にエラーメッセージ出力 | E-05 | ○ |
| C-18 | 無効なトリプルでパニック | E-08（行6508） | ○ |
| C-19 | cleanExit()で正常終了 | E-03（行6524） | ○ |
| C-20 | 画面No.32としてLLVM整数ダンプ画面が定義 | E-12 | ○ |
| C-21 | 機能No.72 llvm-intsが主機能 | E-13 | ○ |
| C-22 | LLVMABIAlignmentOfTypeはLLVM C APIのラッパー | E-10, E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張について、ソースコード（src/main.zig, src/codegen/llvm/bindings.zig）から直接的な根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接抽出されており、信頼性が高い
- 注意点:
  - デバッグビルドかつLLVM有効ビルド限定機能のため、検証環境が限定される
  - 無効なトリプル指定時は`@panic("bad")`となるため、エラーハンドリングが簡素
  - 出力される値はLLVMバージョンやターゲット設定に依存する

## 6) レビュアーチェックリスト（最小）
- [ ] main.zigの6484-6525行目でcmdDumpLlvmInts関数の実装を確認
- [ ] main.zigの6517行目で対象整数型リスト（1,8,16,32,64,128,256）を確認
- [ ] bindings.zigの155-156行目でabiAlignmentOfType関数宣言を確認
- [ ] build_options.enable_debug_extensionsとhave_llvmの条件分岐を確認（行387-388, 6494-6495）
- [ ] aarch64とx86のLLVMターゲット初期化が行われていることを確認（行6501-6503）
