---
generated_at: 2026-02-01 17:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-テストオブジェクト画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 273-275行目 - test-objコマンドへのディスパッチ
- E-02: `src/main.zig` 809行目〜 - buildOutputType関数
- E-03: `src/main.zig` 742-750行目 - ArgMode構造体（.zig_test_obj）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig test-objでテスト用オブジェクトを生成 | E-01 | ○ |
| C-02 | ArgModeで.zig_test_objが使用される | E-01, E-03 | ○ |
| C-03 | 273行目でtest-objコマンド判定 | E-01 | ○ |
| C-04 | dev.check(.test_command)を呼び出す | E-01 | ○ |
| C-05 | buildOutputType関数を呼び出す | E-01, E-02 | ○ |
| C-06 | 画面Noが7である | E-04 | ○ |
| C-07 | 主機能は機能No5のtest-obj | E-05 | ○ |
| C-08 | テスト実行なしでオブジェクト生成 | E-03 | ○ |
| C-09 | is_test=trueでCompilation作成 | E-02, E-03 | ○ |
| C-10 | testブロックが自動検出される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - test-objはtest同様のビルドでテスト実行を省略するのみ

## 6) レビュアーチェックリスト（最小）
- [ ] testとtest-objの動作の違いを確認
- [ ] 生成されるオブジェクトファイルの形式を確認
