---
generated_at: 2026-02-01 17:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-AST検査画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/main.zig` 379-380行目 - ast-checkコマンドへのディスパッチ
- E-02: `src/main.zig` 6166-6181行目 - usage_ast_check定数
- E-03: `src/main.zig` 6184-6349行目 - cmdAstCheck関数
- E-04: `src/main.zig` 6185行目 - dev.check呼び出し
- E-05: `src/main.zig` 6194-6222行目 - 引数解析ループ
- E-06: `src/main.zig` 6248行目 - Ast.parse呼び出し
- E-07: `src/main.zig` 6254行目 - AstGen.generate呼び出し
- E-08: `src/main.zig` 6326行目 - ZonGen.generate呼び出し
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zig ast-checkで構文をチェック | E-01 | ○ |
| C-02 | 379行目でast-checkコマンド判定 | E-01 | ○ |
| C-03 | cmdAstCheck関数を呼び出す | E-01, E-03 | ○ |
| C-04 | dev.check(.ast_check_command)を呼び出す | E-04 | ○ |
| C-05 | usage_ast_checkが6166行目から定義 | E-02 | ○ |
| C-06 | --colorオプションで色付き出力制御 | E-02, E-05 | ○ |
| C-07 | --zonオプションでZONファイルとして扱う | E-02, E-05 | ○ |
| C-08 | -tオプションでZIRテキスト出力 | E-02, E-05 | ○ |
| C-09 | ファイル省略時はstdinから読み取り | E-02, E-03 | ○ |
| C-10 | Ast.parseでAST生成 | E-06 | ○ |
| C-11 | AstGen.generateでZIR生成 | E-07 | ○ |
| C-12 | ZonGen.generateでZOIR生成 | E-08 | ○ |
| C-13 | 画面Noが9である | E-09 | ○ |
| C-14 | 主機能は機能No10のast-check | E-10 | ○ |
| C-15 | 補助機能に機能No43のSemaが含まれる | E-10 | ○ |
| C-16 | エラー時に終了コード非0 | E-03 | ○ |
| C-17 | -tオプションはデバッグビルドのみ | E-03 | ○ |
| C-18 | .zigと.zonの両方に対応 | E-03, E-06, E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ast-checkは読み取り専用の検証処理で副作用なし

## 6) レビュアーチェックリスト（最小）
- [ ] Ast.parseのエラー報告形式を確認
- [ ] AstGen.generateのエラー報告形式を確認
- [ ] --zonオプションの動作を確認
- [ ] stdinからの入力処理を確認
