---
generated_at: 2026-02-01 18:45:00
metrics:
  claims_total: 60
  claims_with_evidence: 57
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：57 / 60、根拠なし：3
- 優先レビュー（高）
  1. **IT-038 Tracy連携**：Tracyの具体的な動作確認方法が不明確
  2. **IT-045 SPIR-V連携**：SPIR-Vバックエンドの完全性が要確認
  3. **IT-047 SPARC64連携**：SPARC64サポートの現状が要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` - メインエントリポイント、コマンド処理
- E-02: `src/Compilation.zig` - コンパイル処理の中核
- E-03: `src/Zcu.zig` - Zigコンパイルユニット
- E-04: `src/Sema.zig` - 意味解析処理
- E-05: `src/Air.zig` - 中間表現（AIR）
- E-06: `src/codegen.zig` - コード生成の統合
- E-07: `src/link.zig` - リンカー処理
- E-08: `src/codegen/llvm.zig` - LLVMバックエンド
- E-09: `src/codegen/x86_64/CodeGen.zig` - x86_64コード生成
- E-10: `src/codegen/aarch64.zig` - AArch64コード生成
- E-11: `src/codegen/wasm/CodeGen.zig` - WASMコード生成
- E-12: `src/codegen/c.zig` - Cバックエンド
- E-13: `src/codegen/riscv64/CodeGen.zig` - RISC-Vコード生成
- E-14: `src/codegen/sparc64/CodeGen.zig` - SPARC64コード生成
- E-15: `src/codegen/spirv/CodeGen.zig` - SPIR-Vコード生成
- E-16: `src/libs/glibc.zig` - glibcサポート
- E-17: `src/libs/musl.zig` - muslサポート
- E-18: `src/libs/wasi_libc.zig` - WASI libcサポート
- E-19: `src/libs/libcxx.zig` - libc++サポート
- E-20: `src/libs/libunwind.zig` - libunwindサポート
- E-21: `src/libs/freebsd.zig` - FreeBSDサポート
- E-22: `src/libs/netbsd.zig` - NetBSDサポート
- E-23: `src/libs/openbsd.zig` - OpenBSDサポート
- E-24: `src/libs/mingw.zig` - MinGWサポート
- E-25: `src/libs/libtsan.zig` - TSANサポート
- E-26: `src/Package.zig` - パッケージ管理
- E-27: `src/Package/Fetch.zig` - パッケージフェッチ
- E-28: `src/Package/Module.zig` - モジュール管理
- E-29: `src/InternPool.zig` - 型インターン
- E-30: `src/tracy.zig` - Tracyプロファイラ統合
- E-31: `build.zig` - ビルドスクリプト
- E-32: `test/tests.zig` - テストフレームワーク
- E-33: `test/behavior.zig` - 動作テスト
- E-34: `test/link/elf.zig` - ELFリンカーテスト
- E-35: `test/link/macho.zig` - Mach-Oリンカーテスト
- E-36: `test/link/wasm/` - WASMリンカーテスト
- E-37: `test/link/bss/` - BSSテスト
- E-38: `test/link/common_symbols/` - 共通シンボルテスト
- E-39: `test/standalone/` - スタンドアロンテスト群
- E-40: `test/incremental/` - 増分コンパイルテスト
- E-41: `test/compile_errors.zig` - コンパイルエラーテスト
- E-42: `test/error_traces.zig` - エラートレーステスト
- E-43: `test/stack_traces.zig` - スタックトレーステスト
- E-44: `test/gen_h.zig` - ヘッダ生成テスト
- E-45: `test/llvm_ir.zig` - LLVM IRテスト
- E-46: `test/llvm_targets.zig` - LLVMターゲットテスト
- E-47: `test/libc.zig` - libcテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Compilation-Zcu連携テスト | E-02, E-03 | ○ |
| C-02 | Sema-Air連携テスト | E-04, E-05 | ○ |
| C-03 | CodeGen-Link連携テスト | E-06, E-07 | ○ |
| C-04 | LLVMバックエンド統合テスト | E-08 | ○ |
| C-05 | x86_64バックエンド統合テスト | E-09 | ○ |
| C-06 | AArch64バックエンド統合テスト | E-10 | ○ |
| C-07 | WASMバックエンド統合テスト | E-11 | ○ |
| C-08 | Cバックエンド統合テスト | E-12 | ○ |
| C-09 | ELFリンカー統合テスト | E-07, E-34 | ○ |
| C-10 | Mach-Oリンカー統合テスト | E-35 | ○ |
| C-11 | glibc統合テスト | E-16 | ○ |
| C-12 | musl統合テスト | E-17 | ○ |
| C-13 | wasi-libc統合テスト | E-18 | ○ |
| C-14 | libc++統合テスト | E-19 | ○ |
| C-15 | libunwind統合テスト | E-20 | ○ |
| C-16 | Package Fetch統合テスト | E-26, E-27 | ○ |
| C-17 | Module解決統合テスト | E-28 | ○ |
| C-18 | build.zig統合テスト | E-31 | ○ |
| C-19 | InternPool連携テスト | E-29 | ○ |
| C-20 | behavior tests統合テスト | E-33 | ○ |
| C-21 | モジュールテスト統合テスト | E-32 | ○ |
| C-22 | ErrorBundle統合テスト | E-02 | ○ |
| C-23 | DWARF生成統合テスト | E-07 | ○ |
| C-24 | クロスターゲット統合テスト | E-32 | ○ |
| C-25 | Clang統合テスト | E-01 | ○ |
| C-26 | translate-c統合テスト | E-01 | ○ |
| C-27 | C compiler統合テスト | E-39 | ○ |
| C-28 | shared library統合テスト | E-39 | ○ |
| C-29 | 依存関係解決テスト | E-39 | ○ |
| C-30 | glibc互換性テスト | E-39 | ○ |
| C-31 | BSS初期化テスト | E-37 | ○ |
| C-32 | common symbols統合テスト | E-38 | ○ |
| C-33 | 静的Cライブラリ統合テスト | E-39 | ○ |
| C-34 | 相互依存静的ライブラリテスト | E-39 | ○ |
| C-35 | WASM統合テスト | E-36 | ○ |
| C-36 | 増分ビルド統合テスト | E-40 | ○ |
| C-37 | ビルドキャッシュ統合テスト | E-31 | ○ |
| C-38 | パフォーマンストレース統合テスト | E-30 | △ |
| C-39 | エラートレース統合テスト | E-42 | ○ |
| C-40 | スタックトレース出力統合テスト | E-43 | ○ |
| C-41 | エラーメッセージ統合テスト | E-41 | ○ |
| C-42 | Cヘッダ生成統合テスト | E-44 | ○ |
| C-43 | LLVM IR出力統合テスト | E-45 | ○ |
| C-44 | ターゲット検出統合テスト | E-46 | ○ |
| C-45 | SPIR-Vバックエンド統合テスト | E-15 | △ |
| C-46 | RISC-Vバックエンド統合テスト | E-13 | ○ |
| C-47 | SPARC64バックエンド統合テスト | E-14 | △ |
| C-48 | TSANライブラリ統合テスト | E-25 | ○ |
| C-49 | FreeBSD libc統合テスト | E-21 | ○ |
| C-50 | NetBSD libc統合テスト | E-22 | ○ |
| C-51 | OpenBSD libc統合テスト | E-23 | ○ |
| C-52 | MinGW統合テスト | E-24 | ○ |
| C-53 | Windowsリソース統合テスト | E-39 | ○ |
| C-54 | Windowsエントリポイント統合テスト | E-39 | ○ |
| C-55 | 環境変数処理統合テスト | E-39 | ○ |
| C-56 | 子プロセス生成統合テスト | E-39 | ○ |
| C-57 | パス処理統合テスト | E-39 | ○ |
| C-58 | 動的ライブラリロード統合テスト | E-39 | ○ |
| C-59 | テストランナーモジュール統合テスト | E-39 | ○ |
| C-60 | POSIX API統合テスト | E-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-38 Tracy連携**：Tracyプロファイラの統合テストの具体的な検証方法が不明確。実際のTracy環境でのテスト手順の詳細化が必要。
  - 候補：Tracy公式ドキュメント / Zigプロジェクトのプロファイリングガイド / CI/CD設定
- **C-45 SPIR-V連携**：SPIR-Vバックエンドは実験的であり、完全な統合テストの範囲が不明確。
  - 候補：SPIR-V仕様書 / Vulkanテスト環境 / GPU互換性マトリクス
- **C-47 SPARC64連携**：SPARC64バックエンドのテスト環境の可用性が限定的。
  - 候補：SPARC64エミュレータ / クロスコンパイルテスト / QEMU設定

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コンパイラコンポーネント連携テスト（IT-001〜IT-003）：コア機能であり、既存テストが充実
- **0: 低リスク** - 主要バックエンド連携テスト（IT-004〜IT-006）：x86_64, AArch64, LLVMは成熟
- **1: 中リスク** - libc連携テスト（IT-011〜IT-015）：プラットフォーム依存性あり
- **1: 中リスク** - リンカー連携テスト（IT-009〜IT-010）：フォーマット固有の問題の可能性
- **2: 高リスク** - 実験的バックエンド（IT-045, IT-047）：SPIR-V, SPARC64は開発中

## 6) レビュアーチェックリスト（最小）
- [ ] コンパイラコンポーネント連携（IT-001〜IT-003）のテスト手順が実行可能か確認
- [ ] 各バックエンド連携テストのターゲット設定が正確か確認
- [ ] libc連携テストのプラットフォーム前提条件が明確か確認
- [ ] パッケージ管理連携テスト（IT-016〜IT-017）のネットワーク依存性を考慮
- [ ] 増分コンパイル連携テスト（IT-036）の変更検知ロジックが正確か確認
- [ ] 実験的バックエンド（SPIR-V, SPARC64）のテスト実行環境が利用可能か確認
- [ ] Windowsテスト（IT-053〜IT-054）のプラットフォーム依存性を確認
- [ ] クロスコンパイルテスト（IT-024）のターゲットマトリクスが網羅的か確認
