---
generated_at: 2026-02-01 16:40:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **TransitiveAnalysisFailure**：コード内での明示的な通知メカニズムが確認しづらい
  2. **PotentiallyOutdated**：ログ出力の詳細な条件が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/std/log.zig` - 標準ログライブラリ定義
- E-02: `src/Compilation.zig` - コンパイル処理とエラーバンドル生成
- E-03: `src/link.zig` - リンカー診断メッセージ（Diags構造体）
- E-04: `src/Zcu.zig` - Zig Compilation UnitのErrorMsg定義
- E-05: `src/main.zig` - fatalエラー処理
- E-06: `src/IncrementalDebugServer.zig` - デバッグサーバー通知
- E-07: `src/Zcu/PerThread.zig` - 更新通知とキャッシュ通知
- E-08: `src/codegen/*.zig` - コード生成スコープログ
- E-09: `src/Sema.zig` - 意味解析スコープログ
- E-10: `src/link/Elf.zig` - ELFリンカースコープログ
- E-11: `src/link/MachO.zig` - Mach-Oリンカースコープログ
- E-12: `src/link/Wasm.zig` - WebAssemblyリンカースコープログ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | error ログ通知 | E-01 (log.zig:30-51, Level.err定義) | ○ |
| C-02 | warning ログ通知 | E-01 (log.zig:30-51, Level.warn定義) | ○ |
| C-03 | info ログ通知 | E-01 (log.zig:30-51, Level.info定義) | ○ |
| C-04 | debug ログ通知 | E-01 (log.zig:30-51, Level.debug定義) | ○ |
| C-05 | LinkFailure 診断メッセージ | E-03 (link.zig:213-217, fail関数) | ○ |
| C-06 | MissingLibraryError 診断メッセージ | E-03 (link.zig:277-292, addMissingLibraryError関数) | ○ |
| C-07 | SourceLocationError 診断メッセージ | E-03 (link.zig:219-223, failSourceLocation関数) | ○ |
| C-08 | ErrorMsg エラーバンドル | E-04 (Zcu.zig:1217-1248, ErrorMsg構造体) | ○ |
| C-09 | ErrorBundle エラーバンドル | E-02 (Compilation.zig:3951-4099, getAllErrorsAlloc関数) | ○ |
| C-10 | AstGenError エラーバンドル | E-02 (Compilation.zig:4047-4077, failed_files処理) | ○ |
| C-11 | ImportError エラーバンドル | E-02 (Compilation.zig:3999-4025, failed_imports処理) | ○ |
| C-12 | AnalysisError エラーバンドル | E-02 (Compilation.zig:4079-4127, failed_analysis処理) | ○ |
| C-13 | fatal 致命的エラー | E-05 (main.zig:66, fatal関数インポート) | ○ |
| C-14 | FileNotFound 致命的エラー | E-03 (link.zig:1978-1998, file not found処理) | ○ |
| C-15 | UnrecognizedExtension 致命的エラー | E-03 (link.zig:2183, unrecognized file extension) | ○ |
| C-16 | LinkerScriptParseError 致命的エラー | E-03 (link.zig:2258, linker script parse error) | ○ |
| C-17 | memory_allocation_failure コンパイル通知 | E-02 (Compilation.zig:3988-3992, alloc_failure_occurred) | ○ |
| C-18 | CacheHit コンパイル通知 | E-02 (Compilation.zig:3003, cache hit log) | ○ |
| C-19 | CacheMiss コンパイル通知 | E-02 (Compilation.zig:3012, cache miss log) | ○ |
| C-20 | JobQueued コンパイル通知 | E-02 (Compilation.zig:2687-2722, job queuing) | ○ |
| C-21 | ClientConnected リンク通知 | E-06 (IncrementalDebugServer.zig:68, client connected) | ○ |
| C-22 | ClientDisconnected リンク通知 | E-06 (IncrementalDebugServer.zig:59,100, client disconnected) | ○ |
| C-23 | AcceptFailed リンク通知 | E-06 (IncrementalDebugServer.zig:63, accept failed) | ○ |
| C-24 | ListenFailed リンク通知 | E-06 (IncrementalDebugServer.zig:49, listen failed) | ○ |
| C-25 | OutdatedDependee 更新通知 | E-04 (Zcu.zig:3066, outdated dependee log) | ○ |
| C-26 | UpToDateDependee 更新通知 | E-04 (Zcu.zig:3112, up-to-date dependee log) | ○ |
| C-27 | PotentiallyOutdated 更新通知 | E-04 (Zcu.zig:3168, potentially outdated log) | △ |
| C-28 | TransitiveAnalysisFailure 更新通知 | E-07 (Zcu/PerThread.zig:679, transitive failure) | △ |
| C-29 | CImportSource Cインポート通知 | E-02 (Compilation.zig:5773, C import source log) | ○ |
| C-30 | DepFileProcessing Cインポート通知 | E-02 (Compilation.zig:5828, dep file processing log) | ○ |
| C-31 | ClangDiagnostics Cインポート通知 | E-02 (Compilation.zig:6456-6469, clang diagnostics) | ○ |
| C-32 | CacheManifestWriteFailure キャッシュ通知 | E-02 (Compilation.zig:3263, cache manifest write failure) | ○ |
| C-33 | AstGenCacheStale キャッシュ通知 | E-07 (Zcu/PerThread.zig:234, cache stale log) | ○ |
| C-34 | AstGenCacheCached キャッシュ通知 | E-07 (Zcu/PerThread.zig:229, cache success log) | ○ |
| C-35 | compilation スコープログ | E-02 (Compilation.zig:11, log scoped) | ○ |
| C-36 | zcu スコープログ | E-04, E-07 (Zcu.zig:16, Zcu/PerThread.zig:12) | ○ |
| C-37 | link スコープログ | E-03, E-10, E-11, E-12 (複数linkファイル) | ○ |
| C-38 | codegen スコープログ | E-08 (codegen.zig:6等、複数ファイル) | ○ |
| C-39 | sema スコープログ | E-09 (Sema.zig:13) | ○ |
| C-40 | incremental_debug_server スコープログ | E-06 (IncrementalDebugServer.zig:449) | ○ |

## 4) 不足情報（Unknown / Missing）
- **TransitiveAnalysisFailure (C-28)**：ログ出力は確認できたが、通知メカニズムとしての完全な仕様が不明確
  - 候補：Sema.zig / 追加のZcu関連ファイル / テストコード
- **PotentiallyOutdated (C-27)**：更新通知の発火条件の詳細仕様が不明確
  - 候補：インクリメンタルコンパイルのドキュメント / Zcu.zigの追加解析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログ通知（C-01〜C-04）、スコープログ（C-35〜C-40）
- 0: 低リスク - 診断メッセージ（C-05〜C-07）
- 0: 低リスク - エラーバンドル（C-08〜C-12）
- 0: 低リスク - 致命的エラー（C-13〜C-16）
- 1: 中リスク - 更新通知（C-27, C-28）：条件の詳細確認が推奨される
- 0: 低リスク - その他の通知（C-17〜C-26, C-29〜C-34）

## 6) レビュアーチェックリスト（最小）
- [ ] ログ通知の4レベル（error/warning/info/debug）がstd.logの定義と一致しているか確認
- [ ] 診断メッセージ（LinkFailure等）がlink.Diagsの実装と一致しているか確認
- [ ] ErrorMsg/ErrorBundleの構造がZcu.zigの定義と一致しているか確認
- [ ] fatal関連の通知がstd.process.fatalの使用箇所と一致しているか確認
- [ ] 更新通知（TransitiveAnalysisFailure, PotentiallyOutdated）の発火条件を追加調査
- [ ] スコープログの一覧が実際のlog.scoped呼び出しを網羅しているか確認
