# 通知設計書 1-error

## 概要

本ドキュメントは、Zigコンパイラにおけるerrorログ通知の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのコンパイル処理中に発生したエラー状態をログとして出力する機能である。

**業務上の目的・背景**：コンパイル処理中に何らかの問題が発生した場合、ユーザーやシステム管理者に対して問題の発生を通知し、デバッグや問題解決を支援するために必要である。エラーログは回復可能または回復不可能な状況を示し、迅速な対応を可能にする。

**通知の送信タイミング**：コンパイル処理中にエラー状態が検出された時点で即座にログ出力される。具体的には、ファイル操作の失敗、Clangコンパイラのエラー、キャッシュ操作の失敗、その他の致命的なエラー発生時にトリガーされる。

**通知の受信者**：コンパイラを実行しているユーザー、またはコンパイラの出力を監視しているシステム。ログは標準エラー出力（stderr）に出力される。

**通知内容の概要**：エラーの種別、エラーメッセージ、関連するファイルパス、発生箇所などの情報が含まれる。ログはANSIカラーコードにより赤色で表示され、視覚的にエラーであることを強調する。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、ソースコードの修正、環境設定の見直し、または必要なファイルの準備を行う。回復不可能なエラーの場合は、コンパイル処理の再実行が必要となる。

## 通知種別

ログ通知（標準エラー出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

ログ出力は固定で標準エラー出力（stderr）に送信される。`std.log.scoped(.xxx).err`または`log.err`関数を通じて出力される。

## 通知テンプレート

### ログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr |
| 色 | 赤色（ANSI escape code使用） |
| 形式 | テキスト |

### 本文テンプレート

```
error: {メッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | ログ通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | エラーメッセージ | 各処理からの引数 | Yes |
| file_path | 関連ファイルパス | 処理対象ファイル | No |
| error_name | エラー名 | @errorName(err) | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | ファイルコピー失敗 | エラー発生時 | emit_pathへのコピー失敗 |
| 内部処理 | Clang診断パース失敗 | パースエラー時 | Clang診断メッセージの解析失敗 |
| 内部処理 | Clang実行失敗 | 異常終了時 | Clangプロセスの異常終了 |
| 内部処理 | 依存ファイルパース失敗 | パースエラー時 | depfileの解析失敗 |
| 内部処理 | フォーマット失敗 | エラー発生時 | ソースファイルのフォーマット失敗 |
| 内部処理 | リソースコンパイル失敗 | 異常終了時 | zig rc処理の失敗 |
| 内部処理 | abilists処理失敗 | パースエラー時 | OpenBSD等のabilists処理失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | エラー発生時は常に出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[エラー発生] --> B[log.err呼び出し]
    B --> C[フォーマット文字列展開]
    C --> D[ANSIカラーコード付与]
    D --> E[stderr出力]
    E --> F[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ログ通知のためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ログ通知のためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 出力失敗 | stderrへの書き込み失敗 | プログラム終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル処理中は常時出力可能）

## セキュリティ考慮事項

- エラーメッセージにファイルパスが含まれる場合があるが、これはユーザーの作業環境情報であり、外部送信されない
- ログ出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- ログスコープ（.compilation, .zcu, .link等）によって出力元を識別可能
- ANSIカラーコードにより赤色で表示されるため、ターミナル上で視認性が高い

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Zigのログシステムは標準ライブラリの`std.log`モジュールを使用している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std/log.zig | Zig標準ライブラリ | ログレベルの定義とscopedログの仕組み |

**読解のコツ**: `std.log.scoped`はコンパイル時にログスコープを生成する関数である。

#### Step 2: エントリーポイントを理解する

各モジュールでのlog変数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 11行目: `log = std.log.scoped(.compilation)` |
| 2-2 | Zcu.zig | `src/Zcu.zig` | 16行目: `log = std.log.scoped(.zcu)` |
| 2-3 | link.zig | `src/link.zig` | 9行目: `log = std.log.scoped(.link)` |

**主要処理フロー**:
1. **11行目 (Compilation.zig)**: `const log = std.log.scoped(.compilation);` - compilationスコープのログオブジェクト作成
2. **3659行目 (Compilation.zig)**: `log.err("unable to copy '{f}' to '{f}': {t}", ...)` - ファイルコピー失敗時のエラーログ

#### Step 3: エラーログ呼び出し箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | 3659, 6456, 6461, 6465, 6469, 6512行目等でのlog.err呼び出し |
| 3-2 | fmt.zig | `src/fmt.zig` | 211, 247行目でのstd.log.err呼び出し |
| 3-3 | libs/openbsd.zig | `src/libs/openbsd.zig` | 195, 231行目でのlog.err呼び出し |

**主要処理フロー**:
- **3659行目**: ファイルコピー失敗時のエラー出力
- **6456-6469行目**: Clang関連エラーの出力
- **6875-6884行目**: リソースコンパイル失敗時のエラー出力

### プログラム呼び出し階層図

```
std.log.scoped(.compilation)
    │
    ├─ log.err(format, args)
    │      └─ std.log.log (内部ログ処理)
    │              └─ stderr.write
    │
    └─ 各処理でのエラー検出
           ├─ ファイル操作エラー
           ├─ Clang実行エラー
           └─ パースエラー
```

### データフロー図

```
[入力]               [処理]                    [出力]

エラー発生 ───▶ log.err(format, args) ───▶ stderr（赤色表示）
    │
    └─ format: フォーマット文字列
    └─ args: 可変長引数（エラー情報）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理のメイン、log.err多数使用 |
| Zcu.zig | `src/Zcu.zig` | ソース | ZCU処理、zcuスコープのログ使用 |
| link.zig | `src/link.zig` | ソース | リンカー処理、linkスコープのログ使用 |
| fmt.zig | `src/fmt.zig` | ソース | フォーマット処理、std.log.err使用 |
| libs/openbsd.zig | `src/libs/openbsd.zig` | ソース | OpenBSDライブラリ処理 |
