# 通知設計書 10-AstGenError

## 概要

本ドキュメントは、ZigコンパイラにおけるAST生成エラー（AstGenError）の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのソースコードパース処理（AST生成/ZIR生成/ZOIR生成）中に発生したエラーを報告する機能である。

**業務上の目的・背景**：Zigソースコードまたはゾンファイルの構文解析およびZIR/ZOIR生成中に発生したエラーをユーザーに報告するために必要である。AstGenエラーは意味解析（Sema）より前の段階で発生し、エラーが発生した場合は意味解析がスキップされる。

**通知の送信タイミング**：AstGen処理中にエラーが検出された時点で`failed_files`マップにエントリが追加される。最終的なエラー出力は`Compilation.getAllErrorsAlloc()`で行われる。

**通知の受信者**：コンパイラを実行しているユーザー。エラーメッセージは最終的に標準エラー出力（stderr）に出力される。

**通知内容の概要**：ファイル単位でのエラー情報が含まれる。リトライ可能なエラー（ファイルシステムエラー等）の場合はエラーメッセージ文字列が、非リトライエラー（構文エラー等）の場合はZIR/ZOIRのエラー情報が含まれる。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、ソースコードの構文エラーを修正する。ファイルシステムエラーの場合は、ファイルのアクセス権限やパスを確認する。

## 通知種別

エラーバンドル（ErrorBundle経由での出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（エラー蓄積後にバッチ出力） |
| 優先度 | 高 |
| リトライ | 有り（retryable_failureの場合） |

### 送信先決定ロジック

エラーは`Zcu.failed_files`マップに蓄積される。キーはFile.Index、値はオプションの[]u8（リトライ可能エラーのメッセージ）。最終的に`Compilation.getAllErrorsAlloc()`によってErrorBundleに変換されて出力される。

## 通知テンプレート

### エラー出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr（ErrorBundle経由） |
| 形式 | 構造化エラーメッセージ |

### 本文テンプレート

```
{ファイルパス}: error: {エラーメッセージ}
```

または（ZIR/ZOIRエラーの場合）

```
{ファイルパス}:{行}:{列}: error: {エラーメッセージ}
{ソース行}
        ^
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | エラーメッセージのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_index | ファイルインデックス | File.Index | Yes |
| error_msg | エラーメッセージ | []u8またはZIR/ZOIRエラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| AstGen | ソースファイル解析失敗 | パースエラー時 | 構文エラー |
| AstGen | ファイルアクセス失敗 | I/Oエラー時 | リトライ可能エラー |
| ZonGen | ゾンファイル解析失敗 | パースエラー時 | ZON構文エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| alive_filesに含まれない | 到達不能なファイルのエラーは出力されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AstGen開始] --> B{パース成功?}
    B -->|Yes| C[ZIR生成]
    B -->|No| D[failed_filesに追加]
    C --> E{ZIR生成成功?}
    E -->|Yes| F[処理継続]
    E -->|No| D
    D --> G[skip_analysis_this_update = true]
    G --> H[getAllErrorsAlloc]
    H --> I[ErrorBundle生成]
    I --> J[stderr出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | エラーメッセージのためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | エラーメッセージのためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| retryable_failure | ファイルシステムエラー | 次回更新時に再試行 |
| astgen_failure | 構文エラー | ユーザーによる修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 次回コンパイル時に自動リトライ |
| リトライ間隔 | なし（次回更新時） |
| リトライ対象エラー | retryable_failure |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル処理中は常時発生可能）

## セキュリティ考慮事項

- エラーメッセージにファイルパスやソースコード断片が含まれるが、これはユーザーの作業環境情報であり、外部送信されない
- エラー出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- AstGenエラーが発生した場合、`skip_analysis_this_update`フラグがtrueになり、意味解析がスキップされる
- failed_filesマップはファイルパスでソートされて出力される（一貫したエラー順序のため）
- alive_filesに含まれないファイルのエラーは出力されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

failed_filesマップとFile.Status enumの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | 207-214行目: failed_filesマップの定義 |
| 1-2 | Zcu.zig | `src/Zcu.zig` | 915-927行目: File.Status enumの定義 |

**読解のコツ**:
- failed_filesのキーはFile.Index、値は?[]u8
- 値が非nullの場合はリトライ可能エラー（メッセージ）
- 値がnullの場合は非リトライエラー（ZIR/ZOIRにエラー情報）

#### Step 2: エントリーポイントを理解する

エラー収集処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 4027-4077行目: failed_files処理 |

**主要処理フロー**:
1. **4042-4045行目**: failed_filesのソート（ファイルパス順）
2. **4047行目**: failed_files.keys()とfailed_files.values()のループ
3. **4048行目**: alive_filesに含まれないファイルはスキップ
4. **4050-4054行目**: ファイルステータスに基づく判定
5. **4055-4076行目**: エラーメッセージの追加

#### Step 3: ファイルステータス

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Zcu.zig | `src/Zcu.zig` | 915-927行目: File.Status enum |
| 3-2 | Zcu.zig | `src/Zcu.zig` | 279-282行目: skip_analysis_this_updateフラグ |

**主要処理フロー**:
- **retryable_failure**: ファイルシステムエラー、次回リトライ
- **astgen_failure**: パースまたはAstGen失敗、ZIR/ZOIRなし
- **success**: 成功だがZIR/ZOIRエラーあり

### プログラム呼び出し階層図

```
Zcu/PerThread.zig: AstGen処理
    │
    ├─ ファイル読み込み失敗
    │      └─ failed_files[file] = error_msg
    │              └─ status = .retryable_failure
    │
    └─ パース/AstGen失敗
           └─ failed_files[file] = null
                   └─ status = .astgen_failure

        │
        ▼

Compilation.getAllErrorsAlloc()
    │
    └─ for (failed_files) |file, error_msg|
           │
           ├─ error_msg != null (リトライ可能)
           │      └─ addWholeFileError(...)
           │
           └─ error_msg == null (非リトライ)
                  └─ bundle.addZirErrorMessages(...)
                         または
                     bundle.addZoirErrorMessages(...)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Zigソースファイル ───▶ AstGen ───▶ failed_files
                           │
                           ├─ retryable_failure
                           │      └─ エラーメッセージ文字列
                           │
                           └─ astgen_failure
                                  └─ ZIR/ZOIRエラー情報

                         │
                         ▼

             Compilation.getAllErrorsAlloc()
                         │
                         ▼

                 ErrorBundle（stderr出力）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zcu.zig | `src/Zcu.zig` | ソース | failed_filesマップ、File.Status定義 |
| Zcu/PerThread.zig | `src/Zcu/PerThread.zig` | ソース | AstGen処理、failed_files更新 |
| Compilation.zig | `src/Compilation.zig` | ソース | getAllErrorsAlloc、failed_files処理 |
