# 通知設計書 11-ImportError

## 概要

本ドキュメントは、Zigコンパイラにおける「ImportError」通知の設計仕様を定義する。ImportErrorは、ソースファイルのインポート処理時に発生するエラーを通知するためのエラーバンドルである。

### 本通知の処理概要

ImportErrorは、Zigソースコードにおける`@import`文の解析・処理時に検出された不正なインポートをエラーバンドルとして記録・通知する機能である。

**業務上の目的・背景**：Zigコンパイラは複数のモジュールから構成されるプロジェクトをコンパイルする際、各ファイル間の依存関係を`@import`文によって解決する。しかし、モジュールのルートディレクトリ外へのアクセスや、コンパイラが特別に扱うディレクトリ（`global_cache/b/`等）へのアクセスは、セキュリティやビルドの再現性の観点から禁止されている。このエラーは、開発者に対してインポートパスの誤りや設計上の問題を早期に通知し、適切なモジュール構成への修正を促すために必要である。

**通知の送信タイミング**：AstGen（AST生成）フェーズ完了後、意味解析（Sema）フェーズの前に実行されるインポート検証処理において発生する。具体的には、`Zcu.failed_imports`にエラー情報が追加されるタイミングで記録される。

**通知の受信者**：コンパイラを実行している開発者がエラーメッセージの受信者となる。エラーはエラーバンドルとして集約され、コンパイル完了時または中断時に標準エラー出力へ表示される。

**通知内容の概要**：エラー発生元のファイルインデックス、インポート文字列（`@import`の引数）、インポートトークンの位置、およびエラーの種類（`file_outside_module_root`または`illegal_zig_import`）が含まれる。

**期待されるアクション**：開発者は、エラーメッセージに含まれるソース位置情報を元に該当の`@import`文を確認し、正しいモジュールパスに修正するか、プロジェクトのモジュール構成を見直す必要がある。

## 通知種別

エラーバンドル / コンパイルエラーメッセージ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コンパイルパイプライン内） |
| 優先度 | 高（致命的エラー） |
| リトライ | なし |

### 送信先決定ロジック

エラーは`Zcu.failed_imports`配列に格納され、コンパイル終了時に`getAllErrorsAlloc`関数によって収集される。エラーバンドルとしてフォーマットされた後、標準エラー出力または`--listen`オプションで指定されたクライアントに送信される。

## 通知テンプレート

### エラーメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | エラーバンドル形式 |

### 本文テンプレート

```
{ファイルパス}:{行番号}:{列番号}: error: import of {インポートパス} from outside module root {モジュールルート}
```

または

```
{ファイルパス}:{行番号}:{列番号}: error: illegal import of {インポートパス} (compiler-reserved directory)
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_index | ソースファイルのインデックス | Zcu.File.Index | Yes |
| import_string | インポート文字列 | Zir.NullTerminatedString | Yes |
| import_token | インポートトークン位置 | Ast.TokenIndex | Yes |
| kind | エラー種別 | enum { file_outside_module_root, illegal_zig_import } | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンパイル処理 | インポート検証 | モジュールルート外へのインポート | `file_outside_module_root`エラーが発生 |
| コンパイル処理 | インポート検証 | コンパイラ予約ディレクトリへのインポート | `illegal_zig_import`エラーが発生 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| インポートが正常な場合 | エラーは発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[@import文の検出] --> B[パス解決処理]
    B --> C{パス検証}
    C -->|モジュールルート外| D[file_outside_module_root]
    C -->|予約ディレクトリ| E[illegal_zig_import]
    C -->|正常| F[インポート成功]
    D --> G[failed_importsに追加]
    E --> G
    G --> H[skip_analysis_this_update = true]
    H --> I[エラーバンドル生成]
    I --> J[stderr出力]
    F --> K[処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Zcu.import_table | インポート済みファイルの管理 | ファイルパスをキーとしたハッシュマップ |
| Zcu.alive_files | 生存ファイルの追跡 | インクリメンタルコンパイル用 |

### テーブル別参照項目詳細

#### Zcu.failed_imports

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| file_index | エラー発生ファイルの特定 | エラー追加時 |
| import_string | インポートパスの表示 | エラー追加時 |
| import_token | ソース位置の特定 | エラー追加時 |
| kind | エラー種別の判定 | エラー追加時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Zcu.failed_imports | INSERT | エラー情報の追加 |
| Zcu.skip_analysis_this_update | UPDATE | 解析スキップフラグの設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| file_outside_module_root | モジュールルートの親ディレクトリへのアクセス | モジュール構成の見直し |
| illegal_zig_import | global_cache/b/等へのアクセス | インポートパスの修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（致命的エラー） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- インポートパスの検証はモジュール境界の保護に寄与する
- 予約ディレクトリへのアクセス禁止はビルドの再現性を保証する
- ファイルパス情報は開発環境の情報を含む可能性があるため、CI/CDログの公開時は注意が必要

## 備考

- ImportErrorは毎回のコンパイル更新時にクリア・再計算される
- このエラーが発生すると意味解析（Sema）フェーズがスキップされる
- エラーメッセージには参照トレース情報が含まれる場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ImportErrorは`Zcu.failed_imports`に格納される構造体として定義されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | 236-241行目: `failed_imports`フィールドの定義を確認。構造体の各フィールド（file_index, import_string, import_token, kind）を理解する |

**読解のコツ**: `kind`フィールドは`enum { file_outside_module_root, illegal_zig_import }`として定義されており、2種類のインポートエラーを区別する。

#### Step 2: エントリーポイントを理解する

インポート検証のトリガーはAstGen完了後に発生する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | インポート検証処理の呼び出し箇所を確認 |
| 2-2 | Zcu.zig | `src/Zcu.zig` | 215-240行目: インポートエラーの管理ロジック |

**主要処理フロー**:
1. **236行目**: `failed_imports`配列の定義
2. **240行目**: エラー種別(`kind`)の列挙型定義

#### Step 3: パス検証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | 700-710行目: `isIllegalZigImport`関数でコンパイラ予約ディレクトリへのアクセスを検証 |

**主要処理フロー**:
- **703行目**: `global_cache/b`ディレクトリへのパスを構築
- **706行目**: `isNested`メソッドでパスの包含関係を検証

### プログラム呼び出し階層図

```
Compilation.update
    │
    ├─ Zcu.PerThread.updateFile (AstGen)
    │      └─ ファイルごとのZIR生成
    │
    └─ インポート検証処理
           ├─ Path.isIllegalZigImport
           │      └─ isNested (パス包含チェック)
           │
           └─ failed_imports.append (エラー記録)
```

### データフロー図

```
[入力]                      [処理]                         [出力]

@import文字列 ───────▶ パス解決 ───────▶ Zcu.import_table
                          │
                          ▼
                     パス検証
                          │
                    ┌─────┴─────┐
                    ▼           ▼
               正常パス    不正パス
                    │           │
                    ▼           ▼
               処理継続    failed_imports ───▶ エラーバンドル ───▶ stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zcu.zig | `src/Zcu.zig` | ソース | Zig Compilation Unitの中核、failed_importsを管理 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイルパイプラインの制御、パス検証ロジック |
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | スレッドごとのファイル更新処理 |
| Zir.zig | `lib/std/zig/Zir.zig` | ソース | ZIR命令の定義、NullTerminatedString型 |
