# 通知設計書 12-AnalysisError

## 概要

本ドキュメントは、Zigコンパイラにおける「AnalysisError」通知の設計仕様を定義する。AnalysisErrorは、意味解析（Semantic Analysis）フェーズで発生するエラーをエラーバンドルとして記録・通知する機能である。

### 本通知の処理概要

AnalysisErrorは、Zigソースコードの意味解析中に検出された型エラー、未定義参照、不正な操作などのセマンティックエラーを記録し、開発者に通知するためのエラーバンドルである。

**業務上の目的・背景**：コンパイラの意味解析フェーズでは、構文的に正しいコードが論理的にも正しいかを検証する。型の不一致、未定義のシンボル参照、コンパイル時評価の失敗など、プログラムの意味的な問題を早期に検出し開発者にフィードバックすることで、ランタイムエラーを未然に防ぎ、コード品質の向上に寄与する。

**通知の送信タイミング**：Sema（意味解析）フェーズの実行中、各AnalUnitの解析時にエラーが検出された時点で`failed_analysis`マップに記録される。インクリメンタルコンパイルでは、更新されたAnalUnitの再解析時にもエラーが発生する可能性がある。

**通知の受信者**：コンパイラを実行している開発者がエラーメッセージの受信者となる。エラーはエラーバンドルとして集約され、コンパイル完了時または中断時に標準エラー出力へ表示される。

**通知内容の概要**：エラーが発生したAnalUnit、エラーメッセージ（ErrorMsg）、ソース位置情報、および参照トレース情報が含まれる。依存関係による推移的な解析失敗も追跡される。

**期待されるアクション**：開発者は、エラーメッセージとソース位置情報を元に該当のコードを確認し、型エラーの修正、未定義参照の解決、または不正な操作の修正を行う必要がある。

## 通知種別

エラーバンドル / コンパイルエラーメッセージ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コンパイルパイプライン内） |
| 優先度 | 高（致命的エラー） |
| リトライ | あり（retryable_failures経由で次回updateで再試行可能） |

### 送信先決定ロジック

エラーは`Zcu.failed_analysis`マップに格納される。AnalUnitをキーとし、ErrorMsgへのポインタを値として保持する。コンパイル終了時に`getAllErrorsAlloc`関数によって収集され、エラーバンドルとしてフォーマットされた後、標準エラー出力または`--listen`オプションで指定されたクライアントに送信される。

## 通知テンプレート

### エラーメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | エラーバンドル形式 |

### 本文テンプレート

```
{ファイルパス}:{行番号}:{列番号}: error: {エラーメッセージ}
{ソースコード行}
{エラー位置マーカー}
{参照トレース（該当する場合）}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| anal_unit | 解析ユニット | InternPool.AnalUnit | Yes |
| error_msg | エラーメッセージ | *ErrorMsg | Yes |
| src_loc | ソース位置 | LazySrcLoc | Yes |
| msg | メッセージ文字列 | []const u8 | Yes |
| notes | 補足情報 | []ErrorMsg | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 意味解析処理 | 型チェック失敗 | 型の不一致検出 | 型エラーが発生 |
| 意味解析処理 | シンボル解決失敗 | 未定義参照検出 | 参照エラーが発生 |
| 意味解析処理 | コンパイル時評価失敗 | comptime評価エラー | 実行時エラーがcomptime中に発生 |
| 意味解析処理 | 依存関係解析失敗 | 推移的失敗 | 依存先のAnalUnitが失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 解析が正常な場合 | エラーは発生しない |
| 推移的失敗の場合 | 元のエラーのみ報告（二重報告を防止） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[AnalUnit解析開始] --> B[Sema処理]
    B --> C{解析結果}
    C -->|成功| D[解析完了]
    C -->|失敗| E{失敗種別}
    E -->|直接失敗| F[failed_analysisに追加]
    E -->|推移的失敗| G[transitive_failed_analysisに追加]
    E -->|リトライ可能| H[retryable_failuresに追加]
    F --> I[ErrorMsg生成]
    G --> J[元エラーを参照]
    H --> K[次回updateで再試行]
    I --> L[エラーバンドル生成]
    J --> L
    L --> M[stderr出力]
    D --> N[処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Zcu.analysis_in_progress | 解析中のAnalUnitを追跡 | 循環参照検出用 |
| InternPool | 型・値情報の格納 | シンボル解決に使用 |

### テーブル別参照項目詳細

#### Zcu.failed_analysis

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| AnalUnit (key) | 失敗したユニットの特定 | エラー追加時 |
| *ErrorMsg (value) | エラー詳細の取得 | エラー表示時 |

#### Zcu.transitive_failed_analysis

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| AnalUnit (key) | 推移的失敗ユニット | 依存先エラー時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Zcu.failed_analysis | INSERT | 直接のエラー情報追加 |
| Zcu.transitive_failed_analysis | INSERT | 推移的エラー情報追加 |
| Zcu.retryable_failures | INSERT | リトライ可能エラー追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 型エラー | 型の不一致 | 型アノテーションの修正 |
| 未定義参照 | シンボルが見つからない | シンボルの定義または import |
| comptime失敗 | コンパイル時評価エラー | comptimeコードの修正 |
| 推移的失敗 | 依存先がエラー | 依存先のエラーを先に修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 1回（次回update時） |
| リトライ間隔 | 次回Compilation.update呼び出し時 |
| リトライ対象エラー | ディスク容量不足等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにはソースコードの一部が含まれる
- 参照トレースには内部の型情報が含まれる可能性がある
- ビルドログの公開時はセンシティブな情報の有無を確認すること

## 備考

- AnalysisErrorは`failed_analysis`マップで管理され、ErrorMsgのメモリはAnalUnitが所有する
- 参照トレースは`reference_trace`設定により出力量を制御可能
- インクリメンタルコンパイルでは、outdatedになったAnalUnitのエラーは自動的にクリアされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AnalysisErrorは`Zcu.failed_analysis`マップと関連データ構造で管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | 178-182行目: `analysis_in_progress`, `failed_analysis`, `transitive_failed_analysis`の定義 |
| 1-2 | Zcu.zig | `src/Zcu.zig` | 261-265行目: `retryable_failures`の定義と役割 |

**読解のコツ**: `failed_analysis`はAnalUnitをキーとし、ErrorMsgポインタを値として持つAutoArrayHashMap。`transitive_failed_analysis`は依存関係による間接的な失敗を追跡する。

#### Step 2: エントリーポイントを理解する

意味解析のトリガーはCompilation.updateから呼び出される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 968-999行目: Job union定義、`analyze_comptime_unit`と`analyze_func`ジョブ |
| 2-2 | Sema.zig | `src/Sema.zig` | 意味解析の実装本体 |

**主要処理フロー**:
1. **968行目**: Job unionの定義開始
2. **997行目**: `analyze_comptime_unit`ジョブの定義

#### Step 3: エラー記録ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Zcu.zig | `src/Zcu.zig` | 250-256行目: `potentially_outdated`, `outdated`, `outdated_ready`マップ |

**主要処理フロー**:
- **180行目**: `failed_analysis`マップの定義
- **182行目**: `transitive_failed_analysis`マップの定義

### プログラム呼び出し階層図

```
Compilation.update
    │
    ├─ Job.analyze_comptime_unit
    │      └─ Sema.analyzeComptimeUnit
    │             ├─ 型チェック
    │             ├─ シンボル解決
    │             └─ エラー時 → failed_analysis.put
    │
    ├─ Job.analyze_func
    │      └─ Sema.analyzeFnBody
    │             └─ エラー時 → failed_analysis.put
    │
    └─ 依存関係エラー伝播
           └─ transitive_failed_analysis.put
```

### データフロー図

```
[入力]                      [処理]                         [出力]

AnalUnit ───────────▶ Sema解析 ───────────▶ 解析結果
                          │
                    ┌─────┴─────┐
                    ▼           ▼
                 成功      失敗（ErrorMsg生成）
                    │           │
                    ▼           ▼
            処理継続    failed_analysis ───▶ エラーバンドル ───▶ stderr
                              │
                              ▼
                    transitive_failed_analysis（依存先エラー時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zcu.zig | `src/Zcu.zig` | ソース | failed_analysis, transitive_failed_analysisの管理 |
| Sema.zig | `src/Sema.zig` | ソース | 意味解析の実装、エラー生成 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイルパイプライン、Jobスケジューリング |
| InternPool.zig | `src/InternPool.zig` | ソース | AnalUnit型の定義 |
