# 通知設計書 14-FileNotFound

## 概要

本ドキュメントは、Zigコンパイラにおける「FileNotFound」通知の設計仕様を定義する。FileNotFoundは、必要なファイルが見つからない場合に発生する致命的エラーである。

### 本通知の処理概要

FileNotFoundは、コンパイル処理に必要なファイル（リンカースクリプト、オブジェクトファイル、ソースファイルなど）が指定されたパスに存在しない場合に発生する致命的エラーである。

**業務上の目的・背景**：コンパイラはビルドプロセス中に様々なファイルにアクセスする必要がある。入力ソースファイル、ライブラリファイル、リンカースクリプトなど、これらのファイルが存在しない場合、コンパイルを続行することは不可能である。早期にファイル未検出を通知することで、開発者はビルド設定やファイルパスの問題を迅速に特定・修正できる。

**通知の送信タイミング**：ファイルアクセスを試みた時点でエラーが検出される。これはコンパイル初期化時、リンク処理時、または入力ファイルの読み込み時に発生しうる。

**通知の受信者**：コンパイラを実行している開発者、CI/CDシステム、またはビルドスクリプトがエラーメッセージの受信者となる。

**通知内容の概要**：見つからなかったファイルのパス、検索を試みたディレクトリ情報、およびファイルが必要とされたコンテキスト（リンク入力、インポートなど）が含まれる。

**期待されるアクション**：開発者は、指定されたファイルパスが正しいか確認し、ファイルが存在することを確認するか、ビルド設定を修正する必要がある。

## 通知種別

致命的エラー / ファイルシステムエラー

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（エラー発生時即時） |
| 優先度 | 高（致命的エラー） |
| リトライ | なし |

### 送信先決定ロジック

エラーは`link.Diags`または`std.process.fatal`を通じて報告される。リンク処理中のエラーは`link.Diags.fail`または`link.Diags.addError`で記録され、初期化処理中のエラーは`fatal`で即座にプロセスを終了させる。

## 通知テンプレート

### エラーメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | テキストメッセージ / エラーバンドル |

### 本文テンプレート

```
error: file not found: {ファイルパス}
```

または詳細なコンテキスト付き：

```
error: unable to find '{ファイル名}': FileNotFound
note: tried {検索パス1}
note: tried {検索パス2}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_path | 見つからなかったファイルのパス | リンク入力 / インポート文 | Yes |
| search_paths | 検索を試みたパスのリスト | Compilation設定 | No |
| context | エラー発生コンテキスト | 処理フェーズ | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| リンク処理 | リンカースクリプト読み込み | ファイル未検出 | リンカースクリプトが見つからない |
| リンク処理 | オブジェクトファイル読み込み | ファイル未検出 | 入力オブジェクトが見つからない |
| コンパイル処理 | ソースファイル読み込み | ファイル未検出 | Zigソースが見つからない |
| インポート処理 | @import解決 | ファイル未検出 | インポート先が見つからない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイルが存在する場合 | エラーは発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイルアクセス試行] --> B{ファイル存在確認}
    B -->|存在| C[ファイル読み込み]
    B -->|未検出| D[FileNotFoundエラー]
    D --> E{処理フェーズ}
    E -->|初期化| F[fatal呼び出し]
    E -->|リンク| G[link.Diags.fail]
    E -->|AstGen| H[failed_files追加]
    F --> I[プロセス終了]
    G --> J[エラーバンドル生成]
    H --> J
    J --> K[stderr出力]
    C --> L[処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| link.Input | リンク入力ファイルの管理 | ファイルパス情報を含む |
| Zcu.import_table | インポートファイルの管理 | @import解決用 |

### テーブル別参照項目詳細

#### link.Input

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| path | ファイルパス | リンク処理時 |
| kind | 入力種別 | ファイル種別判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| link.Diags.msgs | INSERT | リンクエラー追加 |
| Zcu.failed_files | INSERT | ファイルエラー追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リンカースクリプト未検出 | 指定パスにファイルなし | パス確認・ファイル配置 |
| オブジェクトファイル未検出 | 指定パスにファイルなし | 事前ビルド確認 |
| ソースファイル未検出 | 指定パスにファイルなし | ファイルパス確認 |
| ライブラリ未検出 | 検索パスにライブラリなし | -L オプション確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ファイルパスにはシステムの構造情報が含まれる
- 検索パスリストには設定情報が含まれる
- エラーメッセージの公開時はパス情報に注意

## 備考

- FileNotFoundはZig標準ライブラリのerror.FileNotFoundと同じエラー値を使用
- ファイルシステムの状態（パーミッション等）によっては別のエラーが発生する場合がある
- シンボリックリンクの解決失敗もこのエラーとして報告される場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FileNotFoundはZig標準のエラー値として定義されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | posix.zig | `lib/std/posix.zig` | OpenErrorセットにFileNotFoundが含まれる |
| 1-2 | link.zig | `src/link.zig` | Diags構造体のエラー管理 |

**読解のコツ**: `error.FileNotFound`はファイルシステム操作全般で発生しうる標準エラー。

#### Step 2: エントリーポイントを理解する

ファイルアクセスが発生する主な箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | link.zig | `src/link.zig` | 389-411行目: File.open関数でのファイル操作 |
| 2-2 | PerThread.zig | `src/Zcu/PerThread.zig` | 95-99行目: source_file.openでのファイル読み込み |

**主要処理フロー**:
1. **95行目**: source_fileを開く処理
2. **97行目**: dir.openFile呼び出し

#### Step 3: エラーハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | link.zig | `src/link.zig` | 213-217行目: Diags.fail関数でエラー報告 |

**主要処理フロー**:
- **213行目**: `fail`関数の定義
- **216行目**: `error.LinkFailure`の返却

### プログラム呼び出し階層図

```
Compilation.update
    │
    ├─ ファイル読み込み処理
    │      ├─ Io.Dir.openFile
    │      │      └─ error.FileNotFound発生可能
    │      └─ エラー時
    │             ├─ fatal（初期化時）
    │             └─ link.Diags.fail（リンク時）
    │
    └─ Zcu.PerThread.updateFile
           ├─ source_file = dir.openFile
           │      └─ error.FileNotFound発生可能
           └─ エラー時
                  └─ failed_files追加
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ファイルパス ───────▶ openFile ───────▶ ファイルハンドル
                          │
                    ┌─────┴─────┐
                    ▼           ▼
                 成功     error.FileNotFound
                    │           │
                    ▼           ▼
            処理継続    Diags.fail / fatal ───▶ stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| link.zig | `src/link.zig` | ソース | リンク処理、Diags管理 |
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | ソースファイル読み込み |
| posix.zig | `lib/std/posix.zig` | ソース | ファイルシステムエラー定義 |
| Io.zig | `lib/std/Io.zig` | ソース | I/O抽象化層 |
