# 通知設計書 15-UnrecognizedExtension

## 概要

本ドキュメントは、Zigコンパイラにおける「UnrecognizedExtension」通知の設計仕様を定義する。UnrecognizedExtensionは、未対応のファイル拡張子が指定された場合に発生する致命的エラーである。

### 本通知の処理概要

UnrecognizedExtensionは、コンパイラがリンク入力として指定されたファイルの拡張子を認識できない場合に発生する致命的エラーである。

**業務上の目的・背景**：Zigコンパイラは様々な入力ファイル形式をサポートしている（.zig、.o、.a、.so、.c、.cppなど）。しかし、サポートされていない拡張子のファイルが指定された場合、コンパイラはそのファイルをどのように処理すべきか判断できない。このエラーにより、開発者は入力ファイルの形式が正しいか、または適切なオプション（-x等）でファイル種別を明示的に指定する必要があることを認識できる。

**通知の送信タイミング**：リンク入力ファイルの処理時、ファイル拡張子の解析フェーズで発生する。`link.Input`の構築時またはファイル種別判定時に検出される。

**通知の受信者**：コンパイラを実行している開発者、CI/CDシステム、またはビルドスクリプトがエラーメッセージの受信者となる。

**通知内容の概要**：認識できなかった拡張子、対象ファイルのパス、およびサポートされている拡張子のリストが含まれる場合がある。

**期待されるアクション**：開発者は、ファイルの拡張子が正しいか確認し、必要に応じて`-x language`オプションでファイルの種別を明示的に指定するか、ファイル形式を変換する必要がある。

## 通知種別

致命的エラー / 入力ファイルエラー

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（エラー発生時即時） |
| 優先度 | 高（致命的エラー） |
| リトライ | なし |

### 送信先決定ロジック

エラーは`link.Diags.fail`または`std.process.fatal`を通じて報告される。main.zigでの引数解析時またはlink.zig内でのファイル処理時に検出される。

## 通知テンプレート

### エラーメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | テキストメッセージ / エラーバンドル |

### 本文テンプレート

```
error: unrecognized file extension: '{拡張子}'
```

または詳細なコンテキスト付き：

```
error: unrecognized file type '{ファイルパス}'
note: supported extensions are: .zig, .o, .a, .so, .c, .cpp, ...
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| extension | 認識できなかった拡張子 | ファイルパス解析 | Yes |
| file_path | 対象ファイルのパス | リンク入力 | Yes |
| supported_extensions | サポート拡張子リスト | コンパイラ設定 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 引数解析 | ファイル引数処理 | 拡張子未認識 | コマンドライン引数のファイル |
| リンク処理 | リンク入力判定 | 拡張子未認識 | リンク入力ファイルの種別判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| -x オプション指定時 | ファイル種別が明示的に指定される |
| 既知の拡張子 | エラーは発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイル入力受付] --> B[拡張子抽出]
    B --> C{拡張子判定}
    C -->|既知| D[ファイル種別設定]
    C -->|未知| E{-x指定あり?}
    E -->|あり| F[明示的種別使用]
    E -->|なし| G[UnrecognizedExtension]
    G --> H[エラー報告]
    H --> I[処理終了]
    D --> J[処理継続]
    F --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Compilation.LangToExt | 言語-拡張子マッピング | サポート拡張子の定義 |
| FileExt enum | ファイル拡張子列挙 | 拡張子種別の定義 |

### テーブル別参照項目詳細

#### Compilation.LangToExt

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| key (言語名) | -x オプション用 | 言語指定時 |
| value (FileExt) | 拡張子種別 | マッピング参照時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| link.Diags.msgs | INSERT | エラー追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不明な拡張子 | .xyz等の未サポート拡張子 | ファイル形式変換または-x指定 |
| 拡張子なし | ファイル名に拡張子がない | -x オプションで種別指定 |
| 大文字小文字違い | .C vs .c | 正しい拡張子に変更 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ファイルパスにはシステム構造情報が含まれる
- 拡張子情報はセキュリティ上の問題は低い

## 備考

- サポートされる拡張子はCompilation.LangToExtで定義
- 一部の拡張子は大文字小文字を区別する（.C と .c は異なる）
- LLVM拡張機能が必要な拡張子もある（.bc等）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

拡張子とファイル種別のマッピングを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 933-946行目: LangToExtマッピングとFileExt定義 |

**読解のコツ**: `LangToExt`は`-x lang`オプション用のマッピング、`FileExt`はファイル拡張子の列挙型。

#### Step 2: エントリーポイントを理解する

ファイル拡張子の判定処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | 396-425行目: 入力ファイル種別の説明 |
| 2-2 | link.zig | `src/link.zig` | Input構造体でのファイル種別管理 |

**主要処理フロー**:
1. **396-425行目**: サポートされるファイルタイプのヘルプ表示
2. 拡張子による入力ファイル判定

#### Step 3: エラー発生箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | link.zig | `src/link.zig` | Input種別判定でのエラー処理 |

**主要処理フロー**:
- 拡張子からFileExtへの変換失敗時にエラー

### プログラム呼び出し階層図

```
main
    │
    ├─ 引数解析
    │      ├─ ファイル引数処理
    │      │      └─ 拡張子判定
    │      │             └─ 未知の場合 → fatal
    │      └─ -x オプション
    │             └─ LangToExt参照
    │
    └─ Compilation.create
           └─ link.Input構築
                  └─ 拡張子検証
                         └─ 未知の場合 → Diags.fail
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ファイルパス ───────▶ 拡張子抽出 ───────▶ FileExt判定
                          │
                    ┌─────┴─────┐
                    ▼           ▼
               既知拡張子  未知拡張子
                    │           │
                    ▼           ▼
            処理継続    UnrecognizedExtension ───▶ stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | LangToExt定義、FileExt列挙 |
| main.zig | `src/main.zig` | ソース | 引数解析、ファイル種別判定 |
| link.zig | `src/link.zig` | ソース | Input構造体、リンク処理 |
