# 通知設計書 17-memory_allocation_failure

## 概要

本ドキュメントは、Zigコンパイラにおける「memory_allocation_failure」通知の設計仕様を定義する。memory_allocation_failureは、メモリ割り当てに失敗した場合の通知である。

### 本通知の処理概要

memory_allocation_failureは、コンパイル処理中にメモリ割り当て（allocator.alloc等）が失敗した場合に発生する通知である。`comp.alloc_failure_occurred`フラグおよび`link.Diags.flags.alloc_failure_occurred`フラグによって管理される。

**業務上の目的・背景**：大規模なプロジェクトのコンパイルや、制限されたメモリ環境でのビルドでは、メモリ不足が発生する可能性がある。コンパイラは可能な限り処理を継続しようとするが、メモリ不足が発生した場合は、その事実を記録し、最終的にユーザーに報告する必要がある。これにより、ユーザーはビルド環境のメモリを増やすか、ビルド設定を調整することができる。

**通知の送信タイミング**：コンパイル処理中の任意の時点でメモリ割り当てが失敗した場合に発生する。フラグはコンパイル中に設定され、コンパイル完了時にエラーとして報告される。

**通知の受信者**：コンパイラを実行している開発者、CI/CDシステム、またはビルドスクリプトがエラーメッセージの受信者となる。

**通知内容の概要**：メモリ割り当て失敗が発生したことを示すフラグベースの通知。詳細な割り当てサイズやコンテキストは含まれない場合がある。

**期待されるアクション**：開発者は、ビルド環境のメモリを増やす、並列ジョブ数を減らす（-jオプション）、または不要なプロセスを終了してメモリを解放する必要がある。

## 通知種別

コンパイル通知 / リソースエラー

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コンパイル終了時にまとめて報告） |
| 優先度 | 高 |
| リトライ | なし（ただし次回ビルドで解消する可能性あり） |

### 送信先決定ロジック

`Compilation.alloc_failure_occurred`フラグまたは`link.Diags.flags.alloc_failure_occurred`フラグがtrueの場合、コンパイル終了時にエラーとして報告される。

## 通知テンプレート

### エラーメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | テキストメッセージ / エラーバンドル |

### 本文テンプレート

```
error: memory allocation failure
```

または詳細なコンテキスト付き：

```
error: out of memory
note: consider reducing parallel jobs with -j flag
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| alloc_failure_occurred | 割り当て失敗フラグ | Compilation / link.Diags | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| メモリ操作 | alloc失敗 | OutOfMemory発生 | allocatorからの割り当て失敗 |
| メモリ操作 | realloc失敗 | OutOfMemory発生 | 再割り当て失敗 |
| リンク処理 | リンクメモリ不足 | OutOfMemory発生 | リンカー処理中の割り当て失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| メモリ十分 | エラーは発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メモリ割り当て試行] --> B{成功?}
    B -->|成功| C[処理継続]
    B -->|OutOfMemory| D[フラグ設定]
    D --> E{処理継続可能?}
    E -->|可能| F[代替処理/スキップ]
    E -->|不可| G[即時エラー]
    F --> H[コンパイル終了]
    G --> H
    H --> I{フラグ確認}
    I -->|設定あり| J[エラー報告]
    I -->|設定なし| K[正常終了]
    J --> L[stderr出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Compilation | コンパイル状態管理 | alloc_failure_occurredフラグ |
| link.Diags.Flags | リンクエラーフラグ | alloc_failure_occurredフラグ |

### テーブル別参照項目詳細

#### Compilation

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| alloc_failure_occurred | 割り当て失敗記録 | エラー確認時 |

#### link.Diags.Flags

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| alloc_failure_occurred | リンク時割り当て失敗 | エラー確認時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Compilation.alloc_failure_occurred | UPDATE | フラグ設定 |
| link.Diags.flags.alloc_failure_occurred | UPDATE | フラグ設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| システムメモリ不足 | 物理メモリ枯渇 | メモリ増設またはプロセス終了 |
| 仮想メモリ不足 | アドレス空間枯渇 | 64ビットビルド使用 |
| 並列ジョブ過多 | スレッド数過多 | -jオプションで削減 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（同一ビルド内） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 次回ビルドで解消可能 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- メモリ割り当て失敗はシステムリソース情報を間接的に露出する可能性がある
- DoS攻撃のベクターとなる可能性を考慮

## 備考

- フラグベースの管理により、複数のメモリ割り当て失敗を1つのエラーとして報告
- コンパイラは可能な限り処理を継続しようとする（graceful degradation）
- link.Diags.setAllocFailure関数でログ出力とフラグ設定が行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メモリ割り当て失敗フラグの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 191行目: `alloc_failure_occurred: bool = false`の定義 |
| 1-2 | link.zig | `src/link.zig` | 48-61行目: Diags.Flags構造体、alloc_failure_occurredフィールド |

**読解のコツ**: 両方のフラグは独立して管理され、コンパイル本体とリンク処理でそれぞれ使用される。

#### Step 2: フラグ設定処理を理解する

メモリ割り当て失敗時のフラグ設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | link.zig | `src/link.zig` | 358-369行目: setAllocFailure関数 |

**主要処理フロー**:
1. **367行目**: log.debugでメモリ割り当て失敗をログ出力
2. **368行目**: alloc_failure_occurredフラグをtrueに設定

#### Step 3: エラー確認処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | link.zig | `src/link.zig` | 48-60行目: Flags.anySet関数でフラグ確認 |

**主要処理フロー**:
- **58-60行目**: Flags構造体のビットをIntにキャストしてチェック

### プログラム呼び出し階層図

```
Compilation.update
    │
    ├─ 各種処理
    │      └─ allocator.alloc
    │             └─ OutOfMemory
    │                    └─ alloc_failure_occurred = true
    │
    └─ link.File.flush
           └─ 各種リンク処理
                  └─ allocator.alloc
                         └─ OutOfMemory
                                └─ Diags.setAllocFailure
                                       ├─ log.debug
                                       └─ flags.alloc_failure_occurred = true
```

### データフロー図

```
[入力]                      [処理]                         [出力]

メモリ要求 ───────▶ allocator.alloc ───────▶ メモリ領域
                          │
                    ┌─────┴─────┐
                    ▼           ▼
                 成功    error.OutOfMemory
                    │           │
                    ▼           ▼
            処理継続    フラグ設定
                              │
                              ▼
                    コンパイル終了時
                              │
                              ▼
                    フラグ確認 ───▶ エラー報告
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | alloc_failure_occurredフラグ管理 |
| link.zig | `src/link.zig` | ソース | Diags.Flags、setAllocFailure関数 |
