# 通知設計書 18-CacheHit

## 概要

本ドキュメントは、Zigコンパイラにおける「CacheHit」通知の設計仕様を定義する。CacheHitは、以前のコンパイル結果がキャッシュから再利用された場合の通知である。

### 本通知の処理概要

CacheHitは、コンパイル処理においてキャッシュが有効であり、以前のコンパイル結果を再利用できた場合にデバッグログとして出力される通知である。

**業務上の目的・背景**：Zigコンパイラはインクリメンタルコンパイルとキャッシュ機構を備えており、変更されていないソースファイルやZIRの再コンパイルをスキップできる。CacheHit通知は、このキャッシュ機構が正常に動作していることを開発者やデバッグ担当者に示すために使用される。ビルドパフォーマンスの分析やキャッシュ効率の検証に役立つ。

**通知の送信タイミング**：AstGen（AST生成）フェーズでZIRキャッシュが有効な場合、またはCacheMode.wholeモードでコンパイル結果全体がキャッシュから利用可能な場合に発生する。

**通知の受信者**：デバッグログを有効にしている開発者。通常のコンパイルではlog.debugは出力されないため、`--debug-log`オプションまたは適切なログ設定が必要。

**通知内容の概要**：キャッシュヒットしたファイルパス、キャッシュの種類（ZIR/ZOIR/全体）、キャッシュダイジェスト情報が含まれる。

**期待されるアクション**：通常は情報提供のみで、特別なアクションは不要。キャッシュ効率の分析やデバッグに使用する。

## 通知種別

コンパイル通知 / デバッグログ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 低（デバッグ情報） |
| リトライ | 該当なし |

### 送信先決定ロジック

`log.debug`関数を通じて出力される。ログスコープは`.zcu`（Zig Compilation Unit）。`--debug-log=zcu`または`-Dlog`オプションで有効化される。

## 通知テンプレート

### ログメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | デバッグログ |

### 本文テンプレート

ZIRキャッシュヒット:
```
debug(zcu): AstGen cached success: {ファイルパス}
```

キャッシュチェック:
```
debug(zcu): AstGen checking cache: {ファイルパス} (local={ローカル}, digest={ダイジェスト})
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_path | キャッシュヒットしたファイルパス | Zcu.File.path | Yes |
| local | ローカルキャッシュ使用フラグ | want_local_cache | Yes |
| digest | キャッシュダイジェスト | Cache.HexDigest | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| AstGen処理 | ZIRキャッシュ確認 | キャッシュ有効 | ZIRキャッシュヒット |
| AstGen処理 | ZOIRキャッシュ確認 | キャッシュ有効 | ZONファイルのキャッシュヒット |
| コンパイル処理 | 全体キャッシュ確認 | CacheMode.whole | 全体キャッシュヒット |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デバッグログ無効 | log.debugは出力されない |
| キャッシュミス | CacheHitは発生しない |
| --time-report有効 | キャッシュヒットでも処理継続 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイル処理開始] --> B[キャッシュファイル確認]
    B --> C{キャッシュ存在?}
    C -->|なし| D[CacheMiss]
    C -->|あり| E[メタデータ比較]
    E --> F{メタデータ一致?}
    F -->|不一致| G[stale判定]
    F -->|一致| H[キャッシュ読み込み]
    H --> I{読み込み成功?}
    I -->|失敗| J[再生成]
    I -->|成功| K[CacheHit]
    K --> L[log.debug出力]
    L --> M[キャッシュデータ使用]
    D --> J
    G --> J
    J --> N[新規ZIR/ZOIR生成]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Zcu.local_zir_cache | ローカルZIRキャッシュ | プロジェクトローカル |
| Zcu.global_zir_cache | グローバルZIRキャッシュ | Zigライブラリ用 |

### テーブル別参照項目詳細

#### Zcu.File

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| path | ファイルパス | ログ出力用 |
| stat | ファイル統計情報 | メタデータ比較用 |
| zir | キャッシュZIR | キャッシュ読み込み時 |

### 更新テーブル一覧

なし（CacheHitは読み取り専用操作）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | CacheHitは正常パス | なし |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ファイルパスがログに含まれる
- キャッシュダイジェストはハッシュ値であり、セキュリティ上の問題は低い

## 備考

- CacheHitは`last_update_was_cache_hit`フラグでも追跡される
- `--time-report`オプション使用時は、キャッシュヒットでも処理を継続する
- ローカルキャッシュとグローバルキャッシュは別々に管理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

キャッシュ関連のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 192行目: `last_update_was_cache_hit: bool = false`の定義 |
| 1-2 | Zcu.zig | `src/Zcu.zig` | 84-87行目: `global_zir_cache`, `local_zir_cache`の定義 |

**読解のコツ**: キャッシュはディレクトリハンドルとして管理され、ファイルパスのハッシュをファイル名として使用。

#### Step 2: キャッシュチェック処理を理解する

キャッシュヒット判定のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PerThread.zig | `src/Zcu/PerThread.zig` | 120-145行目: ファイルステータスに基づくキャッシュ判定 |
| 2-2 | PerThread.zig | `src/Zcu/PerThread.zig` | 228-230行目: AstGen cached successログ |

**主要処理フロー**:
1. **124-126行目**: キャッシュチェックのログ出力
2. **228-230行目**: キャッシュ成功時のログ出力

#### Step 3: キャッシュ読み込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PerThread.zig | `src/Zcu/PerThread.zig` | 348-402行目: loadZirZoirCache関数 |

**主要処理フロー**:
- **354行目**: キャッシュからヘッダー読み込み
- **379-386行目**: メタデータ比較でstale判定

### プログラム呼び出し階層図

```
Compilation.update
    │
    └─ AstGen処理
           │
           └─ Zcu.PerThread.updateFile
                  │
                  ├─ キャッシュファイルオープン
                  │      └─ log.debug("AstGen checking cache: ...")
                  │
                  └─ loadZirZoirCache
                         │
                         ├─ ヘッダー読み込み
                         ├─ メタデータ比較
                         └─ 成功時
                                └─ log.debug("AstGen cached success: ...")
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ソースファイル ───────▶ メタデータ取得 ───────▶ stat情報
                              │
                              ▼
キャッシュファイル ───▶ ヘッダー読み込み ───▶ キャッシュstat
                              │
                              ▼
                        メタデータ比較
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
               一致(CacheHit)      不一致(stale)
                    │                   │
                    ▼                   ▼
            log.debug出力         再生成処理
                    │
                    ▼
            ZIR/ZOIR使用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | updateFile、キャッシュ判定 |
| Zcu.zig | `src/Zcu.zig` | ソース | キャッシュディレクトリ管理 |
| Compilation.zig | `src/Compilation.zig` | ソース | last_update_was_cache_hit |
| Cache.zig | `lib/std/Build/Cache.zig` | ソース | キャッシュ基盤 |
