# 通知設計書 19-CacheMiss

## 概要

本ドキュメントは、Zigコンパイラにおける「CacheMiss」通知の設計仕様を定義する。CacheMissは、キャッシュが見つからず再コンパイルが必要な場合の通知である。

### 本通知の処理概要

CacheMissは、コンパイル処理においてキャッシュが無効または存在せず、ソースファイルからZIR/ZOIRを再生成する必要がある場合にデバッグログとして出力される通知である。

**業務上の目的・背景**：キャッシュミスが発生する状況を把握することで、ビルドパフォーマンスの問題を診断できる。キャッシュミスの原因（ファイル変更、メタデータ不一致、キャッシュ破損等）を特定することで、ビルド環境の最適化やキャッシュ戦略の改善に役立てることができる。

**通知の送信タイミング**：AstGen（AST生成）フェーズでZIRキャッシュが無効または存在しない場合に発生する。具体的には、メタデータ不一致（stale）、キャッシュファイル破損（truncated）、または初回コンパイル（never_loaded）の場合に出力される。

**通知の受信者**：デバッグログを有効にしている開発者。通常のコンパイルではlog.debugは出力されないため、`--debug-log`オプションまたは適切なログ設定が必要。

**通知内容の概要**：キャッシュミスしたファイルパス、ミスの理由（stale、truncated等）が含まれる。

**期待されるアクション**：通常は情報提供のみで、特別なアクションは不要。頻繁なキャッシュミスが発生する場合は、ビルド設定やファイルシステムの問題を調査する。

## 通知種別

コンパイル通知 / デバッグログ

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 低（デバッグ情報） |
| リトライ | 該当なし |

### 送信先決定ロジック

`log.debug`または`log.warn`関数を通じて出力される。ログスコープは`.zcu`（Zig Compilation Unit）。深刻な問題（truncated等）は`log.warn`で出力される場合がある。

## 通知テンプレート

### ログメッセージの場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 標準エラー出力（stderr） |
| 形式 | デバッグログ / 警告ログ |

### 本文テンプレート

キャッシュstale（陳腐化）:
```
debug(zcu): AstGen cache stale: {ファイルパス}
```

キャッシュtruncated（破損）:
```
warn(zcu): unexpected EOF reading cached ZIR for {ファイルパス}
```

メタデータ変更:
```
debug(zcu): metadata changed: {ファイルパス}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_path | キャッシュミスしたファイルパス | Zcu.File.path | Yes |
| reason | ミスの理由 | loadZirZoirCache結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| AstGen処理 | キャッシュなし | never_loaded | 初回コンパイル |
| AstGen処理 | メタデータ変更 | ファイル変更検出 | ソースファイル更新 |
| AstGen処理 | キャッシュ陳腐化 | stale判定 | メタデータ不一致 |
| AstGen処理 | キャッシュ破損 | truncated判定 | ファイル途中終端 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デバッグログ無効 | log.debugは出力されない |
| キャッシュヒット | CacheMissは発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ファイル処理開始] --> B{ファイルステータス}
    B -->|never_loaded| C[キャッシュ確認]
    B -->|success/astgen_failure| D[メタデータ比較]
    C --> E{キャッシュ読み込み}
    D --> F{変更あり?}
    F -->|なし| G[CacheHit]
    F -->|あり| H[metadata changed ログ]
    E -->|成功| G
    E -->|stale| I[stale ログ]
    E -->|truncated| J[truncated 警告]
    E -->|invalid| K[再生成]
    H --> K
    I --> K
    J --> K
    K --> L[AstGen/ZonGen実行]
    L --> M[fresh successログ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Zcu.File.stat | ファイル統計情報 | メタデータ比較用 |
| Zir.Header / Zoir.Header | キャッシュヘッダー | メタデータ格納 |

### テーブル別参照項目詳細

#### Zcu.File

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| status | ファイル状態 | never_loaded/success等 |
| stat.size | ファイルサイズ | メタデータ比較 |
| stat.mtime | 更新時刻 | メタデータ比較 |
| stat.inode | inode番号 | メタデータ比較 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Zcu.File.zir | UPDATE | 再生成ZIR格納 |
| Zcu.File.zoir | UPDATE | 再生成ZOIR格納 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| stale | メタデータ不一致 | 自動再生成 |
| truncated | キャッシュファイル破損 | 自動再生成、警告出力 |
| invalid | 不正なキャッシュ形式 | 自動再生成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（自動再生成） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ファイルパスがログに含まれる
- キャッシュファイルの状態情報が露出する

## 備考

- CacheMissは自動的に再生成処理に移行するため、通常は問題にならない
- truncatedはファイルシステムの問題を示唆する可能性がある
- 頻繁なstaleはビルドシステムやファイル監視の問題を示唆する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

キャッシュミス関連のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PerThread.zig | `src/Zcu/PerThread.zig` | 354行目: loadZirZoirCacheの戻り値enum |

**読解のコツ**: 戻り値は`success`, `invalid`, `truncated`, `stale`の4種類。

#### Step 2: キャッシュミス判定を理解する

キャッシュミスの各ケースを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PerThread.zig | `src/Zcu/PerThread.zig` | 131-144行目: メタデータ比較とmetadata changedログ |
| 2-2 | PerThread.zig | `src/Zcu/PerThread.zig` | 233-234行目: staleログ出力 |
| 2-3 | PerThread.zig | `src/Zcu/PerThread.zig` | 233行目: truncated警告出力 |

**主要処理フロー**:
1. **131-139行目**: unchanged_metadata判定
2. **141行目**: metadata changedログ
3. **233行目**: staleログ

#### Step 3: 再生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PerThread.zig | `src/Zcu/PerThread.zig` | 246-304行目: 再生成処理（AstGen/ZonGen呼び出し） |

**主要処理フロー**:
- **265行目**: Ast.parse呼び出し
- **275行目**: AstGen.generate呼び出し
- **304行目**: fresh successログ

### プログラム呼び出し階層図

```
Compilation.update
    │
    └─ AstGen処理
           │
           └─ Zcu.PerThread.updateFile
                  │
                  ├─ loadZirZoirCache
                  │      ├─ success → CacheHit
                  │      ├─ invalid → 再生成
                  │      ├─ truncated → log.warn + 再生成
                  │      └─ stale → log.debug + 再生成
                  │
                  └─ 再生成処理
                         ├─ Ast.parse
                         ├─ AstGen.generate / ZonGen.generate
                         └─ log.debug("AstGen fresh success")
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ソースファイル ───────▶ メタデータ取得 ───────▶ 現在のstat
                              │
                              ▼
キャッシュファイル ───▶ ヘッダー読み込み ───▶ キャッシュstat
                              │
                              ▼
                        メタデータ比較
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
               一致(hit)           不一致(miss)
                                        │
                              ┌─────────┼─────────┐
                              ▼         ▼         ▼
                           stale   truncated  invalid
                              │         │         │
                              ▼         ▼         ▼
                        log.debug  log.warn  (silent)
                              │         │         │
                              └────┬────┴─────────┘
                                   ▼
                            AstGen/ZonGen
                                   │
                                   ▼
                            fresh successログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | updateFile、キャッシュ判定、再生成 |
| Zcu.zig | `src/Zcu.zig` | ソース | File.stat定義 |
| AstGen.zig | `lib/std/zig/AstGen.zig` | ソース | ZIR生成 |
| ZonGen.zig | `lib/std/zig/ZonGen.zig` | ソース | ZOIR生成 |
