# 通知設計書 2-warning

## 概要

本ドキュメントは、Zigコンパイラにおけるwarningログ通知の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのコンパイル処理中に発生した警告状態をログとして出力する機能である。問題が発生したかどうか不確かだが、調査する価値がある状況で使用される。

**業務上の目的・背景**：コンパイル処理中に潜在的な問題や非最適な状況が検出された場合、ユーザーに注意を促すために必要である。警告はエラーとは異なり処理を継続するが、将来的な問題を防ぐための情報を提供する。

**通知の送信タイミング**：コンパイル処理中に警告状態が検出された時点で即座にログ出力される。具体的には、一時ディレクトリの削除失敗、キャッシュマニフェストの書き込み失敗、クライアント切断、ページサイズの非整列などの非致命的な問題発生時にトリガーされる。

**通知の受信者**：コンパイラを実行しているユーザー、またはコンパイラの出力を監視しているシステム。ログは標準エラー出力（stderr）に出力される。

**通知内容の概要**：警告の種別、警告メッセージ、関連するファイルパス、発生箇所などの情報が含まれる。ログはANSIカラーコードにより黄色で表示され、視覚的に警告であることを示す。

**期待されるアクション**：ユーザーは警告メッセージを確認し、必要に応じてソースコードの修正、設定の見直し、または環境の改善を検討する。警告は処理を中断しないため、即座の対応は必須ではないが、将来的な問題を防ぐために確認が推奨される。

## 通知種別

ログ通知（標準エラー出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

ログ出力は固定で標準エラー出力（stderr）に送信される。`std.log.scoped(.xxx).warn`または`log.warn`関数を通じて出力される。

## 通知テンプレート

### ログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr |
| 色 | 黄色（ANSI escape code使用） |
| 形式 | テキスト |

### 本文テンプレート

```
warning: {メッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | ログ通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 警告メッセージ | 各処理からの引数 | Yes |
| file_path | 関連ファイルパス | 処理対象ファイル | No |
| error_name | エラー名 | @errorName(err) | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | 一時ディレクトリ削除失敗 | 削除エラー時 | 一時ファイルのクリーンアップ失敗 |
| 内部処理 | キャッシュマニフェスト書き込み失敗 | 書き込みエラー時 | コンパイル結果のキャッシュ保存失敗 |
| 内部処理 | クライアント切断 | 切断検出時 | IncrementalDebugServerでのクライアント切断 |
| 内部処理 | ページサイズ非整列 | 設定不整合時 | MachOリンカーでのページサイズ警告 |
| 内部処理 | ZIRキャッシュ読み込み失敗 | EOF検出時 | キャッシュ破損の可能性 |
| 内部処理 | ptraceエラー | 操作失敗時 | デバッグ操作の失敗 |
| 内部処理 | ファイル削除失敗 | 削除エラー時 | 一時ファイルの削除失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 警告発生時は常に出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[警告状態発生] --> B[log.warn呼び出し]
    B --> C[フォーマット文字列展開]
    C --> D[ANSIカラーコード付与]
    D --> E[stderr出力]
    E --> F[処理継続]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ログ通知のためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ログ通知のためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 出力失敗 | stderrへの書き込み失敗 | 処理継続（警告のため） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル処理中は常時出力可能）

## セキュリティ考慮事項

- 警告メッセージにファイルパスが含まれる場合があるが、これはユーザーの作業環境情報であり、外部送信されない
- ログ出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- ログスコープ（.compilation, .link等）によって出力元を識別可能
- ANSIカラーコードにより黄色で表示されるため、ターミナル上で視認性が高い
- 警告はエラーとは異なり、処理を中断しない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Zigのログシステムは標準ライブラリの`std.log`モジュールを使用している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std/log.zig | Zig標準ライブラリ | ログレベルの定義とscopedログの仕組み |

**読解のコツ**: `std.log.scoped`はコンパイル時にログスコープを生成する関数である。warnレベルはerrより低く、infoより高い優先度を持つ。

#### Step 2: エントリーポイントを理解する

各モジュールでのlog変数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 11行目: `log = std.log.scoped(.compilation)` |
| 2-2 | link.zig | `src/link.zig` | 9行目: `log = std.log.scoped(.link)` |
| 2-3 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | log変数定義 |

**主要処理フロー**:
1. **11行目 (Compilation.zig)**: `const log = std.log.scoped(.compilation);` - compilationスコープのログオブジェクト作成
2. **2873行目 (Compilation.zig)**: `log.warn("failed to delete temporary directory...")` - 一時ディレクトリ削除失敗

#### Step 3: 警告ログ呼び出し箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | 2873, 2894, 3263, 5848, 5931, 6406, 6410, 6553, 6693, 6801行目 |
| 3-2 | link.zig | `src/link.zig` | 632, 637, 701, 717行目 |
| 3-3 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 59行目 |
| 3-4 | Zcu/PerThread.zig | `src/Zcu/PerThread.zig` | 233, 278, 286行目 |
| 3-5 | link/MachO.zig | `src/link/MachO.zig` | 2119, 2120行目 |

**主要処理フロー**:
- **2873行目**: 一時ディレクトリ削除失敗時の警告出力
- **3263行目**: キャッシュマニフェスト書き込み失敗時の警告出力
- **632行目 (link.zig)**: ptrace失敗時の警告出力

### プログラム呼び出し階層図

```
std.log.scoped(.compilation)
    │
    ├─ log.warn(format, args)
    │      └─ std.log.log (内部ログ処理)
    │              └─ stderr.write
    │
    └─ 各処理での警告検出
           ├─ ファイル削除失敗
           ├─ キャッシュ書き込み失敗
           ├─ クライアント切断
           └─ 設定非整列
```

### データフロー図

```
[入力]               [処理]                    [出力]

警告状態発生 ───▶ log.warn(format, args) ───▶ stderr（黄色表示）
    │                    │
    │                    └─ 処理継続
    │
    └─ format: フォーマット文字列
    └─ args: 可変長引数（警告情報）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理のメイン、log.warn多数使用 |
| link.zig | `src/link.zig` | ソース | リンカー処理、linkスコープのログ使用 |
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバー処理 |
| Zcu/PerThread.zig | `src/Zcu/PerThread.zig` | ソース | ZCUスレッド処理 |
| link/MachO.zig | `src/link/MachO.zig` | ソース | MachOリンカー処理 |
| link/Elf/ZigObject.zig | `src/link/Elf/ZigObject.zig` | ソース | ELFオブジェクト処理 |
| Sema.zig | `src/Sema.zig` | ソース | 意味解析処理 |
| Builtin.zig | `src/Builtin.zig` | ソース | ビルトイン処理 |
| libs/openbsd.zig | `src/libs/openbsd.zig` | ソース | OpenBSDライブラリ処理 |
