# 通知設計書 20-JobQueued

## 概要

本ドキュメントは、Zigコンパイラにおける「JobQueued」通知の設計仕様を定義する。JobQueuedは、コンパイルジョブがキューに追加された時の通知である。

### 本通知の処理概要

JobQueuedは、コンパイルパイプラインにおいて各種ビルドジョブ（compiler_rt_lib、ubsan_rt_lib、libfuzzerなど）がワークキューに追加された際の内部状態を示す通知である。

**業務上の目的・背景**：Zigコンパイラは並列処理をサポートしており、複数のコンパイルタスクを効率的にスケジューリングする必要がある。ランタイムライブラリのビルド、AstGen、Sema、コード生成などの処理がジョブとしてキューイングされる。JobQueued通知は、このジョブスケジューリングシステムの状態を追跡し、デバッグやパフォーマンス分析に役立てるために使用される。

**通知の送信タイミング**：`Compilation.update`の実行中、各種ジョブがワークキューに追加されるタイミングで発生する。`queued_jobs`フラグが設定されるか、`work_queues`にジョブが追加される際に記録される。

**通知の受信者**：コンパイラ内部のジョブスケジューラー。デバッグ目的では、開発者がジョブの進行状況を追跡するために使用する。

**通知内容の概要**：キューイングされたジョブの種類（compiler_rt_lib、ubsan_rt_lib、fuzzer_lib等）、およびジョブの詳細情報が含まれる。

**期待されるアクション**：通常は内部処理であり、ユーザーアクションは不要。ビルドパフォーマンスの問題がある場合は、ジョブキューの状態を分析する。

## 通知種別

コンパイル通知 / 内部ジョブ管理

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（フラグ設定/キュー追加） |
| 優先度 | 内部（ユーザー向け出力なし） |
| リトライ | 該当なし |

### 送信先決定ロジック

ジョブは`Compilation.queued_jobs`フラグまたは`Compilation.work_queues`配列に追加される。フラグ型のジョブ（ランタイムライブラリ等）は`QueuedJobs`構造体のboolフィールドで管理される。

## 通知テンプレート

### 内部データ構造の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | 内部データ構造（queued_jobs / work_queues） |
| 形式 | フラグ設定 / キュー追加 |

### データ構造

```zig
const QueuedJobs = struct {
    compiler_rt_dyn_lib: bool = false,
    compiler_rt_lib: bool = false,
    compiler_rt_obj: bool = false,
    ubsan_rt_lib: bool = false,
    ubsan_rt_obj: bool = false,
    fuzzer_lib: bool = false,
    // ... その他CRTファイル、共有オブジェクト等
};
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| job_type | ジョブの種類 | Job.Tag | Yes |
| job_data | ジョブ固有データ | Job union | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ランタイムビルド | compiler_rt必要 | ランタイムライブラリ要求 | compiler_rt_lib/obj |
| ランタイムビルド | ubsan_rt必要 | サニタイザー有効 | ubsan_rt_lib/obj |
| ランタイムビルド | fuzzer必要 | ファジング有効 | fuzzer_lib |
| CRTビルド | libcリンク | libc使用 | musl/glibc CRTファイル |
| 解析処理 | AnalUnit解析 | 更新必要 | analyze_comptime_unit/func |
| コード生成 | codegen必要 | 解析完了 | codegen_func |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にキュー済み | 重複追加しない |
| 不要なジョブ | 設定により不要な場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Compilation.update開始] --> B[必要ジョブ判定]
    B --> C{compiler_rt必要?}
    C -->|Yes| D[queued_jobs.compiler_rt_lib = true]
    C -->|No| E{ubsan必要?}
    E -->|Yes| F[queued_jobs.ubsan_rt_lib = true]
    E -->|No| G{その他ジョブ?}
    G -->|Yes| H[該当フラグ設定]
    G -->|No| I[ジョブ処理開始]
    D --> E
    F --> G
    H --> I
    I --> J[work_queuesから取り出し]
    J --> K{ジョブあり?}
    K -->|Yes| L[ジョブ実行]
    K -->|No| M[完了]
    L --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Compilation.config | ビルド設定 | ランタイム要否判定 |
| Compilation.link_inputs | リンク入力 | ライブラリ要否判定 |

### テーブル別参照項目詳細

#### Compilation.queued_jobs

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| compiler_rt_lib | compiler_rtビルド要否 | ジョブチェック時 |
| ubsan_rt_lib | UBSanビルド要否 | ジョブチェック時 |
| fuzzer_lib | Fuzzerビルド要否 | ジョブチェック時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Compilation.queued_jobs | UPDATE | フラグ設定 |
| Compilation.work_queues | INSERT | ジョブ追加 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| OutOfMemory | キュー容量不足 | エラー伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 内部データ構造のため、セキュリティ上の懸念は低い
- ジョブ情報からビルド構成が推測可能

## 備考

- QueuedJobsはboolフラグの集合として効率的に管理
- work_queuesは複数ステージに分かれたDeque配列
- Job.Tagによりジョブのステージ（優先度）が決定される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ジョブキュー関連のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 300-328行目: QueuedJobs構造体の定義 |
| 1-2 | Compilation.zig | `src/Compilation.zig` | 127-135行目: work_queues配列の定義 |
| 1-3 | Compilation.zig | `src/Compilation.zig` | 968-999行目: Job union定義 |

**読解のコツ**: `QueuedJobs`は主にランタイムライブラリ用、`work_queues`は解析/コード生成ジョブ用。

#### Step 2: ジョブ追加処理を理解する

ジョブがキューに追加される処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | queued_jobs各フラグの設定箇所 |

**主要処理フロー**:
1. **300-328行目**: QueuedJobsの各フラグ定義
2. ビルド設定に基づくフラグ設定

#### Step 3: ジョブ実行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | work_queuesからのジョブ取り出しと実行 |

**主要処理フロー**:
- `work_queues[stage].popFront()`でジョブ取り出し
- Job.Tag.stageでステージ決定

### プログラム呼び出し階層図

```
Compilation.create
    │
    └─ 初期ジョブ設定
           ├─ queued_jobs.compiler_rt_lib = true
           ├─ queued_jobs.ubsan_rt_lib = true
           └─ queued_jobs.fuzzer_lib = true

Compilation.update
    │
    ├─ oneshot_prelink_tasks処理
    │      └─ work_queues追加
    │
    ├─ ジョブ処理ループ
    │      ├─ work_queues[0].popFront()
    │      ├─ work_queues[1].popFront()
    │      └─ ...
    │
    └─ ランタイムビルドジョブ
           ├─ queued_jobs.compiler_rt_lib確認
           ├─ queued_jobs.ubsan_rt_lib確認
           └─ queued_jobs.fuzzer_lib確認
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ビルド設定 ───────▶ ジョブ判定 ───────▶ queued_jobs設定
                          │
                          ▼
ソースファイル ───▶ 解析要求 ───────▶ work_queues追加
                          │
                          ▼
                    ジョブ実行ループ
                          │
                    ┌─────┼─────┐
                    ▼     ▼     ▼
            ランタイム  解析  codegen
                    │     │     │
                    └──┬──┴──┬──┘
                       ▼     ▼
                   成果物生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | QueuedJobs、work_queues、Job定義 |
| Zcu.zig | `src/Zcu.zig` | ソース | 解析ジョブのキューイング |
| link.zig | `src/link.zig` | ソース | リンクジョブ管理 |
