# 通知設計書 21-ClientConnected

## 概要

本ドキュメントは、Zigコンパイラにおけるインクリメンタルデバッグサーバーへのクライアント接続通知「ClientConnected」の設計を記述する。

### 本通知の処理概要

本通知は、インクリメンタルコンパイルのデバッグ機能において、外部クライアント（telnet等）がデバッグサーバーに接続した際に発生するログ通知である。

**業務上の目的・背景**：Zigコンパイラのインクリメンタルコンパイル機能をデバッグする際、開発者がREPL形式でコンパイラの内部状態を調査できるTCPサーバーが提供されている。このサーバーへのクライアント接続を追跡することで、デバッグセッションの開始を把握し、複数クライアントの同時接続状況を監視できる。これは主にZigコンパイラ開発者向けの機能であり、インクリメンタルコンパイルの問題を診断する際に使用される。

**通知の送信タイミング**：サーバーがクライアントからの接続要求を受け入れ（accept）、ストリーム接続が確立された直後に送信される。具体的には、`IncrementalDebugServer.runServer`関数内の`server.accept()`が成功した時点で`log.info`を通じて出力される。

**通知の受信者**：この通知はログシステムを介して出力されるため、受信者はログの設定に依存する。通常は標準エラー出力（stderr）に出力され、コンパイラを実行している開発者が確認できる。`--debug-incremental`フラグを使用してコンパイラを起動した開発者が主な受信者となる。

**通知内容の概要**：接続したクライアントのアドレス情報が含まれる。形式は`"client '{address}' connected"`となり、IPv6ループバックアドレスとポート番号が表示される。

**期待されるアクション**：開発者は通知を受け取ることで、デバッグセッションが開始されたことを確認できる。その後、telnet経由でコマンドを送信し、コンパイラの内部状態（型情報、NAV情報、依存関係等）を調査できる。

## 通知種別

ログ通知（info レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 中（info レベル） |
| リトライ | なし |

### 送信先決定ロジック

ログスコープ `.incremental_debug_server` に対して `log.info` で出力される。ログの出力先はZig標準ライブラリのログシステム設定に依存し、通常はstderrに出力される。

## 通知テンプレート

### ログメッセージ

| 項目 | 内容 |
|-----|------|
| ログレベル | info |
| スコープ | incremental_debug_server |
| 表示色 | 緑色（info レベル） |

### 本文テンプレート

```
client '{address}' connected
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| address | 接続クライアントのIPアドレス | stream.socket.address | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ネットワークイベント | server.accept() 成功 | `--debug-incremental` フラグ有効時 | クライアントがTCPポート7623に接続成功した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `--debug-incremental` フラグ未指定 | インクリメンタルデバッグサーバーが起動しないため、通知は発生しない |
| シングルスレッドビルド | `builtin.single_threaded` が true の場合、ファイル自体がコンパイルされない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンパイラ起動] --> B{--debug-incremental?}
    B -->|No| C[通常コンパイル]
    B -->|Yes| D[IncrementalDebugServer.spawn]
    D --> E[runServer開始]
    E --> F[addr.listen実行]
    F --> G[server.accept待機]
    G --> H{accept成功?}
    H -->|ConnectionAborted| I[log.warn: disconnected during accept]
    H -->|その他エラー| J[log.err: accept failed]
    H -->|成功| K[log.info: client connected]
    K --> L[serveStream開始]
    L --> M[コマンド処理ループ]
    I --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（本通知はログ出力のみで、永続化されない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Canceled | サーバーがキャンセルされた場合 | サーバーを終了 |
| ConnectionAborted | 接続がaccept中に中断された場合 | log.warnを出力し、次の接続を待機 |
| その他エラー | accept処理で予期しないエラー | log.errを出力し、サーバーを終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（デバッグサーバー稼働中は常時受付）

## セキュリティ考慮事項

- デバッグサーバーはローカルホスト（IPv6 loopback `::1`）のみでリッスンするため、外部からの接続は受け付けない
- ポート番号は固定（7623）であり、設定変更は不可
- デバッグ機能はビルドオプション `enable_debug_extensions` が有効な場合のみ利用可能

## 備考

- このサーバーはインクリメンタルコンパイルの問題をデバッグするための開発者向け機能
- telnetクライアントで接続し、`help`コマンドで利用可能なコマンド一覧を確認できる
- サーバーが有効な場合、RSSメモリ使用量が通常より高くなる（`Zcu.IncrementalDebugState`による追加状態追跡のため）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

インクリメンタルデバッグサーバーの構造体と関連する状態を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 16-28行目: サーバー構造体の定義（zcu, future, mutex） |
| 1-2 | Zcu.zig | `src/Zcu.zig` | 314-368行目: IncrementalDebugState の定義 |

**読解のコツ**: Zigでは`@This()`で現在の構造体を参照する。`IncrementalDebugServer`はZcu（Zig Compilation Unit）への参照を保持し、mutex経由でスレッドセーフにアクセスする。

#### Step 2: エントリーポイントを理解する

サーバーの起動処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 36-41行目: spawn関数がサーバーを開始 |

**主要処理フロー**:
1. **36行目**: `spawn`関数の定義
2. **38行目**: ポート7623でデバッグサーバー起動のメッセージ出力
3. **39行目**: `io.concurrent`で`runServer`を非同期実行

#### Step 3: サーバーメインループを理解する

接続受付とログ出力の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 42-110行目: runServer関数全体 |

**主要処理フロー**:
- **45行目**: IPv6ループバックアドレス（ポート7623）の設定
- **46行目**: リッスン開始
- **49行目**: リッスン失敗時の`log.err`出力
- **56行目**: `server.accept`でクライアント接続を待機
- **59行目**: ConnectionAborted時の`log.warn`出力
- **63行目**: accept失敗時の`log.err`出力
- **68行目**: **接続成功時の`log.info`出力（本通知）**
- **100行目**: EndOfStream/ConnectionResetByPeer時の切断`log.info`出力

#### Step 4: ログスコープを理解する

ログ出力の設定を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 449行目: ログスコープの定義 |

**主要処理フロー**:
- **449行目**: `const log = std.log.scoped(.incremental_debug_server);`

### プログラム呼び出し階層図

```
Compilation.update()
    │
    ├─ IncrementalDebugServer.spawn() [36行目]
    │      │
    │      └─ io.concurrent(runServer, ...) [39行目]
    │              │
    │              └─ runServer() [42行目]
    │                      │
    │                      ├─ addr.listen() [46行目]
    │                      │
    │                      └─ [ループ開始]
    │                              │
    │                              ├─ server.accept() [56行目]
    │                              │      └─ log.info("client connected") [68行目] ← 本通知
    │                              │
    │                              └─ serveStream() [72行目]
    │                                      └─ handleCommand() [148行目]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

クライアント接続要求 ───▶ server.accept() ───▶ stream取得
        │                       │                    │
        │                       │                    ▼
        │                       │            stream.socket.address
        │                       │                    │
        │                       ▼                    ▼
        │              log.info("client '{f}' connected")
        │                       │
        └──────────────────────▶▼
                          stderr出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバーの実装（本通知の発生元） |
| Zcu.zig | `src/Zcu.zig` | ソース | Zig Compilation Unitの定義、IncrementalDebugStateを含む |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル全体の管理、debugIncremental()関数 |
| main.zig | `src/main.zig` | ソース | `--debug-incremental`フラグの処理 |
