# 通知設計書 22-ClientDisconnected

## 概要

本ドキュメントは、Zigコンパイラにおけるインクリメンタルデバッグサーバーからのクライアント切断通知「ClientDisconnected」の設計を記述する。

### 本通知の処理概要

本通知は、インクリメンタルコンパイルのデバッグサーバーに接続していたクライアントが切断した際に発生するログ通知である。正常な切断と接続受付中の切断の2種類のケースで異なるログレベルで出力される。

**業務上の目的・背景**：デバッグセッションの終了を追跡することで、開発者はサーバーの接続状況を把握できる。特に、複数のデバッグセッションを管理する際や、予期しない切断が発生した場合の診断に有用である。正常な切断（EndOfStream, ConnectionResetByPeer）とaccept中の切断（ConnectionAborted）を区別することで、問題の原因特定が容易になる。

**通知の送信タイミング**：クライアントとの接続が終了した時点で送信される。具体的には、(1) `serveStream`処理中にEndOfStreamまたはConnectionResetByPeerが発生した場合は`log.info`、(2) `server.accept()`中にConnectionAbortedが発生した場合は`log.warn`で出力される。

**通知の受信者**：ログシステムを介して出力されるため、コンパイラを`--debug-incremental`フラグで起動した開発者が主な受信者となる。通常はstderrに出力される。

**通知内容の概要**：切断したクライアントのアドレス情報（正常切断時）またはaccept中の切断メッセージが含まれる。形式は`"client '{address}' disconnected"`（正常切断）または`"client disconnected during accept"`（accept中切断）となる。

**期待されるアクション**：開発者は通知を受け取ることで、デバッグセッションが終了したことを確認できる。warnレベルの通知の場合は、クライアント側の接続問題を調査することが望ましい。

## 通知種別

ログ通知（info または warn レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 中（info/warn レベル） |
| リトライ | なし |

### 送信先決定ロジック

ログスコープ `.incremental_debug_server` に対して `log.info` または `log.warn` で出力される。正常切断は info、accept中の切断は warn となる。

## 通知テンプレート

### ログメッセージ

| 項目 | 内容 |
|-----|------|
| ログレベル | info（正常切断）/ warn（accept中切断） |
| スコープ | incremental_debug_server |
| 表示色 | 緑色（info）/ 黄色（warn） |

### 本文テンプレート

正常切断時:
```
client '{address}' disconnected
```

accept中切断時:
```
client disconnected during accept
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| address | 切断したクライアントのIPアドレス | stream.socket.address | Yes（正常切断時のみ） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ネットワークイベント | EndOfStream | serveStream実行中 | クライアントが正常に接続を閉じた場合 |
| ネットワークイベント | ConnectionResetByPeer | serveStream実行中 | クライアントが接続をリセットした場合 |
| ネットワークイベント | ConnectionAborted | server.accept()実行中 | 接続受付中にクライアントが切断した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `--debug-incremental` フラグ未指定 | インクリメンタルデバッグサーバーが起動しないため、通知は発生しない |
| Canceledエラー | サーバーキャンセル時は通知なしで終了 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クライアント接続中] --> B[serveStream実行]
    B --> C{エラー発生?}
    C -->|No| D[コマンド処理続行]
    D --> C
    C -->|EndOfStream| E[log.info: client disconnected]
    C -->|ConnectionResetByPeer| E
    C -->|Canceled| F[サーバー終了]
    C -->|その他エラー| G[log.err: failed to serve]
    E --> H[次の接続待機]
    G --> H

    I[server.accept実行中] --> J{エラー発生?}
    J -->|ConnectionAborted| K[log.warn: disconnected during accept]
    K --> I
    J -->|成功| L[serveStream開始]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（本通知はログ出力のみで、永続化されない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| EndOfStream | クライアントが正常に接続を閉じた | log.info出力、次の接続を待機 |
| ConnectionResetByPeer | クライアントが接続をリセット | log.info出力、次の接続を待機 |
| ConnectionAborted | accept中に接続が中断 | log.warn出力、accept続行 |
| Canceled | サーバーがキャンセルされた | サーバー終了（ログ出力なし） |
| その他のエラー | 予期しないネットワークエラー | log.err出力、エラー内容を記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- クライアントアドレス情報がログに出力される（ローカルホストのみなので外部情報は含まれない）
- デバッグ機能は開発ビルドのみで利用可能

## 備考

- 正常切断とaccept中切断で異なるログレベルを使用することで、問題の深刻度を区別
- warnレベルの出力が頻発する場合は、クライアント側のネットワーク設定や接続方法を確認することを推奨

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エラー処理の分岐を理解する

runServer関数内のエラーハンドリングを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 56-66行目: accept時のエラー処理 |
| 1-2 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 72-108行目: serveStream呼び出しとエラー処理 |

**読解のコツ**: Zigのエラー処理は`catch`と`switch`を組み合わせて行う。`|err|`でエラーを捕捉し、`switch`で個別のエラータイプに対応する。

#### Step 2: serveStream内のエラー分類を理解する

接続処理中のエラー分類を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 83-107行目: actual_errの分類とログ出力 |

**主要処理フロー**:
1. **83-107行目**: エラーの種類を`switch`で分類
2. **84行目**: Canceledはサーバー終了
3. **86-96行目**: その他のエラーは`log.err`で出力
4. **98-100行目**: EndOfStream, ConnectionResetByPeerは`log.info`で切断通知（本通知）

#### Step 3: accept中の切断を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 58-61行目: ConnectionAbortedの処理 |

**主要処理フロー**:
- **58行目**: `error.ConnectionAborted`をキャッチ
- **59行目**: `log.warn`で"client disconnected during accept"を出力
- **60行目**: `continue`で次のaccept待機に戻る

### プログラム呼び出し階層図

```
runServer() [42行目]
    │
    ├─ server.accept() [56行目]
    │      │
    │      ├─ [成功] → stream取得
    │      │
    │      └─ [ConnectionAborted] → log.warn("disconnected during accept") [59行目] ← 本通知
    │
    └─ serveStream() [72行目]
           │
           ├─ [正常終了] → 次の接続待機
           │
           └─ [エラー] → actual_errを判定
                  │
                  ├─ [Canceled] → return（サーバー終了）
                  │
                  ├─ [EndOfStream] → log.info("disconnected") [100行目] ← 本通知
                  │
                  ├─ [ConnectionResetByPeer] → log.info("disconnected") [100行目] ← 本通知
                  │
                  └─ [その他] → log.err("failed to serve") [96行目]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

クライアント切断     ───▶ エラー検出                ───▶ エラー種別判定
        │                       │                           │
        ▼                       ▼                           ▼
  [accept中]             ConnectionAborted           log.warn出力
        │                       │
        ▼                       ▼
  [serveStream中]        EndOfStream/                log.info出力
                         ConnectionResetByPeer              │
                                │                           ▼
                                └─────────────────────▶ stderr出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバーの実装（本通知の発生元） |
| Zcu.zig | `src/Zcu.zig` | ソース | Zig Compilation Unitの定義 |
| Io.zig | `lib/std/Io.zig` | 標準ライブラリ | ネットワークエラー型の定義 |
