# 通知設計書 23-AcceptFailed

## 概要

本ドキュメントは、Zigコンパイラにおけるインクリメンタルデバッグサーバーの接続受付失敗通知「AcceptFailed」の設計を記述する。

### 本通知の処理概要

本通知は、インクリメンタルデバッグサーバーが`server.accept()`の実行中に予期しないエラーが発生し、接続を受け付けられなかった場合に発生するエラーログ通知である。

**業務上の目的・背景**：デバッグサーバーの安定性を監視するため、接続受付の失敗を記録する必要がある。このエラーは、システムリソースの枯渇、ネットワークの問題、またはその他の予期しない状況を示す可能性があり、早期発見と対処が重要である。致命的なエラーの場合、サーバーは終了するため、開発者は再起動が必要であることを認識できる。

**通知の送信タイミング**：`server.accept()`呼び出しが失敗した時点で送信される。ただし、Canceledエラー（正常なサーバー停止）およびConnectionAbortedエラー（クライアント側の切断、warn扱い）は除く。

**通知の受信者**：ログシステムを介して出力されるため、コンパイラを`--debug-incremental`フラグで起動した開発者が主な受信者となる。通常はstderrに出力される。

**通知内容の概要**：失敗したエラーの種類を示すエラーコードが含まれる。形式は`"accept failed ({error})"`となる。

**期待されるアクション**：開発者はエラー内容を確認し、システムリソースやネットワーク設定を調査する。必要に応じてコンパイラを再起動し、デバッグサーバーを再開する。

## 通知種別

ログ通知（err レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 高（err レベル） |
| リトライ | なし |

### 送信先決定ロジック

ログスコープ `.incremental_debug_server` に対して `log.err` で出力される。

## 通知テンプレート

### ログメッセージ

| 項目 | 内容 |
|-----|------|
| ログレベル | err |
| スコープ | incremental_debug_server |
| 表示色 | 赤色（err レベル） |

### 本文テンプレート

```
accept failed ({error})
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| error | 発生したエラーの種類 | accept()の戻り値エラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ネットワークエラー | server.accept()失敗 | Canceled, ConnectionAborted以外のエラー | 接続受付時の予期しないエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Canceledエラー | サーバーの正常停止時は通知しない |
| ConnectionAbortedエラー | クライアント切断はwarnレベルで別途処理 |
| `--debug-incremental` フラグ未指定 | サーバー自体が起動しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[server.accept実行] --> B{結果?}
    B -->|成功| C[クライアント接続処理]
    B -->|Canceled| D[サーバー終了]
    B -->|ConnectionAborted| E[log.warn出力, continue]
    B -->|その他エラー| F[log.err: accept failed]
    F --> G[return - サーバー終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| OutOfMemory | システムメモリ不足 | log.err出力後、サーバー終了 |
| Unexpected | 予期しないシステムエラー | log.err出力後、サーバー終了 |
| SystemResources | システムリソース不足 | log.err出力後、サーバー終了 |
| NetworkDown | ネットワーク停止 | log.err出力後、サーバー終了 |
| その他 | 各種ネットワークエラー | log.err出力後、サーバー終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（サーバー終了） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラー情報がログに出力されるが、センシティブな情報は含まれない
- エラー発生時にサーバーが終了するため、潜在的なセキュリティリスクを軽減

## 備考

- このエラーが発生した場合、デバッグサーバーは終了するため、コンパイラの再起動が必要
- 頻発する場合は、システムリソースやネットワーク設定の問題を調査すべき

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: accept処理のエラーハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 56-66行目: accept時のエラー処理全体 |

**読解のコツ**: Zigの`catch`構文とswitch式を組み合わせたエラー処理パターンを理解する。

#### Step 2: エラー分類を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 62-65行目: その他エラーの処理 |

**主要処理フロー**:
- **62行目**: `else`句でCanceled, ConnectionAborted以外のエラーをキャッチ
- **63行目**: `log.err`で"accept failed ({t})"を出力（本通知）
- **64行目**: `return`でサーバー終了

### プログラム呼び出し階層図

```
runServer() [42行目]
    │
    └─ [ループ]
           │
           └─ server.accept() [56行目]
                  │
                  ├─ [成功] → serveStream()
                  │
                  ├─ [Canceled] → return
                  │
                  ├─ [ConnectionAborted] → log.warn, continue
                  │
                  └─ [その他エラー] → log.err("accept failed") [63行目] ← 本通知
                                           │
                                           └─ return（サーバー終了）
```

### データフロー図

```
[入力]                     [処理]                           [出力]

server.accept()エラー ───▶ エラー種別判定           ───▶ エラー分類
        │                       │                           │
        ▼                       ▼                           ▼
  Canceled以外            switch文で分岐            log.err出力
  ConnectionAborted以外         │                           │
                               ▼                           ▼
                         その他エラー              stderr出力 + サーバー終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバーの実装（本通知の発生元） |
