# 通知設計書 24-ListenFailed

## 概要

本ドキュメントは、Zigコンパイラにおけるインクリメンタルデバッグサーバーのリッスン失敗通知「ListenFailed」の設計を記述する。

### 本通知の処理概要

本通知は、インクリメンタルデバッグサーバーが指定ポート（7623）でリッスンを開始しようとした際に失敗した場合に発生するエラーログ通知である。サーバーの起動段階で発生するため、デバッグ機能が利用不可能になることを示す。

**業務上の目的・背景**：デバッグサーバーの起動失敗を明確に通知することで、開発者はすぐに問題を認識できる。よくある原因としては、ポートが既に使用されている、権限不足、ネットワーク設定の問題などがある。この通知により、開発者は代替手段を検討したり、原因を調査したりできる。

**通知の送信タイミング**：`addr.listen()`呼び出しが失敗した時点で送信される。これはサーバー起動の最初期段階で発生し、以降のクライアント接続処理は実行されない。

**通知の受信者**：ログシステムを介して出力されるため、コンパイラを`--debug-incremental`フラグで起動した開発者が主な受信者となる。通常はstderrに出力される。

**通知内容の概要**：リッスン失敗のエラー種類が含まれる。形式は`"listen failed ({error}); closing server"`となる。

**期待されるアクション**：開発者はエラー内容を確認し、ポートの競合解消やネットワーク設定の修正を行う。別のポートを使用することは現在サポートされていないため、競合するプロセスを終了する必要がある。

## 通知種別

ログ通知（err レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 高（err レベル） |
| リトライ | なし |

### 送信先決定ロジック

ログスコープ `.incremental_debug_server` に対して `log.err` で出力される。

## 通知テンプレート

### ログメッセージ

| 項目 | 内容 |
|-----|------|
| ログレベル | err |
| スコープ | incremental_debug_server |
| 表示色 | 赤色（err レベル） |

### 本文テンプレート

```
listen failed ({error}); closing server
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| error | 発生したエラーの種類 | listen()の戻り値エラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ネットワークエラー | addr.listen()失敗 | Canceled以外のエラー | ポート7623でのリッスン開始失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Canceledエラー | サーバーの正常キャンセル時は通知しない |
| `--debug-incremental` フラグ未指定 | サーバー自体が起動しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[IncrementalDebugServer.spawn] --> B[runServer開始]
    B --> C[addr.listen実行]
    C --> D{結果?}
    D -->|成功| E[serverオブジェクト取得]
    E --> F[accept待機開始]
    D -->|Canceled| G[return - 正常終了]
    D -->|その他エラー| H[log.err: listen failed]
    H --> I[return - サーバー終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| AddressInUse | ポート7623が既に使用中 | 競合プロセスを終了 |
| AccessDenied | ポートにバインドする権限がない | 権限を確認 |
| SystemResources | システムリソース不足 | リソースを解放 |
| NetworkDown | ネットワークが利用不可 | ネットワーク設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（サーバー終了） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（発生は1回のみ） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ポート番号（7623）はハードコードされており、変更不可
- ローカルホストのみでリッスンするため、外部からのアクセスリスクは低い

## 備考

- このエラーが発生した場合、デバッグ機能は利用できない
- ポート7623が他のプロセスで使用されている場合は、そのプロセスを終了する必要がある
- 現在の実装ではポート番号をカスタマイズする機能はない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: listen処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 45-52行目: アドレス設定とlisten処理 |

**読解のコツ**: IPv6アドレス`::1`（ループバック）でポート7623にリッスンする設定を確認する。

#### Step 2: エラーハンドリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 46-52行目: listen失敗時のエラー処理 |

**主要処理フロー**:
- **46行目**: `addr.listen(io, .{})`でリッスン開始を試行
- **47行目**: `error.Canceled`の場合は`return`で正常終了
- **48-51行目**: その他のエラーの場合は`log.err`で出力（本通知）後、`return`

### プログラム呼び出し階層図

```
spawn() [36行目]
    │
    └─ io.concurrent(runServer, ...) [39行目]
           │
           └─ runServer() [42行目]
                  │
                  ├─ addr = Io.net.IpAddress{...} [45行目]
                  │
                  └─ addr.listen() [46行目]
                         │
                         ├─ [成功] → server取得 → accept待機
                         │
                         ├─ [Canceled] → return
                         │
                         └─ [その他エラー] → log.err("listen failed") [49行目] ← 本通知
                                                  │
                                                  └─ return（サーバー終了）
```

### データフロー図

```
[入力]                     [処理]                           [出力]

IPv6 loopback:7623  ───▶ addr.listen()              ───▶ 結果判定
        │                       │                           │
        ▼                       ▼                           ▼
  ポートバインド試行       エラー発生              log.err出力
                               │                           │
                               ▼                           ▼
                         Canceled以外              stderr出力 + サーバー終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバーの実装（本通知の発生元） |
| Io.zig | `lib/std/Io.zig` | 標準ライブラリ | ネットワークI/O機能の定義 |
