# 通知設計書 27-PotentiallyOutdated

## 概要

本ドキュメントは、Zigコンパイラにおけるインクリメンタルコンパイルの「更新可能性」通知「PotentiallyOutdated」の設計を記述する。

### 本通知の処理概要

本通知は、依存先が更新された可能性があるため、依存元が「潜在的に古い」（Potentially Outdated: PO）状態としてマークされることを示す内部状態変更である。PO状態は、実際に古くなったかどうかはまだ確定していないが、検証が必要な状態を示す。

**業務上の目的・背景**：インクリメンタルコンパイルでは、依存関係が連鎖するため、一つの変更が多くのコンポーネントに影響を与える可能性がある。しかし、すべてを即座に「古い」とマークすると、不必要な再解析が発生する。PO状態を導入することで、「古いかもしれないが、まだ確認が必要」という中間状態を表現し、必要な場合のみ再解析を行うことができる。

**通知の送信タイミング**：`markTransitiveDependersPotentiallyOutdated`関数が呼び出された時点で発生する。これは、AnalUnitが`outdated`としてマークされた際に、その推移的な依存元をPOとしてマークするために呼ばれる。

**通知の受信者**：これは内部状態変更であり、外部への通知ではない。`potentially_outdated`マップにAnalUnitが追加され、PO依存カウントが設定される。

**通知内容の概要**：POとしてマークされたAnalUnitと、その原因となった依存先の情報が内部的に管理される。

**期待されるアクション**：PO状態のAnalUnitは、`findOutdatedToAnalyze`で選択された場合に再解析される。解析の結果、実際に変更があればoutdatedに遷移し、変更がなければPO状態から解除される。

## 通知種別

内部状態変更（マップ更新）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（内部状態更新） |
| 優先度 | - |
| リトライ | なし |

### 送信先決定ロジック

`markTransitiveDependersPotentiallyOutdated`関数で、指定されたAnalUnitの推移的依存元を列挙し、`potentially_outdated`マップに追加する。

## 通知テンプレート

該当なし（内部状態変更）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| unit | POとしてマークされるAnalUnit | AnalUnit | Yes |
| po_dep_count | PO依存のカウント | u32 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 依存先outdated | markDependeeOutdated完了 | 推移的依存元が存在 | outdated遷移後の連鎖処理 |
| リトライフラッシュ | flushRetryableFailures | 失敗したユニットの依存元 | リトライ対象の依存元 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にPOまたはoutdated | 重複マークを防止 |
| インクリメンタル無効 | 非インクリメンタルビルドでは追跡なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[markDependeeOutdated完了] --> B[markTransitiveDependersPotentiallyOutdated]
    B --> C[unitの依存元を列挙]
    C --> D[依存元ループ開始]
    D --> E{既にoutdatedまたはPO?}
    E -->|Yes| F[スキップ]
    E -->|No| G[potentially_outdatedに追加]
    G --> H[PO countを1に設定]
    H --> I[再帰的にPOマーク]
    I --> D
    F --> D
    D --> J[ループ終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| InternPool.deps | 依存関係の参照 | AnalUnit→依存元のマッピング |
| outdated | 既存のoutdated状態確認 | 重複防止 |
| potentially_outdated | PO状態の確認 | 重複防止 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| potentially_outdated | PUT | AnalUnitをPOとしてマーク、PO countを設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| OutOfMemory | マップ拡張時にメモリ不足 | エラーを伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

該当なし（内部処理）

## セキュリティ考慮事項

- 内部状態のみを変更し、外部への情報漏洩はない

## 備考

- PO状態は「古いかもしれない」という楽観的なマーク
- `findOutdatedToAnalyze`でPOユニットが選択されると、実際の解析が行われる
- 解析結果により、outdatedに遷移するか、PO状態から解除されるかが決まる
- PO countは、そのユニットがいくつのPO依存先を持つかを示す

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: PO状態の意味を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | 250-260行目: マップ定義とコメント |

**読解のコツ**: `outdated`はPO依存のカウントを値として持つが、`potentially_outdated`も同様にPO依存カウントを持つ。違いは、outdatedは確定的に古い状態、POは確認が必要な状態である。

#### Step 2: markTransitiveDependersPotentiallyOutdated関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Zcu.zig | `src/Zcu.zig` | markTransitiveDependersPotentiallyOutdated関数 |

**主要処理フロー**:
1. 指定されたAnalUnitの依存元を列挙
2. 既にoutdatedまたはPOでない場合、POに追加
3. 再帰的に推移的依存元もPOマーク

#### Step 3: findOutdatedToAnalyzeでの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Zcu.zig | `src/Zcu.zig` | 3180-3274行目: findOutdatedToAnalyze関数 |

**主要処理フロー**:
- **3200-3204行目**: outdated_readyが空の場合、POを含めて処理
- **3220-3270行目**: ループでPOユニットを選択する場合のヒューリスティック

### プログラム呼び出し階層図

```
markDependeeOutdated()
    │
    └─ markTransitiveDependersPotentiallyOutdated(depender) ← 本通知
           │
           ├─ ip.dependencyIterator(depender)
           │      └─ [依存元を列挙]
           │
           ├─ potentially_outdated.put(unit, 1)
           │
           └─ [再帰] markTransitiveDependersPotentiallyOutdated(unit)

flushRetryableFailures()
    │
    └─ markTransitiveDependersPotentiallyOutdated(depender) ← 本通知
```

### データフロー図

```
[入力]                     [処理]                           [出力]

outdatedになったUnit ───▶ markTransitive...()        ───▶ POマップ更新
        │                       │                           │
        ▼                       ▼                           ▼
  依存元列挙           各依存元をチェック          [未マーク] POに追加
        │                       │                     [既存] スキップ
        ▼                       ▼
  推移的依存元         再帰的にPOマーク     ───▶ 連鎖的にPO追加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zcu.zig | `src/Zcu.zig` | ソース | markTransitiveDependersPotentiallyOutdatedと状態マップ |
| InternPool.zig | `src/InternPool.zig` | ソース | 依存関係ストレージ |
