# 通知設計書 29-CImportSource

## 概要

本ドキュメントは、ZigコンパイラにおけるCインポートソース通知「CImportSource」の設計を記述する。

### 本通知の処理概要

本通知は、Zigコードから`@cImport`ビルトインを使用してCヘッダーファイルをインポートする際に、処理中のソースファイル情報を出力するデバッグログ通知である。`--verbose-cimport`フラグが有効な場合にのみ出力される。

**業務上の目的・背景**：Cコードとの相互運用性はZigの重要な機能の一つであり、`@cImport`によるCヘッダーのインポートは頻繁に使用される。このプロセスはClangを内部的に呼び出すため、問題が発生した場合のデバッグが困難になることがある。本通知により、開発者はCインポートの各段階を追跡し、問題の特定を容易にできる。

**通知の送信タイミング**：`cImport`関数（Compilation.zig内）が実行され、Cソースファイルが一時ファイルとして書き出された直後に出力される。

**通知の受信者**：`--verbose-cimport`フラグを指定してコンパイラを起動した開発者。通常はstderrに出力される。

**通知内容の概要**：書き出されたCインポートソースファイルのパスが含まれる。形式は`"writing C import source to {path}"`となる。

**期待されるアクション**：開発者は出力されたパスを確認し、必要に応じて一時ファイルの内容を調査できる。Cインポートの問題をデバッグする際に有用。

## 通知種別

ログ通知（info レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 中（info レベル） |
| リトライ | なし |

### 送信先決定ロジック

`comp.verbose_cimport`フラグがtrueの場合にのみ、`log.info`で出力される。

## 通知テンプレート

### ログメッセージ

| 項目 | 内容 |
|-----|------|
| ログレベル | info |
| スコープ | compilation |
| 表示色 | 緑色（info レベル） |

### 本文テンプレート

```
writing C import source to {path}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| path | Cソースファイルの出力パス | out_h_path | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンパイル処理 | @cImport実行 | verbose_cimport == true | Cヘッダーインポート時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `--verbose-cimport` フラグ未指定 | verbose_cimportがfalseの場合 |
| パス指定のcImport | source == .path の場合はこのメッセージは出力されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[@cImport実行] --> B[cImport関数呼び出し]
    B --> C{source種別?}
    C -->|.c_src| D[一時ファイルにCソース書き出し]
    C -->|.path| E[既存ファイルを使用]
    D --> F{verbose_cimport?}
    F -->|true| G[log.info: writing C import source]
    F -->|false| H[スキップ]
    G --> I[Clang translate-c実行]
    H --> I
    E --> I
    I --> J[結果をZigコードに変換]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ファイルシステム | CREATE | cimport.hファイルを一時ディレクトリに作成 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル書き込み失敗 | ディスク容量不足等 | エラーを伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 一時ファイルのパスがログに出力される
- ローカルキャッシュディレクトリ内のパスであり、センシティブな情報は含まれない

## 備考

- 一時ファイル名は常に`cimport.h`
- ファイルはローカルキャッシュディレクトリの一時サブディレクトリに作成される
- 処理完了後、キャッシュシステムにより管理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: verbose_cimportフラグを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 181行目: verbose_cimportフィールド定義 |
| 1-2 | main.zig | `src/main.zig` | 837行目, 1716-1717行目: フラグの解析 |

**読解のコツ**: `--verbose-cimport`コマンドラインフラグがCompilation構造体のフィールドにマップされる流れを追う。

#### Step 2: cImport関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 5768-5776行目: ソースファイル書き出しとログ出力 |

**主要処理フロー**:
- **5769行目**: `const cimport_basename = "cimport.h";`
- **5770行目**: 出力パスの構築
- **5771行目**: out_h_pathの生成
- **5773行目**: `if (comp.verbose_cimport) log.info("writing C import source to {s}", .{out_h_path});`（本通知）
- **5774行目**: ファイルの書き出し

#### Step 3: translate-C処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | 5821行目: 引数のダンプ（verbose_cimport時） |
| 3-2 | Compilation.zig | `src/Compilation.zig` | 5825行目: translateC呼び出し |

### プログラム呼び出し階層図

```
Sema.zirCImport()
    │
    └─ Compilation.cImport()
           │
           ├─ [source == .c_src の場合]
           │      │
           │      ├─ cimport_basename = "cimport.h"
           │      │
           │      ├─ out_h_path構築
           │      │
           │      ├─ [verbose_cimport] log.info("writing C import source") ← 本通知
           │      │
           │      └─ cache_dir.writeFile()
           │
           ├─ [verbose_cimport] dumpArgv() - Clang引数表示
           │
           ├─ main.translateC() - Clang呼び出し
           │
           └─ [後続処理]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

Cソースコード      ───▶ cimport.h生成              ───▶ 一時ファイル
(@cImportの引数)          │                               │
        │                 ▼                               ▼
        │          [verbose_cimport]              log.info出力
        │                 │                               │
        │                 ▼                               ▼
        └────────▶ Clang translate-C        ───▶ Zigコード生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | cImport関数の実装（本通知の発生元） |
| main.zig | `src/main.zig` | ソース | コマンドラインフラグの解析 |
| Sema.zig | `src/Sema.zig` | ソース | @cImportビルトインの処理 |
