# 通知設計書 3-info

## 概要

本ドキュメントは、Zigコンパイラにおけるinfoログ通知の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのコンパイル処理中のプログラム状態に関する一般的なメッセージをログとして出力する機能である。

**業務上の目的・背景**：コンパイル処理の進捗状況やユーザーへの情報提供を行うために必要である。情報ログはエラーや警告ではなく、処理の正常な進行状況やユーザーにとって有用な情報を伝達する。

**通知の送信タイミング**：コンパイル処理中の特定のマイルストーンに到達した時点で出力される。具体的には、ファイル作成完了、依存関係解決完了、初期化完了、クライアント接続などのイベント発生時にトリガーされる。

**通知の受信者**：コンパイラを実行しているユーザー、またはコンパイラの出力を監視しているシステム。ログは標準エラー出力（stderr）に出力される。

**通知内容の概要**：処理の進捗状況、作成されたファイル情報、解決された依存関係、接続されたクライアント情報などが含まれる。ログはANSIカラーコードにより緑色で表示され、視覚的に正常な情報であることを示す。

**期待されるアクション**：ユーザーは情報メッセージを確認し、処理が正常に進行していることを確認する。通常、特別なアクションは不要であるが、処理の進捗状況を把握するために参照される。

## 通知種別

ログ通知（標準エラー出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

ログ出力は固定で標準エラー出力（stderr）に送信される。`std.log.scoped(.xxx).info`または`log.info`関数を通じて出力される。

## 通知テンプレート

### ログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr |
| 色 | 緑色（ANSI escape code使用） |
| 形式 | テキスト |

### 本文テンプレート

```
info: {メッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | ログ通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 情報メッセージ | 各処理からの引数 | Yes |
| file_path | 関連ファイルパス | 処理対象ファイル | No |
| target | ターゲット情報 | コンパイルターゲット | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| CLI操作 | ヘルプ表示 | --help指定時 | 使用方法の表示 |
| CLI操作 | ファイル作成 | ファイル生成完了時 | テンプレートファイルの作成通知 |
| CLI操作 | 初期化完了 | zig init完了時 | プロジェクト初期化完了通知 |
| 内部処理 | libc提供可能通知 | ターゲット確認時 | 関連ターゲットでのlibc提供可能性 |
| 内部処理 | クライアント接続 | 接続検出時 | IncrementalDebugServerへのクライアント接続 |
| 内部処理 | Cインポート処理 | verbose_cimport有効時 | Cソースファイルの処理状況 |
| 内部処理 | 依存関係解決 | 解決完了時 | パッケージ依存関係の解決通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| verbose_cimportフラグ無効時 | Cインポート関連の情報ログは出力されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[イベント発生] --> B{verbose条件チェック}
    B -->|有効| C[log.info呼び出し]
    B -->|無効| D[スキップ]
    C --> E[フォーマット文字列展開]
    E --> F[ANSIカラーコード付与]
    F --> G[stderr出力]
    G --> H[処理継続]
    D --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ログ通知のためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ログ通知のためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 出力失敗 | stderrへの書き込み失敗 | 処理継続（情報ログのため） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル処理中は常時出力可能）

## セキュリティ考慮事項

- 情報メッセージにファイルパスが含まれる場合があるが、これはユーザーの作業環境情報であり、外部送信されない
- ログ出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- ログスコープ（.compilation等）によって出力元を識別可能
- ANSIカラーコードにより緑色で表示されるため、ターミナル上で視認性が高い
- verbose_cimportフラグにより、Cインポート関連の詳細情報出力を制御可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Zigのログシステムは標準ライブラリの`std.log`モジュールを使用している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std/log.zig | Zig標準ライブラリ | ログレベルの定義とscopedログの仕組み |

**読解のコツ**: `std.log.scoped`はコンパイル時にログスコープを生成する関数である。infoレベルはwarnより低く、debugより高い優先度を持つ。

#### Step 2: エントリーポイントを理解する

各モジュールでのlog変数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | std.log.info直接使用 |
| 2-2 | Compilation.zig | `src/Compilation.zig` | 11行目: log = std.log.scoped(.compilation) |
| 2-3 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | log変数定義 |

**主要処理フロー**:
1. **190行目 (main.zig)**: `std.log.info("{s}", .{usage});` - ヘルプ表示
2. **4801行目 (main.zig)**: `std.log.info("created {s}", .{template_path});` - ファイル作成通知

#### Step 3: 情報ログ呼び出し箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | 190, 390, 3627-3643, 4801-4850, 5498-5499, 7115-7337行目 |
| 3-2 | Compilation.zig | `src/Compilation.zig` | 5773, 5828, 5876行目（verbose_cimport条件付き） |
| 3-3 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 68, 100行目 |
| 3-4 | link/Dwarf.zig | `src/link/Dwarf.zig` | 990, 997, 1008行目 |

**主要処理フロー**:
- **5773行目 (Compilation.zig)**: Cインポートソース書き込み通知（verbose_cimport有効時）
- **68行目 (IncrementalDebugServer.zig)**: クライアント接続通知

### プログラム呼び出し階層図

```
std.log.info / std.log.scoped(.xxx).info
    │
    ├─ log.info(format, args)
    │      └─ std.log.log (内部ログ処理)
    │              └─ stderr.write
    │
    └─ 各処理でのイベント発生
           ├─ CLIコマンド処理
           ├─ ファイル操作完了
           ├─ クライアント接続
           └─ 依存関係解決
```

### データフロー図

```
[入力]               [処理]                    [出力]

イベント発生 ───▶ log.info(format, args) ───▶ stderr（緑色表示）
    │                    │
    │                    └─ 処理継続
    │
    └─ format: フォーマット文字列
    └─ args: 可変長引数（情報）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | CLIメイン、std.log.info多数使用 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理、verbose_cimport条件付きlog.info |
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバー処理、クライアント接続通知 |
| link/Dwarf.zig | `src/link/Dwarf.zig` | ソース | DWARFデバッグ情報処理 |
