# 通知設計書 30-DepFileProcessing

## 概要

本ドキュメントは、Zigコンパイラにおける依存ファイル処理通知「DepFileProcessing」の設計を記述する。

### 本通知の処理概要

本通知は、Cインポート処理中に生成された依存関係ファイル（.dファイル）を処理する際に出力されるデバッグログ通知である。`--verbose-cimport`フラグが有効な場合にのみ出力される。

**業務上の目的・背景**：`@cImport`でCヘッダーをインポートする際、Clangは依存関係ファイル（.dファイル）を生成することができる。このファイルには、インポートされたヘッダーが依存する他のヘッダーファイルのリストが含まれる。これらの依存関係をキャッシュシステムに登録することで、依存ファイルが変更された場合に適切に再コンパイルが行われる。本通知は、この依存ファイル処理の開始を示し、問題発生時のデバッグを支援する。

**通知の送信タイミング**：Clang translate-C処理が完了し、依存ファイル（.dファイル）が存在する場合に、そのファイルを処理する直前に出力される。

**通知の受信者**：`--verbose-cimport`フラグを指定してコンパイラを起動した開発者。通常はstderrに出力される。

**通知内容の概要**：処理対象の依存ファイルのパスが含まれる。形式は`"processing dep file at {path}"`となる。

**期待されるアクション**：開発者は依存ファイルの処理が行われていることを確認できる。依存関係の問題をデバッグする際に、どのファイルが処理されたかを追跡できる。

## 通知種別

ログ通知（info レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | 中（info レベル） |
| リトライ | なし |

### 送信先決定ロジック

`comp.verbose_cimport`フラグがtrueの場合にのみ、`log.info`で出力される。

## 通知テンプレート

### ログメッセージ

| 項目 | 内容 |
|-----|------|
| ログレベル | info |
| スコープ | compilation |
| 表示色 | 緑色（info レベル） |

### 本文テンプレート

```
processing dep file at {path}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| path | 依存ファイルのパス | dep_file_path | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Cインポート処理 | 依存ファイル処理開始 | verbose_cimport == true かつ out_dep_path != null | 依存ファイルが存在する場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `--verbose-cimport` フラグ未指定 | verbose_cimportがfalseの場合 |
| 依存ファイルなし | out_dep_path == null の場合 |
| 依存ファイル未発見 | FileNotFoundエラーの場合、処理自体がスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Clang translate-C完了] --> B{out_dep_path != null?}
    B -->|No| C[依存処理スキップ]
    B -->|Yes| D{verbose_cimport?}
    D -->|true| E[log.info: processing dep file]
    D -->|false| F[スキップ]
    E --> G[addDepFilePost呼び出し]
    F --> G
    G --> H{ファイル存在?}
    H -->|No - FileNotFound| I[処理終了]
    H -->|Yes| J[依存関係をキャッシュに追加]
    J --> K[whole_cacheにも追加]
    K --> L[.dファイル削除]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| ファイルシステム | 依存ファイルの読み込み | .dファイル |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Cache.Manifest | UPDATE | 依存ファイルの内容を追加 |
| whole_cache_manifest | UPDATE | 全体キャッシュにも追加（該当する場合） |
| ファイルシステム | DELETE | 処理後に.dファイルを削除 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| FileNotFound | 依存ファイルが存在しない | 処理をスキップ（正常終了扱い） |
| その他エラー | ファイル読み込み失敗等 | エラーを伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 一時ファイルのパスがログに出力される
- ローカルキャッシュディレクトリ内のパスであり、センシティブな情報は含まれない
- 依存ファイルは処理後に削除される（ディスク容量節約）

## 備考

- 依存ファイルはMakefile形式で、Clangが生成
- `addDepFilePost`関数で依存ファイルをパースし、キャッシュに追加
- 処理後、ディスク容量節約のため依存ファイルは削除される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 依存ファイル処理の位置を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 5827-5846行目: 依存ファイル処理ブロック |

**読解のコツ**: `if (out_dep_path) |dep_file_path| add_deps:`のラベル付きブロックで依存処理全体を囲んでいる。

#### Step 2: ログ出力を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 5828行目: log.info出力 |

**主要処理フロー**:
- **5827行目**: `if (out_dep_path) |dep_file_path| add_deps:`で依存パスが存在する場合にブロック開始
- **5828行目**: `if (comp.verbose_cimport) log.info("processing dep file at {s}", .{dep_file_path});`（本通知）
- **5830行目**: `dep_basename`の取得
- **5832行目**: `man.addDepFilePost`で依存ファイルをキャッシュに追加

#### Step 3: キャッシュ更新を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | 5837-5843行目: whole_cache_manifestへの追加 |
| 3-2 | Compilation.zig | `src/Compilation.zig` | 5846行目: 依存ファイルの削除 |

**主要処理フロー**:
- **5837-5843行目**: `CacheMode.whole`の場合、全体キャッシュにも追加
- **5846行目**: `cache_tmp_dir.deleteFile`で.dファイルを削除

### プログラム呼び出し階層図

```
cImport()
    │
    ├─ [Clang translate-C実行]
    │
    └─ [out_dep_path != null の場合]
           │
           ├─ [verbose_cimport] log.info("processing dep file") ← 本通知
           │
           ├─ man.addDepFilePost(cache_tmp_dir, dep_basename)
           │      └─ [依存ファイルをパースしてキャッシュに追加]
           │
           ├─ [CacheMode.whole の場合]
           │      └─ whole_cache_manifest.addDepFilePost()
           │
           └─ cache_tmp_dir.deleteFile(dep_basename)
                  └─ [ディスク容量節約のため削除]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

Clang生成.dファイル ───▶ [verbose_cimport?] ────▶ log.info出力
        │                       │
        ▼                       ▼
  依存ファイルパス      addDepFilePost() ────▶ Cacheマニフェスト更新
        │                       │
        │                       ▼
        │              [CacheMode.whole?] ───▶ whole_cache更新
        │                       │
        │                       ▼
        └─────────────────▶ deleteFile() ────▶ .dファイル削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | cImport関数の実装（本通知の発生元） |
| Cache.zig | `lib/std/Build/Cache.zig` | 標準ライブラリ | addDepFilePost関数の実装 |
| main.zig | `src/main.zig` | ソース | verbose_cimportフラグの解析 |
